/************************************************************
 *** OS2: This file contains additional routines          ***
 ***      only needed in the OS/2-version.                ***
 ***                                                      ***
 ***   last modified: 07/19/92                            ***
 ***   Authors:  Thilo Schuster (term@godot.stgt.sub.org) ***
 ***         Herbert Neugebauer (haen@veces.stgt.sub.org) ***
 ***                                                      ***
 ***  please send bug reports to haen@veces or term@godot ***
 ***                                                      ***
 ************************************************************/

/**************************************************
 **  this struct was picked out of the SNews     **
 **  source written by John McCombs, New Zealand **
 **   <john@ahuriri.gen.nz>. Parts of it were    **
 **  rewritten, to meet our requirements         **
 **************************************************/

#ifndef OS2_PATCHES
#define OS2_PATCHES

#ifndef BOOL_DEFINED
#define BOOL_DEFINED
#define bool char
#define bool_int int
#endif

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif

/* this is the data we get from the UUPC .rc files */
typedef struct {
    char temp_name[80];           /* temp files                    */
    char news_dir[80];            /* news base directory           */
    char mail_dir[80];            /* incoming mail directory       */
    char config_dir[80];          /* directory for configuration files  */
    char mailsent[80];            /* file in home, where sent mail is saved */
    char rmailpath[80];           /* path to rmail, including filename */
    char active[80];              /* the active file               */
    char active_opt[80];          /* the active file               */
    char active_times[80];        /* the active.times file         */
    char user[80];                /* current user id               */
    char mailfile[160];           /* mail_dir + user = mailfile    */
    char name[80];                /* users full name               */
    char domain[80];              /* our domain                    */
    char site[80];                /* site name                     */
    char organization[80];        /* organization                  */
    char mail_server[80];         /* where posts are routed to     */
    char editor[80];              /* system editor                 */
    char home[80];                /* home mail directory           */
    char signature[80];           /* signature file                */
    char newsadmin[80];           /* mailadress of local newsguru  */
    char trnlib[80];              /* location of trn-executables and logfiles*/
    char prefshell[160];          /* the name of your commandshell */
    char locdist[80];             /* distribution of your local computer */
    char orgdist[80];             /* dist. of your organization    */
    char citydist[80];            /* dist. of your city            */
    char statedist[80];           /* dist. of your state           */
    char countrydist[80];         /* dist. of your country         */
    char continentdist[80];       /* dist. of your continent       */
} INFO;


/********************************************************
 ** now we need a global variable which will containt  **
 ** the settings which are picked out of the rc-files  **
 ********************************************************/

#ifndef OS2_PATCHES_C
/*** Global Variables ***/
extern INFO uupc_rc_settings;

/*** new function calls ***/
extern void change_sl2bsl(char *changeString);
extern void change_bsl2sl(char *changeString);
extern int load_uupc_rc(void);
extern int make_newsrc(char *rcname, char *activename);
extern int article_saver(bool mailbox, char *fromname, char *tosavename);
extern FILE *fos2open(const char *filename, const char *mode);
extern void mail_reply(void);
extern void article_poster(void);
extern int unsub_group(char *pattern);
#endif

#endif /* OS2_PATCHES */
