/* $Id: nghash.c,v 3.0 1992/02/01 03:09:32 davison Trn $
 */
/*
 * This software is Copyright 1991 by Stan Barber.
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made.
 *
 * The author make no claims as to the fitness or correctness of this software
 * for any use whatsoever, and it is provided as is. Any use of this software
 * is at the user's own risk.
 */

#include "EXTERN.h"
#include "common.h"
#include "ndir.h"
#include "rcstuff.h"
#include "rn.h"
#include "intrp.h"
#include "final.h"
#include "rcln.h"
#include "util.h"
#ifdef SERVER
#include "server.h"
#endif
#include "ngdata.h"
#include "hdbm.h"

static HASHTABLE *acthash;
static char *actfile;

void
ngdatansrv_init()		/* non-SERVER initialisation */
{
    register long offset = 0;
    char *cp = ACTIVE;
    struct stat actstat;

    actfp = fos2open(cp, "r");
    if (actfp == Nullfp) {
        cp = ACTIVE_OPT;
        actfp = fos2open(cp,"r");
        if (actfp == Nullfp) {
	    printf(cantopen,cp) ; FLUSH;
	    finalize(1);
	}
    }


    /* rn was being a slug about rereading the active file over and
     * over; try using a really big buffer to keep it in core. */
    (void) fstat(fileno(actfp), &actstat);
    actfile = safemalloc(actstat.st_size + 1);
    rewind(actfp);
    /*
     * NOTE: this won't work on machines with ints too small to hold
     * the size of the active file.
     */
    if (fread(actfile, 1, (int)actstat.st_size, actfp) != actstat.st_size) {
	fprintf(stderr, "active file not read\n");
	actfile[0] = '\0';
    }
    rewind(actfp);
    actfile[actstat.st_size] = '\0';

    acthash = hdbmcreate((int)(actstat.st_size/40), (unsigned (*)())NULL);
    if (acthash == NULL) {
	fprintf(stderr, "can't hash %s\n", filexp(ACTIVE));
	finalize(1);
    }

    /* count entries */
    rewind(actfp);
    for (activeitems = 0; fgets(buf, LBUFLEN, actfp) != NULL; activeitems++) {
	register char *p = index(buf, ' ');
	HDBMDATUM key, data;

	/* key.dat_ptr must be allocated to make it permanent for hashstore */
	if (p == NULL)
	    p = buf;
	data.dat_ptr = key.dat_ptr = actfile + offset;
	key.dat_len = p - buf;
	data.dat_len = strlen(buf);
	if (!hdbmstore(acthash, key, data)) {
	    fprintf(stderr, "can't install hash key %s\n", key.dat_ptr);
	    finalize(1);
	}
	offset += data.dat_len;
    }
}

ACT_POS
findact(outbuf, nam, len, suggestion)
register char *outbuf;
register char *nam;
register int len;
register long suggestion;
{
    register ACT_POS retval;
    extern int debug;

    /* see if we know the right place and can just return */
    if (suggestion != 0 && fseek(actfp, suggestion, 0) >= 0
     && fgets(outbuf, 80, actfp) != NULL && outbuf[len] == ' '
     && strnEQ(outbuf, nam, len))
	return suggestion;

    /* hmm, apparently not, gotta look it up. */
    if (debug & DEB_SOFT_POINTERS)
	printf("Missed, looking for %s in %sLen = %d\n",nam,outbuf,len); FLUSH;
    /* can we just do a quick hashed lookup? */
    if (acthash != NULL) {
	HDBMDATUM key, data;

	outbuf[0] = '\0';
	key.dat_ptr = nam;
	key.dat_len = len;
	data = hdbmfetch(acthash, key);
	if (data.dat_ptr == NULL)
	    return -1;
	else {
	    (void) bcopy(data.dat_ptr, outbuf, (int)data.dat_len);
	    outbuf[data.dat_len] = '\0';
	    return data.dat_ptr - actfile;
	}
    }

    /* apparently not.  gotta do it the slow way. */
    (void) fseek(actfp, 0L, 0);
    for (retval = 0; fgets(outbuf,80,actfp) != NULL; retval += strlen(outbuf))
	if (outbuf[len] == ' ' && strnEQ(outbuf, nam, len))
	    break;
    if (ferror(actfp)) {
	perror("error on active file");
	sig_catcher(0);
	/* NOTREACHED */
    } else if (feof(actfp))
	return -1;	/* no such group */
    return retval;
}

