/*--------------------------------------------------------------------*/
/*Copyright 1994 Lars Olofsson                                        */
/*Last modified 1994-04-25 by Lars Olofsson <larso@wmute.trillium.se> */
/*                                                                    */
/*Please feel free to modify, changing 'Last Modified' above to       */
/*'Modified' and adding 'Last Modified' with date and your name.      */
/*                                                                    */
/*Description: Command to send file to receiver. Non "*.txt" files    */
/*             are uuencoded                                          */
/*Usage: GET <file>                                                   */
/*--------------------------------------------------------------------*/


/* This command requires the use of some UUENCODE program, here */
/* named uuencode, which creates a file with the extension of .UUE */

ARG arg1 arg2

IF arg1="" THEN CALL USAGE
IF arg2<>"" THEN CALL USAGE

input=LINEIN("fileserver.ini")
PARSE VAR input "=" filepath
file=filepath"\"arg1

/* Does the file exist at all ? */
IF STREAM(file,'c','query exists')="" THEN CALL NOTFOUND

/* Get the information on the second line of the user.ini file*/

input=LINEIN("user.ini")
input=LINEIN("user.ini")
PARSE VAR input "=" returnadress

/*Check file extension.*/

PARSE UPPER VAR arg1 WITH name "." extension
IF extension="TXT" THEN CALL TEXTFILE
ELSE CALL BINFILE

/*Send the textfile*/
TEXTFILE:
"@wmsend" file "-s " arg1 returnadress
SAY "Textfile" arg1 "sent to" returnadress
EXIT

/*UUEncode and send the binfile*/
BINFILE:

/* This loop removes any path from the filename */
sendfile=arg1
DO UNTIL LENGTH(sendfile)=0
   oldsendfile=sendfile
   PARSE VAR oldsendfile "\" sendfile
END
sendfile=oldsendfile

/*Send here */

"@uuencode" file
"@wmsend" sendfile".UUE -s " arg1 returnadress
SAY arg1 "sent to" returnadress
"@del" sendfile".UUE"
EXIT

USAGE:
SAY "There was an error in your specified command."
SAY "The correct usage is: GET <file>"

NOTFOUND:
SAY "File "arg1" not found."
