/* template.c - your comments here */

#ifndef	lint
static char *rcsid = "$Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/de.c,v 8.0 91/07/17 13:18:38 isode Rel $";
#endif

/* 
 * $Header: /a/vulcan/xtel/isode/isode-master/others/quipu/uips/de/RCS/de.c,v 8.0 91/07/17 13:18:38 isode Rel $
 *
 *
 * $Log:	de.c,v $
 * Revision 8.0  91/07/17  13:18:38  isode
 * Release 7.0
 * 
 * 
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */

/*****************************************************************************

  main.c

*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <pwd.h>
#include <signal.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>

#include "quipu/util.h"
#include "demanifest.h"
#include "bind.h"
#include "namelist.h"
#include "cnamelist.h"
#include "mapatts.h"
#include "mapphone.h"
#include "tailor.h"

static char *myname = "de";

LLog    _de_log = {
    "de.log", NULLCP, NULLCP, LLOG_FATAL | LLOG_EXCEPTIONS | LLOG_NOTICE,
            LLOG_NONE, -1, LLOGCLS | LLOGCRT | LLOGZER, NOTOK
};
LLog *de_log = &_de_log;


extern char *TidyString();
extern char *findHelp();
void searchFail(), exit(), onint1();

int boundToDSA = FALSE;
int limitProblem = FALSE;
int notAllReached = FALSE;
int alarmIndicator = FALSE;
int abandoned = FALSE;
int searchfail = FALSE;
int exactMatch;
int highNumber = 0;
int maxOrgs = 1;
int maxDepts = 1;
int maxPersons = 3;
int localAlarmTime = 15;
int remoteAlarmTime = 30;

struct cnamelist * cnamelp = NULLCNLIST;
struct mapnamelist * mapnamelp = NULLMNLIST;
struct mapphonelist * mapphonelp = NULLPHLIST;

struct namelist * orgatts = NULLLIST;
struct namelist * ouatts = NULLLIST;
struct namelist * prratts = NULLLIST;


/* Defaults for unspecified name parts */
char default_country[LINESIZE], default_organisation[LINESIZE],
     default_department[LINESIZE], default_person[LINESIZE],
     co[LINESIZE], org[LINESIZE], ou[LINESIZE], person[LINESIZE],
     origDefaultCo[LINESIZE], origDefaultOrg[LINESIZE],
     exactString[LINESIZE];
char * username;
jmp_buf sjbuf;

int main(argc, argv)
     int argc;
     char *argv[];
{
struct namelist * clp = NULLLIST, * olp = NULLLIST, * oulp = NULLLIST, 
                * plp = NULLLIST, * w, * x, * y;
SFD cleanupok();
int assoc;
int noCos = 0, noOrgs = 0, noDepts = 0, noPersons = 0;

/*  pdu_dump_init("/tmp"); */
  (void) printf("Connecting to the Directory - wait just a moment please ...\n");

  if (init_bind_to_ds(argc, argv, &assoc) != OK)
    exit(-1);

  ll_hdinit(de_log, myname);

  (void)strcpy(origDefaultCo, default_country);
  (void)strcpy(origDefaultOrg, default_organisation);

  welcome();
  
  for (;;) 
  {
    (void) setjmp(sjbuf);
    highNumber = 0;
    abandoned = FALSE;
    if (signal(SIGINT, SIG_IGN) != SIG_IGN)
      (void) signal(SIGINT, cleanupok);

    enterString(PERSON, default_person, plp);
    if ((strlen(person) == 1)  && (lexequ(person, "q") == 0))
      break;

    if (signal(SIGINT, SIG_IGN) != SIG_IGN)
      (void) signal(SIGINT, onint1);

    if (boundToDSA == FALSE)
      if (wait_bind_to_ds(assoc, FALSE) == NOTOK) /* don`t block */
        exit(-1);

enterorgunit:
    highNumber = 0; 
    enterString(ORGUNIT, default_department, oulp);

    if (boundToDSA == FALSE)
      if (wait_bind_to_ds(assoc, FALSE) == NOTOK) /* don't block */
        exit(-1);
enterorg:
    enterString(ORG, default_organisation, olp);
    highNumber = 0;
    if ((exactMatch != ORG) || 
        ((strcmp(org, default_organisation) != 0) && (exactMatch != ORG))
                            || (searchfail == TRUE) || (noOrgs == 0))
    {
entercountry:
      enterString(COUNTRY, default_country, clp);
    }

inputdone:
    /* look at the input strings and decide what sort of search or list 
       to do */

    /* must have entered a country */
    if (strlen(co) == 0)
    {
      if (strlen(org) == 0)
      {
        (void) printf("Must enter an organisation and country\n\n");
	goto enterorg;
      }
      else
      {
        (void) printf("Must enter a country\n\n");
	goto entercountry;
      }
    }

    /* set up defaults for next time round */
    /* note that the list default is converted to null */
    if (strcmp(person, "*") == 0)
      (void) strcpy(default_person, "");
    else
      (void) strcpy(default_person, person);
    if (strcmp(ou, "*") == 0)
      (void) strcpy(default_department, "");
    else
      (void) strcpy(default_department, ou);
    if (strcmp(org, "*") == 0)
      (void) strcpy(default_organisation, "");
    else
      (void) strcpy(default_organisation, org);
    if (strcmp(co, "*") == 0)
      (void) strcpy(default_country, "*");
    else
      (void) strcpy(default_country, co);

    /* do any freeing of lists */
    freeCos(&clp);
    freeOrgs(&olp);
    freeOUs(&oulp);
    freePRRs(&plp);

    if (boundToDSA == FALSE)
    {
      if (wait_bind_to_ds(assoc, TRUE) == NOTOK) /* block until bound */
        exit(-1);
#ifdef SPEC_MALL
      start_malloc_trace(0);
#endif
    }

    (void) ll_log (de_log, LLOG_NOTICE, NULLCP, "Search: co=%s, org=%s, ou=%s, cn=%s",
                           co, org, ou, person);
				   
    alarmIndicator = FALSE;
    searchfail = FALSE;

    pagerOn(NUMBER_ALLOWED);

    (void) listCos(co, &clp);
    if (strcmp(co, "*") == 0)
    {
      pageprint("\n  Found the following entries.  Please select one from the list\n");
      pageprint("by typing the number corresponding to the entry you want.\n\n");
      printListCos(co, clp);
      goto entercountry;
    }
    /* co must be a string of characters */
    noCos = listlen(clp);
    if (noCos != 1)
    {
      if (noCos > 1)
      {
        pageprint("\n  Got the following approximate matches.  Please select one from the list\n");
	pageprint("by typing the number corresponding to the entry you want.\n\n");
	printListCos(co, clp);
#ifdef SCOPE
	pageprint("\nCan only search one country at a time\n\n");
#endif
      }
      else
        pageprint("No countries match string `%s'\n\n", co);
	goto entercountry;
      }
      /* Still allows for more than one country to be searched per query.
         The matter is still under consideration! */
      for (w = clp; w != NULLLIST; w = w->next)
      {
        printLastComponent(INDENTON, w->name, COUNTRY, 0);
        if ((strlen(org) == 0) && (strlen(ou) == 0) && (strlen(person) == 0))
	{
	  /* nothing much to print 
	  pageprint("Print details for %s\n", w->name); */
	  continue;
	}

        if (strlen(org) == 0)
	{
/*          highNumber = 0;*/
	  enterString(ORG, default_organisation, olp);
	  goto inputdone;
	}
        /* either a * or an org name entered - let's do the search */
        if (listOrgs(w->name, org, &olp) != OK)
          searchFail(org);
	else
	{
	  noOrgs = listlen(olp);
          if (strcmp(org, "*") == 0)
	  {
            pageprint("\nFound the following entries.  Please select one from the list\n");
	    pageprint("by typing the number corresponding to the entry you want.\n\n");
	    printListOrgs(org, olp);
/*            enterString(ORG, default_organisation, olp);
	    goto inputdone; */
	    goto enterorg;
	  }
	  /* got a purported org name - did we get any matches? */
          if (noOrgs == 0)
	  {
            pageprint("  No organisations match string `%s'\n\n", org);
/*	    enterString(ORG, default_organisation, olp);
	    goto inputdone; */
	    goto enterorg;
	  }
          if (noOrgs > maxOrgs)
	  {
            pageprint("\nGot the following approximate matches.  Please select one from the list\n");
	    pageprint("by typing the number corresponding to the entry you want.\n\n");
	    printListOrgs(org, olp);
#ifdef SCOPE
	    pageprint("\n  Up to a maximum of %d organisation(s) searched per query\n\n",
	           maxOrgs);
#endif
/*            enterString(ORG, default_organisation, olp);
	    goto inputdone; */
	    goto enterorg;
	  }
          for (x = olp; x != NULLLIST; x = x->next)
          {
            printLastComponent(INDENTON, x->name, ORG, 0);
            if (strlen(ou) == 0)
            {
              if (strlen(person) != 0)
                if (listPRRs(x->name, person, &plp) != OK)
  	          searchFail(person);
                else
		{
                  noPersons = listlen(plp);
        	  if (noPersons == 0)
		    pageprint("      No persons match string `%s'\n", person);
		  else if (noPersons > maxPersons)
		  {
                    pageprint("\nGot the following approximate matches.  Please select one from the list\n");
	            pageprint("by typing the number corresponding to the entry you want.\n\n");
		    printListPRRs(person, plp, ORG, FALSE);
		    enterString(PERSON, default_person, plp);
		    if ((strlen(person) == 1)  && (lexequ(person, "q") == 0))
		      goto quit;
                    if (exactMatch == PERSON)
  		      goto inputdone;
		    else
		      goto enterorgunit;
		  }
		  else
		  {
                    printListPRRs(person, plp, ORG, TRUE); /* true means print details */
		  }
		  freePRRs(&plp);
		}
	      else
	        printDetails(ORG, x);
            }
            else
  	    {
  	      if (listOUs(x->name, ou, &oulp) != OK)
	        searchFail(ou);
              else
	      {
                if (strcmp(ou, "*") == 0)
		{
                  if ((listlen(oulp) == 0) && (strlen(person) != 0))
                  {
                    if (listPRRs(x->name, person, &plp) != OK)
  	              searchFail(person);
                    else
		    {
                      noPersons = listlen(plp);
        	      if (noPersons == 0)
		        pageprint("      No persons match string `%s'\n", person);
		      else if (noPersons > maxPersons)
		      {
                        pageprint("\nFound the following entries.  Please select one from the list\n");
	                pageprint("by typing the number corresponding to the entry you want.\n\n");
		        printListPRRs(person, plp, ORG, FALSE);
		        enterString(PERSON, default_person, plp);
		        if ((strlen(person) == 1)  && (lexequ(person, "q") == 0))
		          goto quit;
                        if (exactMatch == PERSON)
  		          goto inputdone;
		        else
		          goto enterorgunit;
		      }
		      else
		      {
                        printListPRRs(person, plp, ORG, TRUE); /* true means print details */
		      }
		      freePRRs(&plp);
                      continue;
		    }
                  }
                  else
                  {
                    pageprint("\nFound the following entries.  Please select one from the list\n");
	            pageprint("by typing the number corresponding to the entry you want.\n\n");
		    printListOUs(ou, oulp);
		    if (strlen(person) == 0)
		    {
		      freeOUs(&oulp);
		      continue;
		    }
		    else
		    {
		      enterString(ORGUNIT, default_department, oulp);
		      goto inputdone;
		    }
                  }
		}
		/* got a purported dept name - any matches? */
		noDepts = listlen(oulp);
		if (noDepts == 0)
		{
                  pageprint("    No departments match string `%s'\n", ou);
		  enterString(ORGUNIT, default_department, oulp);
		  goto inputdone;
		}
                if (noDepts > maxDepts)
                {
                  pageprint("\nGot the following approximate matches.  Please select one from the list\n");
	          pageprint("by typing the number corresponding to the entry you want.\n\n");
	          printListOUs(ou, oulp);
#ifdef SCOPE
	          pageprint("\n  Up to a maximum of %d department(s) searched per query\n\n",
	            maxDepts);
#endif
                  enterString(ORGUNIT, default_department, oulp);
	          goto inputdone;
	        }
                for (y = oulp; y != NULLLIST; y = y->next)
                {
                  printLastComponent(INDENTON, y->name, ORGUNIT, 0);
                  if (strlen(person) != 0)
                    if (listPRRs(y->name, person, &plp) != OK)
	              searchFail(person);
                    else
		    {
                      noPersons = listlen(plp);
		      if (noPersons == 0)
		      {
		        pageprint("      No persons match string `%s'\n", person);
		      }
		      else if (noPersons > maxPersons)
		      {
		        if (strcmp(person, "*") == 0)
			{
                          pageprint("\nFound the following entries.  Please select one from the list\n");
	                  pageprint("by typing the number corresponding to the entry you want.\n\n");
			}
			else
			{
                          pageprint("\nGot the following approximate matches.  Please select one from the list\n");
	                  pageprint("by typing the number corresponding to the entry you want.\n\n");
			}
		        printListPRRs(person, plp, ORGUNIT, FALSE);
			enterString(PERSON, default_person, plp);
			if ((strlen(person) == 1)  && (lexequ(person, "q") == 0))
			  goto quit;
                        if (exactMatch == PERSON)
			  goto inputdone;
			else
			  goto enterorgunit;
		      }
		      else
		      {
                        printListPRRs(person, plp, ORGUNIT, TRUE);
		      }
		      freePRRs(&plp);
		    }
                  else
		    printDetails(ORGUNIT, y);
		}
		freeOUs(&oulp);
	      }
	    }
	  }
	  freeOrgs(&olp);
	}
      }
      freeCos(&clp);
  }
quit:
  if (boundToDSA == TRUE)
  {
#ifdef SPEC_MALL
    stop_malloc_trace();
#endif
    (void) de_unbind();
  }
  exit(0);
  return 0;
  /* and that's all for now */
}

enterString(objectType,defaultValue, lp)
int objectType;
char * defaultValue;
struct namelist * lp;
{
char prompt[LINESIZE];
static char prstr[] = ":-";

  switch(objectType)
  {
    case PERSON:
      (void) sprintf(prompt, "Person's name, q to quit, ");
      if (strlen(defaultValue) != 0)
        (void) sprintf(prompt, "%s<CR> for `%s', ", prompt, defaultValue);
      (void) sprintf(prompt, "%s* to list people, ? for help\n%s", prompt, prstr);
      enterAndValidate(prompt, person, objectType, defaultValue, lp);
      break;
    case ORGUNIT:
        (void) strcpy(prompt, "Dept name, * to list depts, ");
        if (strcmp(default_department, "*") == 0)
          (void) sprintf(prompt, "%s<CR> to list all depts, ", prompt);
	else
	{
	  if (strlen(default_department) == 0)
	  {
	    if (strlen(person) != 0)
	      (void) sprintf(prompt, "%s<CR> to search all depts, ", prompt);
	  }
	  else
	  {
            (void) strcat(prompt, "- to search all departments,\n           ");
	    (void) sprintf(prompt, "%s<CR> to search for `%s', ", prompt, default_department);
	  }
	}
        (void) sprintf(prompt, "%s? for help\n%s", prompt, prstr);
        enterAndValidate(prompt, ou, objectType, defaultValue, lp);
        break;
    case ORG:
        (void) sprintf(prompt, "Organisation name, ");
	if (strcmp(default_organisation, "") != 0)
	  (void) sprintf(prompt, "%s<CR> to search `%s', ", prompt,
	                                             default_organisation);
        (void) strcat(prompt, "* to list orgs, ");
        (void) sprintf(prompt, "%s? for help\n%s", prompt, prstr);
        enterAndValidate(prompt, org, objectType, defaultValue, lp);
        break;
    case COUNTRY:
        (void) sprintf(prompt, "Country name, ");
	if (strcmp(default_country, "") != 0)
	  (void) sprintf(prompt, "%s<CR> to search `%s', ", prompt, default_country);
        (void) strcat(prompt, "* to list countries, ");
        (void) sprintf(prompt, "%s? for help\n%s", prompt, prstr);
        enterAndValidate(prompt, co, objectType, defaultValue, lp);
        break;
    default:
      (void) fprintf(stderr, "Unknown type in enterString\n");
      break;
  }
}


enterAndValidate(prompt, buf, objectType, defaultValue, lp)
char * prompt, * buf;
int objectType;
char * defaultValue;
struct namelist * lp;
{
char * cp, * cp2;
int i, n, isnum;

  /* this picks up any number that was entered at the pager prompt */
  if ((n = getpnum()) != -1)
  {
    if ((n > highNumber) || (n < 1)) /* check number against valid range */
    {
      if (highNumber > 0)
        (void) fprintf(stderr, "Invalid number entered (maximum = %d)\n\n", highNumber);
      else
	(void) fprintf(stderr, "No list of entries current.  Entry of a number invalid\n");
    }
    else /* valid number */
    {
      for (i = 1; i < n; i++, lp = lp->next) {};
      cp = copy_string(lastComponent(lp->name, objectType));
      exactMatch = objectType;
      (void) strcpy(exactString, lp->name);
      (void) strcpy(buf, cp);
      free(cp);
      return;
    }
  }

  for (;;)
  {
    exactMatch = -1;
    writeInverse(prompt);
    (void) putchar(' ');
    if (gets(buf) == NULLCP)
      if (objectType == PERSON)
        /* exit the program */
        cleanup(0);
      else
      {
        /* behave as for an interrupt */
	clearerr(stdin);
        onint1();
      }
    cp = copy_string(TidyString(buf));
    if (strlen(cp) == 0) /* default accepted */
    {
      free(cp);
      cp = copy_string(defaultValue);
      break;
    }
    /* if "-" entered, convert this to a null entry, unless entering a 
       country.  In this case, "-" is treated as search international orgs */
    if (objectType != COUNTRY)
      if (strcmp(cp, "-") == 0)
      {
        *cp ='\0';
	break;
      }
    if (strcmp(cp, "?") == 0) /* help on current input requested */
    {
      switch (objectType)
      {
        case PERSON:
          displayHelp("name");
	  break;
	case ORGUNIT:
	  displayHelp("department");
	  break;
	case ORG:
	  displayHelp("organisation");
	  break;
	case COUNTRY:
	  displayHelp("country");
	  break;
      }
      continue;
    }
    if (*cp == '?') /* help on some other specific topic requested */
    {
      for (cp++; *cp == ' '; cp++) {};
      if ((lexequ(cp, "?") == 0) || (lexequ(cp, "help") == 0)) /* help about help requested */
        displayHelp("help");
      else 
        displayHelp(findHelp(cp));
      continue;
    }

    /* if a number has been entered, check that it is in range, and 
       map the number onto the appropriate name */
    isnum = TRUE;
    for (cp2 = cp; *cp2 != '\0'; cp2++)
    {
      if (! isdigit(*cp2))
      {
        isnum = FALSE;
	break;
      }
    }
    if (isnum)
    {
      n = atoi(cp);
      if ((n > highNumber) || (n < 1)) /* check number against valid range */
      {
        if (highNumber > 0)
          (void) fprintf(stderr, "Invalid number entered (maximum = %d)\n\n", highNumber);
	else
	  (void) fprintf(stderr, "No list of entries current.  Entry of a number invalid\n");
	continue;
      }
      else
      {
	for (i = 1; i < n; i++, lp = lp->next) {};
	free(cp);
	cp = copy_string(lastComponent(lp->name, objectType));
        exactMatch = objectType;
	(void) strcpy(exactString, lp->name);
      }
    }

    if (index(cp, '*') == 0) /* no wild cards */
      break; 

    if (*cp == '*')
    {
      if (strlen(cp) == 1)
        break;
      cp2 = index(cp + 1, '*');
      if (cp2 == NULLCP)
        break;
      if (cp2 == cp + 1) /* i.e. string is ** */
      {
        displayValidWildCards();
	free(cp);
	continue;
      }
      if (*(cp2 + 1) != '\0')
      {
        displayValidWildCards();
	free(cp);
        continue;
      }
      break;
    }
    /* string has at least one asterisk - make sure it's only one */
    if (index(cp, '*') == rindex(cp, '*'))
      break;
    else
    {
      displayValidWildCards();
      free(cp);
      continue;
    }
  }
  (void) strcpy(buf, cp);
  free(cp);
}

displayValidWildCards()
{
  (void) printf("The following wild-card formats are acceptable:\n");
  (void) printf("\t*\n\txxx*\n\t*xxx*\n\t*xxx\n\txx*xx\n\n");
}

countryCodeMessage(str)
{
  (void) printf("<%s> is not a valid two-letter country code.\n", str);
  (void) printf("Either enter a valid two-letter code, or enter the country name more fully.\n\n", str);
}

void
onint1()
{
  (void) putchar('\n');
  /* simulate search failure - 
     this ensures that the "country question" is asked */
  searchfail = TRUE;
  longjmp(sjbuf, 0);
}

SFD cleanupok()
{
  cleanup(0);
}

int
cleanup(exitCode)
int exitCode;
{
  if (boundToDSA == TRUE)
    (void) de_unbind(); 
#ifdef SPEC_MALL
  stop_malloc_trace();
#endif
  exit(exitCode);
}

void
onalarm()
{
  if (alarmIndicator == FALSE)
    (void) printf("\nThis operation seems to be taking some time.  Maybe a server is down?\nControl-C, if you wish to abandon the operation.\n\n");
  alarmIndicator = TRUE;
}

void
searchFail(str)
char * str;
{
  searchfail = TRUE;
  if (abandoned)
    (void) printf("\nSearch abandoned\n");
  else
  {
    (void) printf("\nThe search ");
    if (strcmp(str, "*") != 0)
      (void) printf("for '%s' ", str);
    (void) printf("has failed, probably because a Directory \n");
    (void) printf("server is unavailable.  Try again a little later.\n\n");
  }
}
