
      SUBROUTINE ORTHS5 ( X, Y )
C     ----------------------------
      DOUBLE PRECISION     X (6), Y (6)
C     ----------------------------------------------------------------------
C     |  Returns a random unit vector y (6), which is orthogonal to x (6), |
C     |  but otherwise uniformly distributed over the unit 5-sphere (S5).  |
C     ----------------------------------------------------------------------
      INTEGER  I
      DOUBLE PRECISION     FACTOR, XSQ, XY


 1    CONTINUE

C     ----------------------------------------------------------------
C     |  Generate y (6) with uniform distribution on unit 5-shpere:  |
C     ----------------------------------------------------------------
        CALL RANDS5 ( Y )

C     -------------------------------------------------------
C     |  Project out the part of y(6) orthogonal to x(6) :  |
C     |      y --> y - x {(x.y) / (x.x)}                    |
C     -------------------------------------------------------
        XSQ = 0.0
        XY  = 0.0
        DO 10  I = 1, 6
          XSQ = XSQ +  (X (I) * X (I))
          XY  = XY  +  (X (I) * Y (I))
 10     CONTINUE
        FACTOR = XY / XSQ

C------ check that y is not parallel to x - if it is, repeat from the start.

      IF  ((1.0 - ABS (FACTOR))  .LT.  0.001)   GO TO 1
      DO 20  I = 1, 6
        Y (I) = Y (I) - FACTOR * X (I)
 20   CONTINUE

C     -------------------------------------
C     |  Renormalise y(6) to unit length  |
C     -------------------------------------
      CALL RENORM (Y)

      END
