# define ID 257
# define MONTH 258
# define DAYOFWEEK 259
# define MERIDIAN 260
# define NUMBER 261
# define ZONE 262
# define DAYZONE 263

# line 3 "stringtotime.y"

/*  Vince  Cate  11/9/91  
 *
 *  Simplified a bit - no more shift/reduce conflicts.
 */

/*      Steven M. Bellovin (unc!smb)                    */
/*      Dept. of Computer Science                       */
/*      University of North Carolina at Chapel Hill     */
/*      @(#)getdate.y   2.13    9/16/86                 */

/*      defining malloc in one of the following can cause problems if you do 
 *      a "make noyacc" because you do not have yacc  */
#include "alexincs.h"
#include "alex.h"

#define daysec (24L*60L*60L)

static int timeflag, zoneflag, dateflag, yearflag;
static int hh, mm, ss, merid, daylightsvs;
static int month, day, year;
static int ourzone;

#define AM 1
#define PM 2
#define DAYLIGHT 1
#define STANDARD 2
#define MAYBE    3
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256

# line 86 "stringtotime.y"


static int mdays[12] =
        {31, 0, 31,  30, 31, 30,  31, 31, 30,  31, 30, 31};

#define epoch 1970

extern struct tm *localtime();
time_t dateconv(mm, dd, yy, h, m, s, mer, zone, daylightsvs)
int mm, dd, yy, h, m, s, mer, zone, daylightsvs;
{
    time_t tod, jdate;
    register int i;
    time_t timeconv();

    if (yy < 0) yy = -yy;
    if (yy < 100) yy += 1900;
    mdays[1] = 28 + (yy%4 == 0 && (yy%100 != 0 || yy%400 == 0));
    if (yy < epoch || yy > 1999 || mm < 1 || mm > 12 ||
            dd < 1 || dd > mdays[--mm]) return (-1);
    jdate = dd-1;
    for (i=0; i<mm; i++) jdate += mdays[i];
    for (i = epoch; i < yy; i++) jdate += 365 + (i%4 == 0);
    jdate *= daysec;
    jdate += zone * 60L;
    if ((tod = timeconv(h, m, s, mer)) < 0) return (-1);
    jdate += tod;
    if (daylightsvs==DAYLIGHT ||(daylightsvs==MAYBE&&localtime(&jdate)->tm_isdst))
        jdate += -1*60*60;
    return (jdate);
}


time_t timeconv(hh, mm, ss, mer) register int hh, mm, ss, mer;
{
    if (mm < 0 || mm > 59 || ss < 0 || ss > 59) return (-1);
    switch (mer) {
        case AM: if (hh < 1 || hh > 12) return(-1);
                 return (60L * ((hh%12)*60L + mm)+ss);
        case PM: if (hh < 1 || hh > 12) return(-1);
                 return (60L * ((hh%12 +12)*60L + mm)+ss);
        case 24: if (hh < 0 || hh > 23) return (-1);
                 return (60L * (hh*60L + mm)+ss);
        default: return (-1);
    }
}


static char *lptr;

yylex()
{
    extern int yylval;
    register char c;
    register char *p;
    char idbuf[20];
    int pcnt;

    for (;;) {
        while (isspace(*lptr)) lptr++;

        if (isdigit(c = *lptr)) {
            yylval = 0;
            while (isdigit(c = *lptr++)) yylval = 10*yylval + c - '0';
                lptr--;
            return (NUMBER);

        } else if (isalpha(c)) {                      
            p = idbuf;
            while (isalnum(c = *lptr++) || c=='.' || c=='+' || c=='-') {
                if (p < &idbuf[sizeof(idbuf)-1]) {
                    *p++ = c;
                }
            }
            *p = '\0';
            lptr--;
            return (lookup(idbuf));

        } else if (c == '(') {                  /* ignore anything in parens */
            pcnt = 0;
            do {
                c = *lptr++;
                if (c == '\0') return(c);
                else if (c == '(') pcnt++;
                else if (c == ')') pcnt--;
            } while (pcnt > 0);

        } else {
            return (*lptr++);
        }
    }
}

struct table {
    char *name;
    int type, value;
};

struct table mdtab[] = {       /* user can abreviate with just first 3 chars */
        {"January", MONTH, 1},
        {"February", MONTH, 2},
        {"March", MONTH, 3},
        {"April", MONTH, 4},
        {"May", MONTH, 5},
        {"June", MONTH, 6},
        {"July", MONTH, 7},
        {"August", MONTH, 8},
        {"September", MONTH, 9},
        {"October", MONTH, 10},
        {"November", MONTH, 11},
        {"December", MONTH, 12},

        {"Sunday", DAYOFWEEK, 0},
        {"Monday", DAYOFWEEK, 1},
        {"Tuesday", DAYOFWEEK, 2},
        {"Wednesday", DAYOFWEEK, 3},
        {"Thursday", DAYOFWEEK, 4},
        {"Friday", DAYOFWEEK, 5},
        {"Saturday", DAYOFWEEK, 6},
        {0, 0, 0}};

#define HRS *60
#define HALFHR 30
struct table mztab[] = {           /* meridian and zones - always full length */
        {"a.m.", MERIDIAN, AM},
        {"am", MERIDIAN, AM},
        {"p.m.", MERIDIAN, PM},
        {"pm", MERIDIAN, PM},
        {"nst", ZONE, 3 HRS + HALFHR},          /* Newfoundland */
        {"n.s.t.", ZONE, 3 HRS + HALFHR},
        {"ast", ZONE, 4 HRS},           /* Atlantic */
        {"a.s.t.", ZONE, 4 HRS},
        {"adt", DAYZONE, 4 HRS},
        {"a.d.t.", DAYZONE, 4 HRS},
        {"est", ZONE, 5 HRS},           /* Eastern */
        {"e.s.t.", ZONE, 5 HRS},
        {"edt", DAYZONE, 5 HRS},
        {"e.d.t.", DAYZONE, 5 HRS},
        {"cst", ZONE, 6 HRS},           /* Central */
        {"c.s.t.", ZONE, 6 HRS},
        {"cdt", DAYZONE, 6 HRS},
        {"c.d.t.", DAYZONE, 6 HRS},
        {"mst", ZONE, 7 HRS},           /* Mountain */
        {"m.s.t.", ZONE, 7 HRS},
        {"mdt", DAYZONE, 7 HRS},
        {"m.d.t.", DAYZONE, 7 HRS},
        {"pst", ZONE, 8 HRS},           /* Pacific */
        {"p.s.t.", ZONE, 8 HRS},
        {"pdt", DAYZONE, 8 HRS},
        {"p.d.t.", DAYZONE, 8 HRS},
        {"yst", ZONE, 9 HRS},           /* Yukon */
        {"y.s.t.", ZONE, 9 HRS},
        {"ydt", DAYZONE, 9 HRS},
        {"y.d.t.", DAYZONE, 9 HRS},
        {"hst", ZONE, 10 HRS},          /* Hawaii */
        {"h.s.t.", ZONE, 10 HRS},
        {"hdt", DAYZONE, 10 HRS},
        {"h.d.t.", DAYZONE, 10 HRS},

        {"gmt",      ZONE,  0 HRS},
        {"gmt+000",  ZONE,  0 HRS},
        {"gmt+100",  ZONE,  1 HRS},
        {"gmt+200",  ZONE,  2 HRS},
        {"gmt+300",  ZONE,  3 HRS},
        {"gmt+400",  ZONE,  4 HRS},
        {"gmt+500",  ZONE,  5 HRS},
        {"gmt+600",  ZONE,  6 HRS},
        {"gmt+700",  ZONE,  7 HRS},
        {"gmt+800",  ZONE,  8 HRS},
        {"gmt+900",  ZONE,  9 HRS},
        {"gmt+1000", ZONE, 10 HRS},
        {"gmt+1100", ZONE, 11 HRS},
        {"gmt+1200", ZONE, 12 HRS},
        {"gmt-100",  ZONE, -1 HRS},
        {"gmt-200",  ZONE, -2 HRS},
        {"gmt-300",  ZONE, -3 HRS},
        {"gmt-400",  ZONE, -4 HRS},
        {"gmt-500",  ZONE, -5 HRS},
        {"gmt-600",  ZONE, -6 HRS},
        {"gmt-700",  ZONE, -7 HRS},
        {"gmt-800",  ZONE, -8 HRS},
        {"gmt-900",  ZONE, -9 HRS},
        {"gmt-1000", ZONE, -10 HRS},
        {"gmt-1100", ZONE, -11 HRS},
        {"g.m.t.", ZONE, 0 HRS},
        {"bst", DAYZONE, 0 HRS},                /* British Summer Time */
        {"b.s.t.", DAYZONE, 0 HRS},
        {"eet", ZONE, 0 HRS},           /* European Eastern Time */
        {"e.e.t.", ZONE, 0 HRS},
        {"eest", DAYZONE, 0 HRS},       /* European Eastern Summer Time */
        {"e.e.s.t.", DAYZONE, 0 HRS},
        {"met", ZONE, -1 HRS},          /* Middle European Time */
        {"m.e.t.", ZONE, -1 HRS},
        {"mest", DAYZONE, -1 HRS},      /* Middle European Summer Time */
        {"m.e.s.t.", DAYZONE, -1 HRS},
        {"wet", ZONE, -2 HRS },         /* Western European Time */
        {"w.e.t.", ZONE, -2 HRS },
        {"west", DAYZONE, -2 HRS},      /* Western European Summer Time */
        {"w.e.s.t.", DAYZONE, -2 HRS},

        {"jst", ZONE, -9 HRS},          /* Japan Standard Time */
        {"j.s.t.", ZONE, -9 HRS},       /* Japan Standard Time */
                                        /* No daylight savings time */

        {"aest", ZONE, -10 HRS},        /* Australian Eastern Time */
        {"a.e.s.t.", ZONE, -10 HRS},
        {"aesst", DAYZONE, -10 HRS},    /* Australian Eastern Summer Time */
        {"a.e.s.s.t.", DAYZONE, -10 HRS},
        {"acst", ZONE, -(9 HRS + HALFHR)},      /* Australian Central Time */
        {"a.c.s.t.", ZONE, -(9 HRS + HALFHR)},
        {"acsst", DAYZONE, -(9 HRS + HALFHR)},  /* Australian Central Summer */
        {"a.c.s.s.t.", DAYZONE, -(9 HRS + HALFHR)},
        {"awst", ZONE, -8 HRS},         /* Australian Western Time */
        {"a.w.s.t.", ZONE, -8 HRS},     /* (no daylight time there, I'm told */
        {0, 0, 0}};

struct table milzone[] = {
        {"a", ZONE, 1 HRS},
        {"b", ZONE, 2 HRS},
        {"c", ZONE, 3 HRS},
        {"d", ZONE, 4 HRS},
        {"e", ZONE, 5 HRS},
        {"f", ZONE, 6 HRS},
        {"g", ZONE, 7 HRS},
        {"h", ZONE, 8 HRS},
        {"i", ZONE, 9 HRS},
        {"k", ZONE, 10 HRS},
        {"l", ZONE, 11 HRS},
        {"m", ZONE, 12 HRS},
        {"n", ZONE, -1 HRS},
        {"o", ZONE, -2 HRS},
        {"p", ZONE, -3 HRS},
        {"q", ZONE, -4 HRS},
        {"r", ZONE, -5 HRS},
        {"s", ZONE, -6 HRS},
        {"t", ZONE, -7 HRS},
        {"u", ZONE, -8 HRS},
        {"v", ZONE, -9 HRS},
        {"w", ZONE, -10 HRS},
        {"x", ZONE, -11 HRS},
        {"y", ZONE, -12 HRS},
        {"z", ZONE, 0 HRS},
        {0, 0, 0}};

lookup(id) 
char *id;
{
#define gotit (yylval=i->value,  i->type)
#define getid for(j=idvar, k=id;   *j++ = *k++;      )    /* fresh copy */

    char idvar[20];
    register char *j, *k;
    register struct table *i;

    getid;
    for (i = mdtab; i->name; i++) {
        if (strncasecmp(idvar, i->name, 3) == 0) {
            return gotit;
        }
    }

    getid;
    for (i = mztab; i->name; i++)
        if (strcmp(i->name, idvar) == 0) return gotit;

    for (j = idvar; *j; j++)
        if (isupper(*j)) *j = tolower(*j);
    for (i=mztab; i->name; i++)
        if (strcmp(i->name, idvar) == 0) return gotit;

    getid;
    if (strlen(idvar) == 1 && isalpha(*idvar)) {
        if (isupper(*idvar)) *idvar = tolower(*idvar);
        for (i = milzone; i->name; i++) {
            if (strcmp(i->name, idvar) == 0) return gotit;
        }
    }

    return(ID);
}

#define mcheck(f)       if (f>1) err++

int StringToTimeb(p, Now, Result) 
char *p; 
struct timeb *Now, *Result;
{
    int err;
    struct tm *lt;
    struct timeb ftz;
    time_t sdate;

    lptr = p;
    if (Now == ((struct timeb *) NULL)) {
        Now = &ftz;
        ftime(&ftz);
    }
    lt = localtime(&Now->time);
    year = lt->tm_year;
    month = lt->tm_mon+1;
    day = lt->tm_mday;
    timeflag=zoneflag=dateflag=yearflag=0;
    ourzone = Now->timezone;
    daylightsvs = MAYBE;
    hh = mm = ss = 0;
    merid = 24;

    err=yyparse();
    if (err) {
        Log2("StringToTimeb could not parse date ", p);
        return(AFAIL);
    }

    mcheck(timeflag);               /* each of these should be at most 1 */
    mcheck(zoneflag);
    mcheck(dateflag);
    mcheck(yearflag);

    if (err) {
        Log2("StringToTimeb ERROR parsed some type of field twice", p);
        return(AFAIL);
    }
    if (!dateflag && !timeflag) {   
        Log2("StringToTimeb ERROR did not find a major item in string ", p);
        return(AFAIL);
    }

    sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylightsvs);
    if (sdate < 0) {
        Log2("StringToTimeb ERROR from dateconv", p);
        return(AFAIL);
    }

/*  This is for times of files, so if there is no year we assume it could
 *  be up to a day ahead but otherwise in the past if no year specified.  
 */ 
    if (!yearflag && (sdate > (Now->time + ADAY))) { 
        Log2("StringToTimeb backing up a year since file dates must be in past", p);
        year--;                                       
        sdate = dateconv(month,day,year,hh,mm,ss,merid,ourzone,daylightsvs);
        if (sdate < 0) {
            Log2("StringToTimeb ERROR from dateconv after backing up a year", p);
            return(AFAIL);
        }
    }


    Result->time=sdate;
    Result->millitm=0;
    Result->timezone=ourzone;
    Result->dstflag=daylightsvs; 

    Log("StringToTimeb returning AOK");
    return(AOK);
}

yyerror(s)
char *s;
{
    Log2("yyerror", s);
}

short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
	};
# define YYNPROD 22
# define YYLAST 212
short yyact[]={

  12,   8,  34,  11,   9,  10,  33,  32,  31,  28,
  24,  23,  22,  35,  25,  21,  29,  20,  30,  26,
   7,   6,   5,   4,   3,   2,   1,   0,  19,  13,
  14,  15,  16,  17,  18,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,  27 };
short yypact[]={

-258,-1000,-258,-258,-258,-258,-258,-258,-1000,-1000,
-1000, -30,-249,-1000,-1000,-1000,-1000,-1000,-1000,-250,
-251,-244, -25, -49, -31, -27,-253,-1000,-254,-255,
-259,-1000,-247,-1000,-1000,-1000 };
short yypgo[]={

   0,  26,  25,  24,  23,  22,  21,  20 };
short yyr1[]={

   0,   1,   1,   1,   1,   1,   1,   1,   2,   7,
   4,   4,   4,   4,   3,   3,   5,   5,   5,   6,
   6,   6 };
short yyr2[]={

   0,   0,   2,   2,   2,   2,   2,   2,   1,   1,
   3,   4,   5,   6,   1,   1,   3,   2,   3,   5,
   4,   5 };
short yychk[]={

-1000,  -1,  -2,  -3,  -4,  -5,  -6,  -7, 259, 262,
 263, 261, 258,  -1,  -1,  -1,  -1,  -1,  -1,  58,
  47,  45, 261, 261, 261, 258,  44, 260,  58,  47,
  45, 261, 261, 261, 261, 260 };
short yydef[]={

   1,  -2,   1,   1,   1,   1,   1,   1,   8,  14,
  15,   9,   0,   2,   3,   4,   5,   6,   7,   0,
   0,   0,  17,  10,  16,  18,   0,  11,   0,   0,
   0,  20,  12,  19,  21,  13 };
/*
 **********************************************************************
 * HISTORY
 * $Log:	yaccpar,v $
 * Revision 2.2  89/05/30  11:38:04  gm0w
 * 	Removed unknown preprocessor directive "#".
 * 	[89/05/30            gm0w]
 * 
 **********************************************************************
 */
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif not lint

# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 2:
# line 36 "stringtotime.y"

                {;} break;
case 3:
# line 38 "stringtotime.y"

                {zoneflag++;} break;
case 4:
# line 40 "stringtotime.y"

                {timeflag++;} break;
case 5:
# line 42 "stringtotime.y"

                {dateflag++;} break;
case 6:
# line 44 "stringtotime.y"

                {dateflag++; yearflag++;} break;
case 7:
# line 46 "stringtotime.y"

                {yearflag++;} break;
case 8:
# line 49 "stringtotime.y"

                {;} break;
case 9:
# line 53 "stringtotime.y"

                {year = yypvt[-0]; } break;
case 10:
# line 56 "stringtotime.y"

                {hh = yypvt[-2]; mm = yypvt[-0]; ss=0; merid = 24;} break;
case 11:
# line 58 "stringtotime.y"

                {hh = yypvt[-3]; mm = yypvt[-1]; ss=0; merid = yypvt[-0];} break;
case 12:
# line 60 "stringtotime.y"

                {hh = yypvt[-4]; mm = yypvt[-2]; ss = yypvt[-0]; merid = 24;} break;
case 13:
# line 62 "stringtotime.y"

                {hh = yypvt[-5]; mm = yypvt[-3]; ss = yypvt[-1]; merid = yypvt[-0];} break;
case 14:
# line 66 "stringtotime.y"

                {ourzone = yypvt[-0]; daylightsvs = STANDARD;} break;
case 15:
# line 68 "stringtotime.y"

                {ourzone = yypvt[-0]; daylightsvs = DAYLIGHT;} break;
case 16:
# line 71 "stringtotime.y"

                {month = yypvt[-2]; day = yypvt[-0];} break;
case 17:
# line 73 "stringtotime.y"

                {month = yypvt[-1]; day = yypvt[-0];} break;
case 18:
# line 75 "stringtotime.y"

                {month = yypvt[-0]; day = yypvt[-2];} break;
case 19:
# line 78 "stringtotime.y"

                {month = yypvt[-4]; day = yypvt[-2]; year = yypvt[-0];  } break;
case 20:
# line 80 "stringtotime.y"

                {month = yypvt[-3]; day = yypvt[-2]; year = yypvt[-0];  } break;
case 21:
# line 82 "stringtotime.y"

                {month = yypvt[-2]; day = yypvt[-4]; year = yypvt[-0];  } break;
		}
		goto yystack;  /* stack new state and value */

	}
