


 Date template updated or checked:  3/19/93
 By: Name:             Vincent Cate
     Email address:    vac@cs.cmu.edu

 ----------------------------------------------------------------------

      NIR Tool Name:      Alex

      Brief Description of Tool:

OVERVIEW:

The Alex filesystem provides users and applications transparent read
access to files in anonymous FTP sites on the Internet. Today there are
thousands of anonymous FTP sites with a total of a few millions of files
and roughly a terabyte of data. The standard approach to accessing these
files involves logging in to the remote machine. This means that an
application can not access remote files like local files. This also means
that users do not have any of their aliases or local tools available.
Users who want to use an application on a remote file first have to
manually make a local copy of the file. There is no mechanism for
automatically updating this local copy when the remote file changes. The
users must keep track of where they get their files from and check to see
if there are updates, and then fetch these. In this approach many
different users at the same site may have made copies of the same remote
file each using up disk space for the same data.

Alex addresses the problems with the existing approach while remaining
within the existing FTP protocol so that the large collection of currently
available files can be used.  To get reasonable performance long term file
caching is used.  Thus consistency is an issue.  Traditional solutions to
the cache consistency problem do not work in the Internet FTP domain:
callbacks are not an option as the FTP protocol has no provisions for this
and polling over the Internet is slow. Therefore, Alex relaxes file cache
consistency semantics, on a per file basis, and uses special caching
algorithms that take into account the properties of the files and of the
network to allow a simple stateless filesystem to scale to the size of the
Internet.


USER'S VIEW:

To a user or application, Alex is just a normal filesystem. Any command
that works on local files will work on Alex files. Since Alex is a real
filesystem, nothing needs to be recompiled and no libraries are changed.
Thus, users can apply all of their existing skills and tools for using
files.

The user sees a filesystem with a hierarchical name space. At the top
level (/alex) there are top-level Internet domains like "edu", "com",
"uk", and "jp". Each component of the hostname becomes a directory name a
s shown in Figure 1. Then the remote path is added at the end. If the user
does a "ls /alex/edu/berkeley" he sees some machine names such as
"ucbvax" and "sprite" and some directories on berkeley.edu. From the "ls"
it is not clear what is where. The user may or may not be aware of host
boundaries.


INFORMATION PROVIDER'S VIEW:

The Alex is implemented as a user level NFS server.  NFS was chosen
because it makes it easy to add Alex to a wide range of machines.  Most
machines can simply use the mount command.  

The model of usage is that there is one Alex server running at each
institution (though this is not required in any way).  Users mount the
local server which caches files for users at that site.

Any information put into any anonymous FTP site becomes available via
Alex.

 ----------------------------------------------------------------------

      Primary Contact(s):
      
           Name:   Vincent Cate

           Email address:  vac@cs.cmu.edu

           Postal Address: School of Computer Science
                           5000 Forbes Ave.
                           Pittsburgh PA, 15213

           Telephone:      (412) 268-3077

           Fax:            (412) 681-1998

 ----------------------------------------------------------------------

 Help Line (for major center as well as each client)

      At this time Alex is a one person project (Vince).

 ----------------------------------------------------------------------

      Related Working Groups

           Maybe the FTP working group.

 ----------------------------------------------------------------------

Sponsoring Organization / Funding source:

Defense Advanced Research Projects Agency, Information Science and
Technology Office, under the title "Research on Parallel Computing," ARPA
Order No. 7330.  Work furnished in connection with this research is
provided under prime contract MDA972-90-C-0035 issued by DARPA/CMO to
Carnegie Mellon University.  Vincent Cate is supported by an "Intel
foundation graduate fellowship".

 ----------------------------------------------------------------------

      Mailing Lists 

           Address:                 alex-servers@cs.cmu.edu

           Administration:          alex-servers-request@cs.cmu.edu


           Description:
                
                  alex-servers is for people setting up an Alex fileserver.

           Archive:  
       
                   alex.sp.cs.cmu.edu (128.2.209.13)

 ----------------------------------------------------------------------

      News groups 
            
           none


 ----------------------------------------------------------------------

      Protocols

What is supported:   Any machine that can NFS mount a fileserver.

What it runs over:   Unix machine and FTP

Other NIR tools this interworks with:   

      Uses FTP sites.

      WAIS can be used to index files in Alex
        (this was done for ftpable-readmes and cs-techreports WAIS servers)

      New versions of archie can output Alex paths.

Future plans:              Graduate from CMU.

 ----------------------------------------------------------------------

      Servers:
           Date completed or updated:     3/19/93
           By: Name:    Vincent Cate

           Platform:     UNIX

           Primary Contact 
                Name:            Vincent Cate
                Email address:   vac@cs.cmu.edu
                Telephone:       (412) 268-3077

           Server software available from:  alex.sp.cs.cmu.edu

           Location of more information:
                 No other place to go to.

           Latest version number:
                 New versions all the time.

           Brief Scope and Characteristics:
                 This software is known to still contain bugs.

           Approximate number of such servers in use:
                 200.

           General comments:
                 You can use lpr, make, grep, more, etc on files around 
                 the world.

 ----------------------------------------------------------------------

      Clients

           You just do an NFS mount of the server.  No client software
           is needed.


 ----------------------------------------------------------------------

      Demonstration sites :

 Site name:   alex.sp.cs.cmu.edu

 Access details - do the following as root:
     mkdir /alex
     mount -o timeo=30,retrans=300,soft,intr alex.sp.cs.cmu.edu:/ /alex

 Example use:
     ln -s /alex/edu/cs/cmu/sp/alex/links alexlinks
     cd alexlinks
     ls
     cd cs-tr           
     cd ls
     cd purdue
     ls
     lpr TR758.PS

     If you like Alex and want to use it regularly please find, or set up,
 an Alex fileserver at/near your site.

 ----------------------------------------------------------------------

      Documentation:

                ftp://alex.sp.cs.cmu.edu/www/alex.html
                ftp://alex.sp.cs.cmu.edu/doc/intro.ps
                ftp://alex.sp.cs.cmu.edu/doc/NIR.Tool
                ftp://alex.sp.cs.cmu.edu/doc/alex.post

 ----------------------------------------------------------------------

      Bibliography:

@InProceedings{cate:alex,
  author =      "Vincent Cate",
  title =       "Alex - a Global Filesystem",
  booktitle =   "Proceedings of the Usenix File Systems Workshop",
  year =        1992,
  pages =       "1--11",
  month =       may,
  place =       "Ann Arbor, MI",
  keyword =     "distributed file system, wide-area file system"
}


 ----------------------------------------------------------------------

      Other Information:

         FTP to alex.sp.cs.cmu.edu and do a "cd doc".  Get the "README"
         or anything else there.  A current version of this document
         may be there and called "NIR.Tool".  In Alex this file is
         named "/alex/edu/cmu/cs/sp/alex/doc/NIR.Tool".

 ----------------------------------------------------------------------

 Evaluation:

         "Great idea!"  
         "I probably won't every use FTP again."
         "Thanks for a really useful tool."

