
/******************************************************************************
    DAYTIME - read and print time of day string from internet

    Copyright (C) 1991, University of Waterloo
    Portions Copyright (C) 1990, National Center for Supercomputer Applications

    This program is free software; you can redistribute it and/or modify
    it, but you may not sell it.

    This program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.

        Erick Engelke                   or via E-Mail
        Faculty of Engineering
        University of Waterloo          Erick@development.watstar.uwaterloo.ca
        200 University Ave.,
        Waterloo, Ont., Canada
        N2L 3G1

******************************************************************************/

#include <stdio.h>
#include <tcp.h>


#define DAYTIME_PORT 13

daytime(host)
longword host;
{
    tcp_Socket telsock;
    static tcp_Socket *s;
    char buffer[ 513 ];
    int status;
    int len;

    s = &telsock;
    status = 0;
#ifdef TCP_DAYTIME
    if (!tcp_open( s, 0, host, DAYTIME_PORT, NULL )) {
	puts("Sorry, unable to connect to that machine right now!");
	return( 1 );
    }
    printf("waiting...\r");
    sock_wait_established(s, sock_delay , NULL, &status);
    printf("connected \n");
#else
    if (!udp_open( s, 0, host, DAYTIME_PORT, NULL )) {
	puts("Sorry, unable to connect to that machine right now!");
	return( 1 );
    }
    sock_write( s, "\n", 1 );
#endif TCP_DAYTIME

    while ( 1 ) {
	sock_tick( s, &status );


	if (sock_dataready( s ) ) {
	    sock_gets( s, buffer, sizeof( buffer ));
	    puts( buffer );
	    sock_close( s );
	    break;
	}
    }

sock_err:
    switch (status) {
	case 1 : /* foreign host closed */
		 return(0);
	case -1: /* timeout */
		 printf("\nConnection timed out!");
		 return(1);
	default: printf("Aborting");
		 return(1);
    }
}


main(int argc, char **argv )
{
    int status;
    longword host;

    if (argc != 2) {
	puts("   DAYTIME server");
	exit( 3 );
    }

    sock_init();

    if ( host = resolve( argv[1]))
	status = daytime( host );
    else {
	printf("Could not resolve host '%s'\n", argv[1]);
	status = 3;
    }

    exit( status );
}
