<%@ Page language="vb"%>
<!-----------------------------------------------------------------------------------------------------------------
Example of TreeGrid using synchronous (submit, non AJAX) communication with server
Example of simple table without tree
Uses DataTable for database communication
Uses new ASP.NET style scripting with event Page_Load
Uses MS Access database TableData.mdb as data and XML file TableDef.xml as TreeGrid layout
! Check if ASP application has write access to TableData.mdb file
------------------------------------------------------------------------------------------------------------------>
<html>
   <head>
      <link id="GridCSS" href="../../Grid/Grid.css" title="GridStyle" type="text/css" rel="stylesheet">
      <script src="../../Grid/GridE.js"> </script>
   </head>
   <body>
      <div style="WIDTH:100%;HEIGHT:90%">
         <bdo 
            Layout_Url="TableDef.xml" 
            Data_Tag="TGData" 
            Upload_Tag="TGData" Upload_Format="Internal"
            Export_Url="Export.aspx" Export_Data="TGData" Export_Param_File="SubmitTable.xls"
            ></bdo>
      </div>
      <form id="Form1" method="post" runat="server">
         <input id="TGData" type="hidden" runat="server"/>
         <input type="submit" value="Submit changes to server"/>
      </form>
   </body>
</html>
<script language="vb" runat="server">
   ' -------------------------------------------------------------------------------------------------------------------------------
   Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs)

      ' --- Database initialization ---
      Dim Path As String : Path = System.IO.Path.GetDirectoryName(Context.Request.PhysicalPath)
      Dim Conn As System.Data.OleDb.OleDbConnection : Conn = New System.Data.OleDb.OleDbConnection("Jet OLEDB:Global Partial Bulk Ops=2;Jet OLEDB:Registry Path=;Jet OLEDB:Database Locking Mode=1;Data Source=""" + Path + "\\Database.mdb"";Mode=Share Deny None;Jet OLEDB:Engine Type=5;Provider=""Microsoft.Jet.OLEDB.4.0"";Jet OLEDB:System database=;Jet OLEDB:SFP=False;persist security info=False;Extended Properties=;Jet OLEDB:Compact Without Replica Repair=False;Jet OLEDB:Encrypt Database=False;Jet OLEDB:Create System Database=False;Jet OLEDB:Don't Copy Locale on Compact=False;User ID=Admin;Jet OLEDB:Global Bulk Transactions=1")
      Dim Sql As System.Data.OleDb.OleDbDataAdapter : Sql = New System.Data.OleDb.OleDbDataAdapter("SELECT * FROM TableData", Conn)
      Dim D As System.Data.DataTable : D = New System.Data.DataTable()
      Sql.Fill(D)

      ' --- Response initialization ---
      Response.ContentType = "text/html"
      Response.Charset = "utf-8"
      Response.AppendHeader("Cache-Control", "max-age=1, must-revalidate")
      System.Threading.Thread.CurrentThread.CurrentCulture = System.Globalization.CultureInfo.CreateSpecificCulture("en-US")

      Dim X As System.Xml.XmlDocument : X = New System.Xml.XmlDocument()

      ' --- Save data to database ---
      Dim XML As String : XML = TGData.Value
      If XML <> "" And XML <> Nothing Then
         X.LoadXml(HttpUtility.HtmlDecode(XML))
         Dim Ch As System.Xml.XmlNodeList : Ch = X.GetElementsByTagName("Changes")
         If Ch.Count > 0 Then
            For Each I As System.Xml.XmlElement In Ch(0)
               Dim id As String : id = I.GetAttribute("id")
               Dim R As System.Data.DataRow
               If I.GetAttribute("Added") = "1" Then
                  R = D.NewRow()
                  R("ID") = id
                  D.Rows.Add(R)
               Else
                  R = D.Select("[ID]='" + id + "'")(0)
               End If

               If I.GetAttribute("Deleted") = "1" Then
                  R.Delete()

               ElseIf I.GetAttribute("Added") = "1" Or I.GetAttribute("Changed") = "1" Then
                  If I.HasAttribute("Project") Then R("Project") = I.GetAttribute("Project")
                  If I.HasAttribute("Resource") Then R("Resource") = I.GetAttribute("Resource")
                  If I.HasAttribute("Week") Then R("Week") = System.Double.Parse(I.GetAttribute("Week"))
                  If I.HasAttribute("Hours") Then R("Hours") = System.Double.Parse(I.GetAttribute("Hours"))
               End If
            Next I
         End If
         Dim Bld As System.Data.OleDb.OleDbCommandBuilder : Bld = New System.Data.OleDb.OleDbCommandBuilder(Sql)
         Sql.Update(D)                    ' Updates changed to database
         D.AcceptChanges()
         X.RemoveAll()
      End If

      ' --- Load data from database ---
      Dim G, BB, B, F As System.Xml.XmlElement
      G = X.CreateElement("Grid") : X.AppendChild(G)
      BB = X.CreateElement("Body") : G.AppendChild(BB)
      B = X.CreateElement("B") : BB.AppendChild(B)
      For Each R As System.Data.DataRow In D.Rows
         F = X.CreateElement("I")
         B.AppendChild(F)
         F.SetAttribute("id", R(0).ToString())
         F.SetAttribute("Project", R(1).ToString())
         F.SetAttribute("Resource", R(2).ToString())
         F.SetAttribute("Week", R(3).ToString())
         F.SetAttribute("Hours", R(4).ToString())
      Next R
      TGData.Value = X.InnerXml
   End Sub
   ' -------------------------------------------------------------------------------------------------------------------------------
</script>
