unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, pBarCode, StdCtrls, Grids, ValEdit, HBarcode, Printers;

type
  TForm1 = class(TForm)
    PropEdit: TValueListEditor;
    SelColor: TColorDialog;
    SelFont: TFontDialog;
    panDraw: TPanel;
    Panel2: TPanel;
    BarCode1: TBarCode;
    DrawEdit: TValueListEditor;
    imgDraw: TImage;
    btnDraw: TButton;
    PrinEdit: TValueListEditor;
    btnPrint: TButton;
    procedure PropEditGetPickList(Sender: TObject;
      const KeyName: String; Values: TStrings);
    procedure PropEditStringsChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure PropEditDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure PropEditSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure btnDrawClick(Sender: TObject);
    procedure DrawEditStringsChange(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure PrinEditGetPickList(Sender: TObject;
      const KeyName: String; Values: TStrings);
    procedure PrinEditStringsChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DrawEditGetPickList(Sender: TObject; const KeyName: String;
      Values: TStrings);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Setting: Boolean = False;
  DrawEditing: Boolean = False;
  PrinEditing: Boolean = False;
  function iif(C: Boolean; A, B: Variant): Variant;

implementation

{$R *.dfm}

function iif(C: Boolean; A, B: Variant): Variant;
begin
  if C then Result := A else Result := B;
end;

procedure TForm1.PropEditGetPickList(Sender: TObject;
  const KeyName: String; Values: TStrings);
begin
  if KeyName = 'BarType' then
  begin
    Values.Append('bcCode_2_5_interleaved');
    Values.Append('bcCode_2_5_industrial');
    Values.Append('bcCode_2_5_matrix');
    Values.Append('bcCode39');
    Values.Append('bcCode39Extended');
    Values.Append('bcCode128A');
    Values.Append('bcCode128B');
    Values.Append('bcCode128C');
    Values.Append('bcCode93');
    Values.Append('bcCode93Extended');
    Values.Append('bcCodeMSI');
    Values.Append('bcCodePostNet');
    Values.Append('bcCodeCodabar');
    Values.Append('bcCodeEAN8');
    Values.Append('bcCodeEAN13');
    Values.Append('bcCodeUPC_A');
    Values.Append('bcCodeUPC_E0');
    Values.Append('bcCodeUPC_E1');
    Values.Append('bcCodeUPC_Supp2');
    Values.Append('bcCodeUPC_Supp5');
    Values.Append('bcCodeEAN128A');
    Values.Append('bcCodeEAN128B');
    Values.Append('bcCodeEAN128C');
  end else
  if KeyName = 'CheckSum' then
  begin
    Values.Append('csNone');
    Values.Append('csModulo10');
  end else
  if KeyName = 'TextShow' then
  begin
    Values.Append('tsNone');
    Values.Append('tsBarCode');
    Values.Append('tsBarType');
    Values.Append('tsBoth');
  end else
  if KeyName = 'TextPosition' then
  begin
    Values.Append('tpTopLeft');
    Values.Append('tpTopRight');
    Values.Append('tpTopCenter');
    Values.Append('tpBottomLeft');
    Values.Append('tpBottomRight');
    Values.Append('tpBottomCenter');
  end else
  if KeyName = 'Orientation' then
  begin
    Values.Append('toLeftRight');
    Values.Append('toRightLeft');
    Values.Append('toTopBottom');
    Values.Append('toBottomTop');
  end else
  if KeyName = 'Alignment' then
  begin
    Values.Append('taCenter');
    Values.Append('taLeftJustify');
    Values.Append('taRightJustify');
  end else
  if (KeyName = 'BevelInner') or (KeyName = 'BevelOuter')then
  begin
    Values.Append('bvLowered');
    Values.Append('bvNone');
    Values.Append('bvRaised');
    Values.Append('bvSpace');
  end else
  if KeyName = 'BorderStyle' then
  begin
    Values.Append('bsNone');
    Values.Append('bsSingle');
  end else
  if KeyName = 'Align' then
  begin
    Values.Append('alBottom');
    Values.Append('alClient');
    Values.Append('alCustom');
    Values.Append('alLeft');
    Values.Append('alNone');
    Values.Append('alRight');
    Values.Append('alTop');
  end else
  if (KeyName = 'AutoWidth') or (KeyName = 'Ctl3D') or (KeyName = 'Visible') then
  begin
    Values.Append('True');
    Values.Append('False');
  end;
end;

procedure TForm1.PropEditStringsChange(Sender: TObject);
begin
  if not Setting then
  with Barcode1 do
  begin
    AutoWidth := iif(PropEdit.Values['AutoWidth']='True',True,False);
    if PropEdit.Values['BarType'] = 'bcCode_2_5_interleaved' then BarType := bcCode_2_5_interleaved;
    if PropEdit.Values['BarType'] = 'bcCode_2_5_industrial' then BarType := bcCode_2_5_industrial;
    if PropEdit.Values['BarType'] = 'bcCode_2_5_matrix' then BarType := bcCode_2_5_matrix;
    if PropEdit.Values['BarType'] = 'bcCode39' then BarType := bcCode39;
    if PropEdit.Values['BarType'] = 'bcCode39Extended' then BarType := bcCode39Extended;
    if PropEdit.Values['BarType'] = 'bcCode128A' then BarType := bcCode128A;
    if PropEdit.Values['BarType'] = 'bcCode128B' then BarType := bcCode128B;
    if PropEdit.Values['BarType'] = 'bcCode128C' then BarType := bcCode128C;
    if PropEdit.Values['BarType'] = 'bcCode93' then BarType := bcCode93;
    if PropEdit.Values['BarType'] = 'bcCode93Extended' then BarType := bcCode93Extended;
    if PropEdit.Values['BarType'] = 'bcCodeMSI' then BarType := bcCodeMSI;
    if PropEdit.Values['BarType'] = 'bcCodePostNet' then BarType :=bcCodePostNet;
    if PropEdit.Values['BarType'] = 'bcCodeCodabar' then BarType := bcCodeCodabar;
    if PropEdit.Values['BarType'] = 'bcCodeEAN8' then BarType := bcCodeEAN8;
    if PropEdit.Values['BarType'] = 'bcCodeEAN13' then BarType := bcCodeEAN13;
    if PropEdit.Values['BarType'] = 'bcCodeUPC_A' then BarType := bcCodeUPC_A;
    if PropEdit.Values['BarType'] = 'bcCodeUPC_E0' then BarType := bcCodeUPC_E0;
    if PropEdit.Values['BarType'] = 'bcCodeUPC_E1' then BarType := bcCodeUPC_E1;
    if PropEdit.Values['BarType'] = 'bcCodeUPC_Supp2' then BarType := bcCodeUPC_Supp2;
    if PropEdit.Values['BarType'] = 'bcCodeUPC_Supp5' then BarType := bcCodeUPC_Supp5;
    if PropEdit.Values['BarType'] = 'bcCodeEAN128A' then BarType := bcCodeEAN128A;
    if PropEdit.Values['BarType'] = 'bcCodeEAN128B' then BarType := bcCodeEAN128B;
    if PropEdit.Values['BarType'] = 'bcCodeEAN128C' then BarType := bcCodeEAN128C;
    Barcode := PropEdit.Values['Barcode'];
    BarHeight := StrToIntDef(PropEdit.Values['BarHeight'],0);
    if PropEdit.Values['CheckSum'] = 'csNone' then CheckSum := csNone;
    if PropEdit.Values['CheckSum'] = 'csModulo10' then CheckSum := csModulo10;
    Modul := StrToIntDef(PropEdit.Values['Modul'],1);
    Ratio := StrToFloatDef(PropEdit.Values['Ratio'],2);
    if PropEdit.Values['TextShow'] = 'tsNone' then TextShow := tsNone;
    if PropEdit.Values['TextShow'] = 'tsBarCode' then TextShow := tsBarCode;
    if PropEdit.Values['TextShow'] = 'tsBarType' then TextShow := tsBarType;
    if PropEdit.Values['TextShow'] = 'tsBoth' then TextShow := tsBoth;
    if PropEdit.Values['TextPosition'] = 'tpTopLeft' then TextPosition := tpTopLeft;
    if PropEdit.Values['TextPosition'] = 'tpTopRight' then TextPosition := tpTopRight;
    if PropEdit.Values['TextPosition'] = 'tpTopCenter' then TextPosition := tpTopCenter;
    if PropEdit.Values['TextPosition'] = 'tpBottomLeft' then TextPosition := tpBottomLeft;
    if PropEdit.Values['TextPosition'] = 'tpBottomRight' then TextPosition := tpBottomRight;
    if PropEdit.Values['TextPosition'] = 'tpBottomCenter' then TextPosition := tpBottomCenter;
    if PropEdit.Values['Orientation'] = 'toRightLeft' then Orientation := toRightLeft;
    if PropEdit.Values['Orientation'] = 'toTopBottom' then Orientation := toTopBottom;
    if PropEdit.Values['Orientation'] = 'toBottomTop' then Orientation := toBottomTop;
    if PropEdit.Values['Orientation'] = 'toLeftRight' then Orientation := toLeftRight;
    if PropEdit.Values['Alignment'] = 'taLeftJustify' then Alignment := taLeftJustify;
    if PropEdit.Values['Alignment'] = 'taRightJustify' then Alignment := taRightJustify;
    if PropEdit.Values['Alignment'] = 'taCenter' then Alignment := taCenter;
    HMargin := StrToIntDef(PropEdit.Values['HMargin'],0);
    Left := StrToIntDef(PropEdit.Values['Left'],0);
    Top  := StrToIntDef(PropEdit.Values['Top'],0);
    Height  := StrToIntDef(PropEdit.Values['Height'],0);
    Width  := StrToIntDef(PropEdit.Values['Width'],0);
    if PropEdit.Values['BevelInner'] = 'bvNone' then BevelInner := bvNone;
    if PropEdit.Values['BevelInner'] = 'bvRaised' then BevelInner := bvRaised;
    if PropEdit.Values['BevelInner'] = 'bvSpace' then BevelInner := bvSpace;
    if PropEdit.Values['BevelInner'] = 'bvLowered' then BevelInner := bvLowered;
    if PropEdit.Values['BevelOuter'] = 'bvNone' then BevelOuter := bvNone;
    if PropEdit.Values['BevelOuter'] = 'bvRaised' then BevelOuter := bvRaised;
    if PropEdit.Values['BevelOuter'] = 'bvSpace' then BevelOuter := bvSpace;
    if PropEdit.Values['BevelOuter'] = 'bvLowered' then BevelOuter := bvLowered;
    BevelWidth := StrToIntDef(PropEdit.Values['BevelWidth'],1);
    BorderStyle := iif(PropEdit.Values['BorderStyle']='bsNone',bsNone,bsSingle);
    BorderWidth := StrToIntDef(PropEdit.Values['BorderWidth'],1);
    Ctl3D := iif(PropEdit.Values['Ctl3D']='True',True,False);
    Visible := iif(PropEdit.Values['Visible']='True',True,False);
    Paint;
    btnDrawClick(Sender);
    FormShow(Sender);
  end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Setting := True;
  with Barcode1 do
  begin
    PropEdit.Values['Width'] := IntToStr(Width);
    PropEdit.Values['Left'] := IntToStr(Left);
    PropEdit.Values['Top'] := IntToStr(Top);
    PropEdit.Values['Height'] := IntToStr(Height);
    if BarType = bcCode_2_5_interleaved then PropEdit.Values['BarType'] := 'bcCode_2_5_interleaved';
    if BarType = bcCode_2_5_industrial then  PropEdit.Values['BarType'] := 'bcCode_2_5_industrial';
    if BarType = bcCode_2_5_matrix then  PropEdit.Values['BarType'] := 'bcCode_2_5_matrix';
    if BarType = bcCode39 then  PropEdit.Values['BarType'] := 'bcCode39';
    if BarType = bcCode39Extended then  PropEdit.Values['BarType'] := 'bcCode39Extended';
    if BarType = bcCode128A then  PropEdit.Values['BarType'] := 'bcCode128A' ;
    if BarType = bcCode128B then  PropEdit.Values['BarType'] := 'bcCode128B' ;
    if BarType = bcCode128C then  PropEdit.Values['BarType'] := 'bcCode128C' ;
    if BarType = bcCode93 then  PropEdit.Values['BarType'] := 'bcCode93' ;
    if BarType = bcCode93Extended then  PropEdit.Values['BarType'] := 'bcCode93Extended' ;
    if BarType = bcCodeMSI then  PropEdit.Values['BarType'] := 'bcCodeMSI';
    if BarType = bcCodePostNet then  PropEdit.Values['BarType'] := 'bcCodePostNet' ;
    if BarType = bcCodeCodabar then  PropEdit.Values['BarType'] := 'bcCodeCodabar' ;
    if BarType = bcCodeEAN8 then  PropEdit.Values['BarType'] := 'bcCodeEAN8' ;
    if BarType = bcCodeEAN13 then  PropEdit.Values['BarType'] := 'bcCodeEAN13' ;
    if BarType = bcCodeUPC_A then  PropEdit.Values['BarType'] := 'bcCodeUPC_A' ;
    if BarType = bcCodeUPC_E0 then  PropEdit.Values['BarType'] := 'bcCodeUPC_E0' ;
    if BarType = bcCodeUPC_E1 then  PropEdit.Values['BarType'] := 'bcCodeUPC_E1' ;
    if BarType = bcCodeUPC_Supp2 then  PropEdit.Values['BarType'] := 'bcCodeUPC_Supp2' ;
    if BarType = bcCodeUPC_Supp5 then  PropEdit.Values['BarType'] := 'bcCodeUPC_Supp5' ;
    if BarType = bcCodeEAN128A then  PropEdit.Values['BarType'] := 'bcCodeEAN128A' ;
    if BarType = bcCodeEAN128B then  PropEdit.Values['BarType'] := 'bcCodeEAN128B' ;
    if BarType = bcCodeEAN128C then  PropEdit.Values['BarType'] := 'bcCodeEAN128C' ;
    //PropEdit.Values['BarType'] := BarTypeName;
    PropEdit.Values['Barcode'] := Barcode;
    PropEdit.Values['BarHeight'] := IntToStr(BarHeight);
    PropEdit.Values['CheckSum'] := iif(CheckSum=csNone,'csNone','csModulo10');
    PropEdit.Values['Modul'] := IntToStr(Modul);
    PropEdit.Values['Ratio'] := FloatToStr(Ratio);
    if TextShow = tsNone then PropEdit.Values['TextShow'] := 'tsNone';
    if TextShow = tsBarCode then PropEdit.Values['TextShow'] := 'tsBarCode';
    if TextShow = tsBarType then PropEdit.Values['TextShow'] := 'tsBarType';
    if TextShow = tsBoth then PropEdit.Values['TextShow'] := 'tsBoth';
    if TextPosition = tpTopLeft then PropEdit.Values['TextPosition'] := 'tpTopLeft';
    if TextPosition = tpTopRight then PropEdit.Values['TextPosition'] := 'tpTopRight';
    if TextPosition = tpTopCenter then PropEdit.Values['TextPosition'] := 'tpTopCenter';
    if TextPosition = tpBottomLeft then PropEdit.Values['TextPosition'] := 'tpBottomLeft';
    if TextPosition = tpBottomRight then PropEdit.Values['TextPosition'] := 'tpBottomRight';
    if TextPosition = tpBottomCenter then PropEdit.Values['TextPosition'] := 'tpBottomCenter';
    if Orientation = toLeftRight then PropEdit.Values['Orientation'] := 'toLeftRight';
    if Orientation = toRightLeft then PropEdit.Values['Orientation'] := 'toRightLeft';
    if Orientation = toTopBottom then PropEdit.Values['Orientation'] := 'toTopBottom';
    if Orientation = toBottomTop then PropEdit.Values['Orientation'] := 'toBottomTop';
    if Alignment = taCenter then PropEdit.Values['Alignment'] := 'taCenter';
    if Alignment = taLeftJustify then PropEdit.Values['Alignment'] := 'taLeftJustify';
    if Alignment = taRightJustify then PropEdit.Values['Alignment'] := 'taRightJustify';
    PropEdit.Values['HMargin'] := IntToStr(HMargin);
    PropEdit.Values['AutoWidth'] := iif(AutoWidth,'True','False');
    if BevelInner = bvLowered then PropEdit.Values['BevelInner'] := 'bvLowered';
    if BevelInner = bvNone then PropEdit.Values['BevelInner'] := 'bvNone';
    if BevelInner = bvRaised then PropEdit.Values['BevelInner'] := 'bvRaised';
    if BevelInner = bvSpace then PropEdit.Values['BevelInner'] := 'bvSpace';
    if BevelOuter = bvLowered then PropEdit.Values['BevelOuter'] := 'bvLowered';
    if BevelOuter = bvNone then PropEdit.Values['BevelOuter'] := 'bvNone';
    if BevelOuter = bvRaised then PropEdit.Values['BevelOuter'] := 'bvRaised';
    if BevelOuter = bvSpace then PropEdit.Values['BevelOuter'] := 'bvSpace';
    PropEdit.Values['BevelWidth'] := IntToStr(BevelWidth);
    PropEdit.Values['BorderStyle'] := iif(BorderStyle=bsNone,'bsNone','bsSingle');
    PropEdit.Values['BorderWidth'] := IntToStr(BorderWidth);
    PropEdit.Values['Ctl3D'] := iif(Ctl3D,'True','False');
    PropEdit.Values['Visible'] := iif(Visible,'True','False');
  end;
  Setting := False;
  BarCode1.Paint;
  btnDrawClick(Sender);
end;

procedure TForm1.PropEditDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var
  DrawRect: TRect;
begin
  DrawRect.Left := Rect.Left + 2;
  DrawRect.Right := Rect.Right - 2;
  DrawRect.Top := Rect.Top + 2;
  DrawRect.Bottom := Rect.Bottom - 2;
  if ACol = 1 then
  begin
    if ARow = 5 then
    begin
      PropEdit.Canvas.Brush.Color := Barcode1.ColorBar;
      PropEdit.Canvas.Pen.Color := clBlack;
      PropEdit.Canvas.Rectangle(DrawRect);
    end else
    if ARow = 6 then
    begin
      PropEdit.Canvas.Brush.Color := Barcode1.ColorSpc;
      PropEdit.Canvas.Pen.Color := clBlack;
      PropEdit.Canvas.Rectangle(DrawRect);
    end else
    if ARow = 11 then
    begin
      PropEdit.Canvas.Pen.Color := Barcode1.Font.Color;
      PropEdit.Canvas.Font := Barcode1.Font;
      PropEdit.Canvas.Font.Size := PropEdit.Font.Size; 
      PropEdit.Canvas.TextOut(Rect.Left + 1,Rect.Top + 1,Barcode1.Font.Name);
    end else
    if ARow = 12 then
    begin
      PropEdit.Canvas.Brush.Color := Barcode1.TextColor;
      PropEdit.Canvas.Pen.Color := clBlack;
      PropEdit.Canvas.Rectangle(DrawRect);
    end else
    if ARow = 17 then
    begin
      PropEdit.Canvas.Brush.Color := Barcode1.Color;
      PropEdit.Canvas.Pen.Color := clBlack;
      PropEdit.Canvas.Rectangle(DrawRect);
    end;
  end;
end;

procedure TForm1.PropEditSelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  if ACol = 1 then
  begin
    if ARow = 5 then
    begin
      SelColor.Color := Barcode1.ColorBar;
      if SelColor.Execute then
        Barcode1.ColorBar := SelColor.Color;
      CanSelect := False;
    end else
    if ARow = 6 then
    begin
      SelColor.Color := Barcode1.ColorSpc;
      if SelColor.Execute then
        Barcode1.ColorSpc := SelColor.Color;
      CanSelect := False;
    end else
    if ARow = 11 then
    begin
      SelFont.Font := Barcode1.Font;
      if SelFont.Execute then
        Barcode1.Font := SelFont.Font;
      CanSelect := False;
    end else
    if ARow = 12 then
    begin
      SelColor.Color := Barcode1.TextColor;
      if SelColor.Execute then
        Barcode1.TextColor := SelColor.Color;
      CanSelect := False;
    end else
    if ARow = 17 then
    begin
      SelColor.Color := Barcode1.Color;
      if SelColor.Execute then
        Barcode1.Color := SelColor.Color;
      CanSelect := False;
    end;
    PropEdit.Repaint;
    btnDrawClick(Sender);
  end;
end;

procedure TForm1.btnDrawClick(Sender: TObject);
begin
  imgDraw.Canvas.Rectangle(imgDraw.Canvas.ClipRect);
  if DrawEdit.Values['BackGround'] = 'True' then
    imgDraw.Picture.LoadFromFile(ExtractFilePath(Application.ExeName)+'Back.bmp');
  Barcode1.Draw(imgDraw.Canvas,StrToIntDef(DrawEdit.Values['Left'],0),
    StrToIntDef(DrawEdit.Values['Top'],0),
    StrToIntDef(DrawEdit.Values['Height'],0),
    StrToFloatDef(DrawEdit.Values['Angle'],0));
end;

procedure TForm1.DrawEditGetPickList(Sender: TObject;
  const KeyName: String; Values: TStrings);
begin
  if KeyName = 'BackGround' then
  begin
    Values.Append('True');
    Values.Append('False');
  end;
end;

procedure TForm1.DrawEditStringsChange(Sender: TObject);
begin
  if not DrawEditing then
  begin
    DrawEditing := True;
    if DrawEdit.Values['BackGround'] <> 'False' then DrawEdit.Values['BackGround'] := 'True';
    DrawEdit.Values['Left'] := IntToStr(StrToIntDef(DrawEdit.Values['Left'],10));
    DrawEdit.Values['Top'] := IntToStr(StrToIntDef(DrawEdit.Values['Top'],10));
    DrawEdit.Values['Height'] := IntToStr(StrToIntDef(DrawEdit.Values['Height'],50));
    DrawEdit.Values['Angle'] := FloatToStr(StrToFloatDef(DrawEdit.Values['Angle'],0));
    DrawEditing := False;
    btnDrawClick(Sender);
  end;
end;

procedure TForm1.btnPrintClick(Sender: TObject);
begin
  Printer.BeginDoc;
  Barcode1.Print(
    iif(PrinEdit.Values['Unit'] = 'utInch',utInch,utMillimeter),
    StrToFloatDef(DrawEdit.Values['Left'],10.0),
    StrToFloatDef(PrinEdit.Values['Top'],10.0),
    StrToFloatDef(PrinEdit.Values['Height'],30.0),
    StrToFloatDef(PrinEdit.Values['Modul'],0.35),
    StrToFloatDef(PrinEdit.Values['Angle'],0));
  Printer.EndDoc;
end;

procedure TForm1.PrinEditGetPickList(Sender: TObject;
  const KeyName: String; Values: TStrings);
begin
  if KeyName = 'Unit' then
  begin
    Values.Append('utMillimeter');
    Values.Append('utInch');
  end;
end;

procedure TForm1.PrinEditStringsChange(Sender: TObject);
begin
  if not PrinEditing then
  begin
    PrinEditing := True;
    if PrinEdit.Values['Unit'] <> 'utInch' then PrinEdit.Values['Unit'] := 'utMillimeter';
    PrinEdit.Values['Left'] := FloatToStr(StrToFloatDef(PrinEdit.Values['Left'],10.0));
    PrinEdit.Values['Top'] := FloatToStr(StrToFloatDef(PrinEdit.Values['Top'],10.0));
    PrinEdit.Values['Height'] := FloatToStr(StrToFloatDef(PrinEdit.Values['Height'],30));
    PrinEdit.Values['Modul'] := FloatToStr(StrToFloatDef(PrinEdit.Values['Modul'],0.35));
    PrinEdit.Values['Angle'] := FloatToStr(StrToFloatDef(PrinEdit.Values['Angle'],0));
    PrinEditing := False;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  PrinEditStringsChange(Sender);
  DrawEditStringsChange(Sender);
end;

end.
