/*
 * Decompiled with CFR 0.152.
 */
package com.a7soft.examxml;

import com.a7soft.examxml.Element;
import com.a7soft.examxml.ExamXMLErrorHandler;
import com.a7soft.examxml.Options;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

public class ExamXMLHandler
extends DefaultHandler {
    static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    static final String SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";
    static final String LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    static final String CONTINUE_AFTER_FATAL_ERROR_FEATURES = "http://apache.org/xml/features/continue-after-fatal-error";
    static final int VALID_AUTO = 0;
    static final int VALID_NEVER = 1;
    static final int VALID_ALWAYS = 2;
    private static ExamXMLHandler handler;
    private XMLReader xmlReader;
    private StringBuffer value = new StringBuffer();
    private Locator2 locator;
    private Element element;
    private Element root;
    private String encoding;

    private ExamXMLHandler() {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = spf.newSAXParser();
            this.xmlReader = saxParser.getXMLReader();
            this.xmlReader.setErrorHandler(ExamXMLErrorHandler.getInstance());
            this.xmlReader.setContentHandler(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ExamXMLHandler getInstance(String logFile) {
        if (handler == null) {
            handler = new ExamXMLHandler();
        }
        ExamXMLErrorHandler.setLogFile(logFile, false);
        handler.setFeatures();
        return handler;
    }

    public void setFeatures() {
        try {
            this.xmlReader.setFeature(VALIDATION_FEATURE, Options.doSchema);
            this.xmlReader.setFeature(NAMESPACES_FEATURE, Options.doNamespaces);
            this.xmlReader.setFeature(NAMESPACE_PREFIXES_FEATURE, Options.doNamespaces);
            this.xmlReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE, Options.schemaFullChecking);
            this.xmlReader.setFeature(CONTINUE_AFTER_FATAL_ERROR_FEATURES, Options.continueAfterFatalError);
            switch (Options.shemaValidation) {
                case 0: {
                    this.xmlReader.setFeature(SCHEMA_VALIDATION_FEATURE, true);
                    this.xmlReader.setFeature(LOAD_EXTERNAL_DTD_FEATURE, true);
                    this.xmlReader.setFeature(DYNAMIC_VALIDATION_FEATURE, true);
                    break;
                }
                case 1: {
                    this.xmlReader.setFeature(SCHEMA_VALIDATION_FEATURE, false);
                    this.xmlReader.setFeature(LOAD_EXTERNAL_DTD_FEATURE, false);
                    this.xmlReader.setFeature(DYNAMIC_VALIDATION_FEATURE, false);
                    break;
                }
                case 2: {
                    this.xmlReader.setFeature(SCHEMA_VALIDATION_FEATURE, true);
                    this.xmlReader.setFeature(LOAD_EXTERNAL_DTD_FEATURE, true);
                    this.xmlReader.setFeature(DYNAMIC_VALIDATION_FEATURE, false);
                }
            }
        }
        catch (Exception e) {
            ExamXMLErrorHandler.printError(e);
        }
    }

    public Element loadXML(InputSource source) {
        try {
            this.xmlReader.parse(source);
            return this.root;
        }
        catch (Exception e) {
            ExamXMLErrorHandler.printError(e);
            return null;
        }
    }

    public void startDocument() throws SAXException {
        this.root = null;
        this.element = null;
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String namespace, String localName, String qName, Attributes attrs) throws SAXException {
        if (this.encoding == null) {
            Options.setEncoding(this.locator.getEncoding(), false);
            this.encoding = this.locator.getEncoding();
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
        }
        if (this.element != null) {
            this.element.setValue(this.value);
        }
        this.element = new Element(qName, attrs, this.element, this.element == null ? 0 : this.element.getCanonicalName(), this.locator.getLineNumber());
        if (this.root == null) {
            this.root = this.element;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!Options.ignoreValues) {
            int i;
            for (i = 0; i < length && ch[start + i] <= ' '; ++i) {
            }
            if (i < length) {
                this.value.append(ch, start, length);
            }
        }
    }

    public void endElement(String namespace, String localName, String qName) throws SAXException {
        this.element.setValue(this.value);
        this.element.closeElement();
        Element e = this.element;
        this.element = this.element.getParent();
        if (this.element != null) {
            this.element.addElement(e);
        }
    }

    public void setDocumentLocator(Locator loc) {
        this.locator = (Locator2)loc;
    }

    Element getRoot() {
        return this.root;
    }

    String getEncoding() {
        return this.encoding;
    }
}

