#ifndef __PDF417ENCODELIB_H__
#define __PDF417ENCODELIB_H__
#include <windows.h>
#include <wingdi.h>

#if defined(__cplusplus)
extern "C" {
#endif

typedef struct _tagPDF417CONTEXT
{
	int symbology;
	int nHeight;
	int nWidth;
	int nRows;
	int nColumns;
	int nErrorCorrectLevel;
	int nMargin;
	COLORREF clForeGround;
	COLORREF clBackGround;
	char cEncodedData[90][1000];
	char errtxt[100];
	char cData[7000];
}_PDF417CONTEXT;

void _InitPDF417Context(_PDF417CONTEXT *pPDF417Ctx);
HBITMAP _PDF417Encode2Bitmap(_PDF417CONTEXT *pPDF417Ctx);
BOOL _PDF417Encode2File(_PDF417CONTEXT *pPDF417Ctx,LPCTSTR pImageFile);
BOOL _FreePDF417Context();

#if defined(__cplusplus)
}
#endif

#endif /* __PDF417ENCODELIB_H__ */
