/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Vector;
import oracle.sql.converter.CharacterConverterLC;

public class CharacterConverterJAEUC
extends CharacterConverterLC {
    static final int LEADINGCODE = 143;

    public CharacterConverterJAEUC() {
        this.m_groupId = 2;
    }

    public void extractCodepoints(Vector vector) {
        int[] nArray;
        int n2 = 0;
        int n3 = 65535;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                nArray = new int[]{n4, this.toUnicode(n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
        n2 = 0x8F0000;
        n3 = n2 + 65535;
        int n5 = n2;
        while (n5 <= n3) {
            try {
                nArray = new int[]{n5, this.toUnicode(n5)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n5;
        }
    }

    int toUnicode(int n2) throws SQLException {
        int n3 = 0;
        if ((n2 >> 16 & 0xFFFF) == 143) {
            n3 = 256;
        }
        int n4 = n2 >> 8 & 255 + n3;
        int n5 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1) {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5];
        }
        throw new SQLException("Cannot map Oracle character to Unicode.");
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        String string = new String();
        while (n3 > 0) {
            int n4;
            int n5 = byArray[n2] & 0xFF;
            int n6 = 0;
            if (n5 == 143) {
                if (n3 < 3) {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
                n5 = byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2 + 2] & 0xFF;
                n4 = 3;
                n6 = 256;
            } else if (n5 > 127) {
                if (n3 < 2) {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
                n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
                n4 = 2;
            } else {
                n4 = 1;
            }
            int n7 = (n5 >> 8 & 0xFF) + n6;
            int n8 = n5 & 0xFF;
            if (this.m_ucsCharLevel1[n7] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] == -1) {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            int n9 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8];
            if (((long)n9 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n9 >>> 16);
                string = String.valueOf(string) + (char)(n9 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n9;
            }
            n3 -= n4;
            n2 += n4;
        }
        return string;
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        String string = new String();
        while (n3 > 0) {
            int n4;
            int n5 = byArray[n2] & 0xFF;
            int n6 = 0;
            if (n5 == 143) {
                if (n3 < 3) break;
                n5 = byArray[n2 + 1] << 8 & 0xFF00 | byArray[n2 + 2] & 0xFF;
                n4 = 3;
                n6 = 256;
            } else if (n5 > 127) {
                if (n3 < 2) break;
                n5 = byArray[n2] << 8 & 0xFF00 | byArray[n2 + 1] & 0xFF;
                n4 = 2;
            } else {
                n4 = 1;
            }
            int n7 = (n5 >> 8 & 0xFF) + n6;
            int n8 = n5 & 0xFF;
            int n9 = this.m_ucsCharLevel1[n7] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n7] + n8] : this.m_ucsCharReplacement;
            if (((long)n9 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n9 >>> 16);
                string = String.valueOf(string) + (char)(n9 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n9;
            }
            n3 -= n4;
            n2 += n4;
        }
        return string;
    }

    int toUnicodeWithReplacement(int n2) {
        int n3 = 0;
        if ((n2 >> 16 & 0xFFFF) == 143) {
            n3 = 256;
        }
        int n4 = n2 >> 8 & 255 + n3;
        int n5 = n2 & 0xFF;
        int n6 = this.m_ucsCharLevel1[n4] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n4] + n5] : this.m_ucsCharReplacement;
        return n6;
    }
}

