/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import oracle.sql.converter.CharacterConverter12Byte;

public class CharacterConverter2ByteFixed
extends CharacterConverter12Byte {
    public CharacterConverter2ByteFixed() {
        this.m_groupId = 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c2 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                c2 = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            byArray[n3++] = (byte)(c2 >> 8);
            byArray[n3++] = (byte)c2;
            ++n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 2];
        int n3 = 65535;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block6: {
                block5: {
                    block3: {
                        block4: {
                            if (cArray[n5] < '\ud800' || cArray[n5] >= '\udc00') break block3;
                            if (n5 + 1 >= n2 || cArray[n5 + 1] < '\udc00' || cArray[n5 + 1] > '\udfff') break block4;
                            n3 = this.toOracleCharacterWithReplacement(cArray[n5], cArray[n5 + 1]);
                            ++n5;
                            break block5;
                        }
                        byArray[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n4++] = (byte)this.m_2ByteOraCharReplacement;
                        break block6;
                    }
                    n3 = this.toOracleCharacterWithReplacement(cArray[n5], '\u0000');
                }
                byArray[n4++] = (byte)(n3 >> 8);
                byArray[n4++] = (byte)n3;
            }
            ++n5;
        }
        if (n4 < byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        while (n5 < n4) {
            int n6 = byArray[n5] & 0xFF;
            if (n5 < n4 - 1) {
                n6 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                ++n5;
            } else {
                throw new SQLException("Cannot map Oracle character to Unicode.");
            }
            int n7 = this.toUnicode(n6);
            if (((long)n7 & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n7 >>> 16);
                string = String.valueOf(string) + (char)(n7 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n7;
            }
            ++n5;
        }
        return string;
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        int n6 = 0;
        while (n5 < n4) {
            int n7;
            n6 = byArray[n5] & 0xFF;
            if (n5 < n4 - 1) {
                n6 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                ++n5;
            }
            if (((long)(n7 = this.toUnicodeWithReplacement(n6)) & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n7 >>> 16);
                string = String.valueOf(string) + (char)(n7 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n7;
            }
            ++n5;
        }
        return string;
    }
}

