/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.DatumWithConnection;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class REF
extends DatumWithConnection
implements Ref,
Serializable,
Cloneable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1328446996944583167L;
    String m_typename;
    transient StructDescriptor m_descriptor;

    public String getBaseTypeName() throws SQLException {
        if (this.m_typename == null) {
            if (this.m_descriptor != null) {
                this.m_typename = this.m_descriptor.getName();
            } else {
                DBError.throwSqlException(52);
            }
        }
        return this.m_typename;
    }

    public REF(String string, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || string == null) {
            DBError.throwSqlException(68);
        }
        this.m_typename = string;
        this.m_descriptor = null;
        this.setPhysicalConnectionOf(connection);
    }

    public REF(StructDescriptor structDescriptor, Connection connection, byte[] byArray) throws SQLException {
        super(byArray);
        if (connection == null || structDescriptor == null) {
            DBError.check_error(68);
        }
        this.m_descriptor = structDescriptor;
        this.setPhysicalConnectionOf(connection);
    }

    public Object getValue(Map map) throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc(map) : null;
        return object;
    }

    public Object getValue() throws SQLException {
        STRUCT sTRUCT = this.getSTRUCT();
        Object object = sTRUCT != null ? sTRUCT.toJdbc() : null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized STRUCT getSTRUCT() throws SQLException {
        STRUCT sTRUCT = null;
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.getInternalConnection().prepareStatement("select deref(?) from dual");
        oraclePreparedStatement.setRowPrefetch(1);
        oraclePreparedStatement.setREF(1, this);
        OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
        try {
            if (oracleResultSet.next()) {
                sTRUCT = oracleResultSet.getSTRUCT(1);
            } else {
                DBError.throwSqlException(52);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            oracleResultSet.close();
            oracleResultSet = null;
            oraclePreparedStatement.close();
            oraclePreparedStatement = null;
            throw throwable;
        }
        oracleResultSet.close();
        oracleResultSet = null;
        oraclePreparedStatement.close();
        oraclePreparedStatement = null;
        return sTRUCT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setValue(Object object) throws SQLException {
        STRUCT sTRUCT = STRUCT.toSTRUCT(object, this.getInternalConnection());
        if (sTRUCT.getInternalConnection() != this.getInternalConnection()) {
            DBError.throwSqlException(77, "Incompatible connection object");
        }
        if (!this.getBaseTypeName().equals(sTRUCT.getSQLTypeName())) {
            DBError.throwSqlException(77, "Incompatible type");
        }
        byte[] byArray = sTRUCT.toBytes();
        byte[] byArray2 = sTRUCT.getDescriptor().getOracleTypeADT().getTOID();
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.getInternalConnection().prepareCall("begin ? := dbms_pickler.update_through_ref (?, ?, ?, ?); end;");
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setBytes(2, this.shareBytes());
            callableStatement.setInt(3, 0);
            callableStatement.setBytes(4, byArray2);
            callableStatement.setBytes(5, byArray);
            callableStatement.execute();
            int n2 = 0;
            n2 = callableStatement.getInt(1);
            if (n2 != 0) {
                DBError.throwSqlException(77, "ORA-" + n2);
            }
            Object var8_7 = null;
            if (callableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (callableStatement != null) {
                callableStatement.close();
            }
            callableStatement = null;
            throw throwable;
        }
        callableStatement.close();
    }

    public StructDescriptor getDescriptor() throws SQLException {
        if (this.m_descriptor == null) {
            this.m_descriptor = StructDescriptor.createDescriptor(this.m_typename, this.getInternalConnection());
        }
        return this.m_descriptor;
    }

    public String getSQLTypeName() throws SQLException {
        String string = this.getBaseTypeName();
        return string;
    }

    public Object getObject(Map map) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public Object getObject() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void setObject(Object object) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public Object toJdbc() throws SQLException {
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    public Object makeJdbcArray(int n2) {
        return new REF[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        REF rEF = null;
        try {
            rEF = new REF(this.getBaseTypeName(), (Connection)this.getInternalConnection(), this.getBytes());
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException(sQLException.getMessage());
        }
        return rEF;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        try {
            bl = object instanceof REF && super.equals(object) && this.getBaseTypeName().equals(((REF)object).getSQLTypeName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public int hashCode() {
        int n2;
        block4: {
            byte[] byArray;
            block5: {
                block3: {
                    byArray = this.shareBytes();
                    n2 = 0;
                    if ((byArray[2] & 5) != 5) break block3;
                    int n3 = 0;
                    while (n3 < 4) {
                        n2 *= 256;
                        n2 += byArray[8 + n3] & 0xFF;
                        ++n3;
                    }
                    break block4;
                }
                if ((byArray[2] & 3) != 3) break block5;
                int n4 = 0;
                while (n4 < 4 && n4 < byArray.length) {
                    n2 *= 256;
                    n2 += byArray[6 + n4] & 0xFF;
                    ++n4;
                }
                break block4;
            }
            if ((byArray[2] & 2) != 2) break block4;
            int n5 = 0;
            while (n5 < 4) {
                n2 *= 256;
                n2 += byArray[8 + n5] & 0xFF;
                ++n5;
            }
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.shareBytes());
        try {
            objectOutputStream.writeUTF(this.getBaseTypeName());
        }
        catch (SQLException sQLException) {
            throw new IOException("SQLException ORA-" + sQLException.getErrorCode() + " " + sQLException.getMessage());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.setBytes((byte[])objectInputStream.readObject());
        this.m_typename = objectInputStream.readUTF();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        return super.getJavaSqlConnection();
    }

    public OracleConnection getConnection() throws SQLException {
        return super.getConnection();
    }
}

