/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.util.Arrays;
import unity.functions.Expression;
import unity.functions.MatchFunction;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class MatchPredicate {
    private Expression[] matchFuncs;
    private Relation inputRelation;
    private Relation outputRelation;
    private int[] outputAttrs;
    private int offset = 0;

    public MatchPredicate(Expression[] funcs) {
        this.matchFuncs = funcs;
    }

    public Relation generateOutputRelation(Relation inRelation, boolean outputAllFields, Relation matchFuncRelation) {
        this.inputRelation = inRelation;
        Attribute[] attrs = null;
        int count = 0;
        int numMatchFunctions = 0;
        if (this.matchFuncs != null) {
            numMatchFunctions = this.matchFuncs.length;
        }
        if (outputAllFields) {
            boolean[] inOutput = new boolean[this.inputRelation.getNumAttributes()];
            Arrays.fill(inOutput, true);
            int i = 0;
            while (i < numMatchFunctions) {
                int[] attrLocs = this.matchFuncs[i].getExprLocs();
                int j = 0;
                while (j < attrLocs.length) {
                    inOutput[attrLocs[j]] = false;
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < inOutput.length) {
                if (inOutput[i]) {
                    ++count;
                }
                ++i;
            }
            this.outputAttrs = new int[count];
            attrs = new Attribute[count + numMatchFunctions];
            this.offset = count;
            count = 0;
            i = 0;
            while (i < inOutput.length) {
                if (inOutput[i]) {
                    this.outputAttrs[count] = i;
                    attrs[count++] = inRelation.getAttribute(i);
                }
                ++i;
            }
        } else {
            attrs = new Attribute[numMatchFunctions];
        }
        int i = 0;
        while (i < numMatchFunctions) {
            attrs[count++] = matchFuncRelation.getAttribute(i);
            ++i;
        }
        this.outputRelation = new Relation(attrs);
        return this.outputRelation;
    }

    public Tuple generateOutputTuple(Tuple input) {
        int i;
        Tuple output = new Tuple(this.outputRelation);
        if (this.outputAttrs != null) {
            i = 0;
            while (i < this.outputAttrs.length) {
                output.setValue(i, input.getObject(this.outputAttrs[i]));
                ++i;
            }
        }
        if (this.matchFuncs != null) {
            i = 0;
            while (i < this.matchFuncs.length) {
                output.setValue(i + this.offset, this.matchFuncs[i].evaluate(input));
                ++i;
            }
        }
        return output;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        if (this.outputAttrs != null && this.outputAttrs.length > 0) {
            buf.append(this.outputRelation.getAttribute(0).getName());
            int i = 1;
            while (i < this.outputAttrs.length) {
                buf.append(", " + this.outputRelation.getAttribute(i).getName());
                ++i;
            }
        }
        if (this.matchFuncs != null) {
            int i;
            int numMatchFunctions = this.matchFuncs.length;
            int offset = 0;
            if (this.outputAttrs != null) {
                offset = this.outputAttrs.length;
                if (this.outputAttrs.length > 0) {
                    buf.append(this.inputRelation.getAttribute(0).getName());
                }
                i = 1;
                while (i < this.outputAttrs.length) {
                    buf.append(", " + this.inputRelation.getAttribute(i).getName());
                    ++i;
                }
                if (numMatchFunctions > 0) {
                    buf.append(", ");
                }
            }
            if (numMatchFunctions > 0) {
                if (this.matchFuncs[0] instanceof MatchFunction) {
                    buf.append(this.matchFuncs[0].toString(this.inputRelation, this.outputRelation.getAttribute(offset)));
                } else {
                    buf.append(this.matchFuncs[0].toString(this.inputRelation));
                }
            }
            i = 1;
            while (i < numMatchFunctions) {
                if (this.matchFuncs[i] instanceof MatchFunction) {
                    buf.append(", " + this.matchFuncs[i].toString(this.inputRelation, this.outputRelation.getAttribute(offset + i)));
                } else {
                    buf.append(", " + this.matchFuncs[i].toString(this.inputRelation));
                }
                ++i;
            }
        }
        return buf.toString();
    }
}

