/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.io.IOException;
import java.sql.SQLException;
import unity.relational.Relation;
import unity.relational.Tuple;

public class EquiJoinPredicate {
    private int[] attr1Locs;
    private int[] attr2Locs;
    private int numAttrs;
    private int keyType;
    public static int OBJECT_KEY = 3;
    public static int STRING_KEY = 2;
    public static int INT_KEY = 1;

    public EquiJoinPredicate(int[] idx1, int[] idx2, int ktype) {
        this.attr1Locs = idx1;
        this.attr2Locs = idx2;
        this.numAttrs = idx1.length;
        this.keyType = ktype;
    }

    public EquiJoinPredicate inversePredicate() {
        return new EquiJoinPredicate(this.attr2Locs, this.attr1Locs, this.keyType);
    }

    public boolean isLessThan(Tuple t1, Tuple t2) throws IOException {
        try {
            int i = 0;
            while (i < this.numAttrs) {
                Comparable c1 = (Comparable)t1.getObject(this.attr1Locs[i]);
                Comparable c2 = (Comparable)t2.getObject(this.attr2Locs[i]);
                if (c1 != null && c2 != null) {
                    int val = c1.compareTo(c2);
                    if (val != 0) {
                        return val < 0;
                    }
                } else {
                    if (c1 == null && c2 != null) {
                        return true;
                    }
                    if (c1 != null && c2 == null) {
                        return false;
                    }
                    if (c1 == null && c2 == null && i == this.numAttrs - 1) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            throw new IOException("Error in join comparator: " + e);
        }
    }

    public boolean isGreaterThan(Tuple t1, Tuple t2) throws IOException {
        try {
            int i = 0;
            while (i < this.numAttrs) {
                Comparable c1 = (Comparable)t1.getObject(this.attr1Locs[i]);
                Comparable c2 = (Comparable)t2.getObject(this.attr2Locs[i]);
                if (c1 != null && c2 != null) {
                    int val = c1.compareTo(c2);
                    if (val != 0) {
                        return val > 0;
                    }
                } else {
                    if (c1 == null && c2 != null) {
                        return false;
                    }
                    if (c1 != null && c2 == null) {
                        return true;
                    }
                    if (c1 == null && c2 == null && i == this.numAttrs - 1) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            throw new IOException("Error in join comparator: " + e);
        }
    }

    public boolean isEqual(Tuple t1, Tuple t2) throws IOException {
        try {
            int i = 0;
            while (i < this.numAttrs) {
                Comparable c1 = (Comparable)t1.getObject(this.attr1Locs[i]);
                Comparable c2 = (Comparable)t2.getObject(this.attr2Locs[i]);
                if (c1 != null && c2 != null ? !c1.equals(c2) : c1 == null || c2 == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception e) {
            throw new IOException("Error in join comparator: " + e);
        }
    }

    public int compare(Tuple t1, Tuple t2) throws SQLException {
        try {
            int i = 0;
            while (i < this.numAttrs) {
                Comparable c1 = (Comparable)t1.getObject(this.attr1Locs[i]);
                Comparable c2 = (Comparable)t2.getObject(this.attr2Locs[i]);
                if (c1 != null && c2 != null) {
                    int val = c1.compareTo(c2);
                    if (val != 0) {
                        return val;
                    }
                } else {
                    if (c1 == null && c2 != null) {
                        return -1;
                    }
                    if (c1 != null && c2 == null) {
                        return 1;
                    }
                }
                ++i;
            }
            return 0;
        }
        catch (Exception e) {
            throw new SQLException("Error in join comparator: " + e);
        }
    }

    public int getNumAttr() {
        return this.numAttrs;
    }

    public int[] getRelation1Locs() {
        return this.attr1Locs;
    }

    public int[] getRelation2Locs() {
        return this.attr2Locs;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public Object[] getValuesRelation1(Tuple t) {
        Object[] vals = new Object[this.numAttrs];
        int i = 0;
        while (i < this.numAttrs) {
            vals[i] = t.getObject(this.attr1Locs[i]);
            ++i;
        }
        return vals;
    }

    public Object[] getValuesRelation2(Tuple t) {
        Object[] vals = new Object[this.numAttrs];
        int i = 0;
        while (i < this.numAttrs) {
            vals[i] = t.getObject(this.attr2Locs[i]);
            ++i;
        }
        return vals;
    }

    public String toString(Relation relation1, Relation relation2) {
        StringBuffer sb = new StringBuffer(250);
        sb.append(String.valueOf(relation1.getAttribute(this.attr1Locs[0]).getName()) + " = " + relation2.getAttribute(this.attr2Locs[0]).getName());
        int i = 1;
        while (i < this.attr1Locs.length) {
            sb.append(" AND " + relation1.getAttribute(this.attr1Locs[i]).getName() + " = " + relation2.getAttribute(this.attr2Locs[i]).getName());
            ++i;
        }
        return sb.toString();
    }
}

