#include "sources.cpp\3dd.cpp"


/*
 Beispielprogramm fuer die Nutzung der 3D-Engine.

 Es wird eine rotierende Pyramide dargestellt um die ein Wuerfel kreist
 (der sich wiederum auch um seine eigenen (y & z) Achsen dreht).
 Zwischen den beiden Objekten 'fliegt' eine Lichtquelle.
*/


///////////////////////////////////////////////////////////////////////////


void farben()
{
  for(int c=1; c<=32; c++) {
    set_col(c,c+28,0,0);                    // Rot
    set_col(c+31,0,c+28,0);                 // Gruen
    set_col(c+63,0,0,c+28);                 // Blau
    set_col(c+95,c+28,c+26,0);              // Gelb
    set_col(c+127,c+28,0,c+28);             // Lila
    set_col(c+159,c+28,c+12,0);             // Orange
    set_col(c+191,c+21,0,c+25);             // Violett
    set_col(c+223,c+28,c+28,c+28);          // Grau
  }
};


///////////////////////////////////////////////////////////////////////////


int main()
{
  beleuchtung *licht_modell;
  leuchte *lampe;

  koerper *test,*test2;
  raum    *spc;

  punkt   vk,vk2,lmp_pos;


  init_video_320x240x256();
  farben();


  kurven_berechnen();


  test=new koerper(3,3);
  test2=new koerper(11,7);
  spc=new raum(10);


  lmp_pos.x=80; lmp_pos.y=0; lmp_pos.z=0;
  licht_modell=new beleuchtung(1);
  lampe=new leuchte(lmp_pos,110,0);

  licht_modell->leuchte_einfuegen(lampe);


  /* Punktkoordinaten des Wuerfels (grauenhaft redundant)
     es ist schliesslich nur ein Testprogramm                          */
  test2->punkte[0].x=-20; test2->punkte[0].y=-20; test2->punkte[0].z=-20;
  test2->punkte[1].x=-20; test2->punkte[1].y=20;  test2->punkte[1].z=-20;
  test2->punkte[2].x=20;  test2->punkte[2].y=20;  test2->punkte[2].z=-20;
  test2->punkte[3].x=20;  test2->punkte[3].y=-20; test2->punkte[3].z=-20;
  test2->punkte[4].x=-20; test2->punkte[4].y=-20; test2->punkte[4].z=20;
  test2->punkte[5].x=-20; test2->punkte[5].y=20;  test2->punkte[5].z=20;
  test2->punkte[6].x=20;  test2->punkte[6].y=20;  test2->punkte[6].z=20;
  test2->punkte[7].x=20;  test2->punkte[7].y=-20; test2->punkte[7].z=20;

  /* Flaecheninformationen des Wuerfels                                */
  test2->polys[0].p1=2; test2->polys[0].p2=1; test2->polys[0].p3=0;
  test2->polys[1].p1=0; test2->polys[1].p2=3; test2->polys[1].p3=2;
  test2->polys[0].farb=test2->polys[1].farb=0;                  // vorne
  test2->polys[2].p1=4; test2->polys[2].p2=3; test2->polys[2].p3=0;
  test2->polys[3].p1=4; test2->polys[3].p2=7; test2->polys[3].p3=3;
  test2->polys[2].farb=test2->polys[3].farb=4;                  // oben
  test2->polys[4].p1=3; test2->polys[4].p2=7; test2->polys[4].p3=2;
  test2->polys[5].p1=7; test2->polys[5].p2=6; test2->polys[5].p3=2;
  test2->polys[4].farb=test2->polys[5].farb=7;                  // rechts
  test2->polys[6].p1=4; test2->polys[6].p2=5; test2->polys[6].p3=6;
  test2->polys[7].p1=7; test2->polys[7].p2=4; test2->polys[7].p3=6;
  test2->polys[6].farb=test2->polys[7].farb=2;                  // hinten
  test2->polys[8].p1=1; test2->polys[8].p2=5; test2->polys[8].p3=4;
  test2->polys[9].p1=0; test2->polys[9].p2=1; test2->polys[9].p3=4;
  test2->polys[8].farb=test2->polys[9].farb=7;                  // links
  test2->polys[10].p1=6; test2->polys[10].p2=5; test2->polys[10].p3=1;
  test2->polys[11].p1=2; test2->polys[11].p2=6; test2->polys[11].p3=1;
  test2->polys[10].farb=test2->polys[11].farb=6;                // unten

  test2->mittelpunkte();


  /* Punktkoordinaten des (fast) Tertaeders                            */
  test->punkte[0].x=-50; test->punkte[0].y=-80; test->punkte[0].z=-50;
  test->punkte[1].x=-50; test->punkte[1].y=80;  test->punkte[1].z=-50;
  test->punkte[2].x=90;  test->punkte[2].y=0;   test->punkte[2].z=-50;
  test->punkte[3].x=0;   test->punkte[3].y=0;   test->punkte[3].z=90;

  /* Flaecheninformationen                                             */
  test->polys[0].p1=2; test->polys[0].p2=1; test->polys[0].p3=0;
  test->polys[0].farb=0;
  test->polys[1].p1=1; test->polys[1].p2=2; test->polys[1].p3=3;
  test->polys[1].farb=1;
  test->polys[2].p1=3; test->polys[2].p2=0; test->polys[2].p3=1;
  test->polys[2].farb=3;
  test->polys[3].p1=3; test->polys[3].p2=2; test->polys[3].p3=0;
  test->polys[3].farb=5;

  test->mittelpunkte();



  vk.x=0; vk.y=0; vk.z=0;

  while (!kbhit())
  for(word i=0; i<360; i++) {
    cls(log_addr_offset,9600);              // Logische Seite loeschen.
    test->rotieren(i,i,0,ursprung);         // Koerper drehen.
    test->bewegen(vk,umform);               // Koerper verschieben.
    test->abbilden(spc,licht_modell,-350);  // Koerper in die 'Welt' eintragen.

    vk2=lmp_pos;
    punkt_rotieren(vk2,0,i,0);              // Lampen Position um die y-Achse
    lampe->ort_setzen(vk2);                 //  rotieren
    vk2=vk2*2;                              // Wuerfel Position weiter aussen.


    test2->rotieren(0,i,i,ursprung);        // Wuerfel drehen.
    test2->bewegen(vk2,umform);             // Wuerfel verschieben.
    test2->abbilden(spc,licht_modell,-350); // Wuerfel in die 'Welt' eintragen.
    spc->sortieren();                       // Flaechen durchsortieren
    spc->zeichnen();                        // - und zeichnen.
    flip_w80();                             // Physikal. <-> logische Seite.
    vsync();                                // Auf den Rasterstrahl warten.
  }

  delete spc;
  delete test; delete test2;
  delete licht_modell;
  delete lampe;

  to_tmode();

  return(0);
}





