#include <MEM.H>
#include <STDIO.H>
#include <ALLOC.H>
#include <DOS.H>
#include <DIR.H>
#include <STDLIB.H>
#include <STRING.H>

#define DIM_DRV 7800
extern unsigned char far DRV[DIM_DRV];
   // driver caricato in memoria

extern unsigned DRV_SEG;
   // segmento del driver
extern unsigned DRV_ON;         // 1 = driver inizializzato
				// 0 = driver non    "
extern unsigned DRV_LOADED;          // 1 = driver in memoria
				// 0 = driver non   "
extern const volatile unsigned STATUS_VOC;   // registro di stato del driver


extern far unsigned GET_VER();
extern far unsigned GET_CARD();
extern far void SET_IOBASE(unsigned io_address);
extern far void SET_IRQ(unsigned irq_number);
extern far void SET_DMA(unsigned dma_number); // SBPRO only
extern far void SET_DDBUFFER(char far *address,unsigned bufsize);
extern far unsigned INIT_CARD(unsigned dim_buffer);
  // dim_buffer = dimensione a multipli in K
#define CARD_OK   0
#define CARD_FAIL 1
extern far void DEINIT_CARD();
extern far unsigned SOUND_VOC(char *voc_file_name);
#define VOC_OK          0
#define VOC_FAIL        1
#define NO_FILE         2
#define NO_PATH         3
#define TOO_FILE        4
#define ACCESS_DENIED   5
#define INVALID_ACCESS 12
extern far void STOP_VOC();
extern far unsigned CLOSE_VOC();
extern far unsigned PAUSE_VOC();
extern far unsigned RESUME_VOC();

extern far unsigned BREAK_NOW();
extern far unsigned BREAK_END();
extern far void SPEAKER_ON();
extern far void SPEAKER_OFF();
extern far unsigned RECORD_VOC(char *name_file_voc,unsigned sampl_rate);
extern far unsigned SET_MONO();
extern far unsigned SET_STEREO();
extern far unsigned SET_SOURCE(unsigned source);
extern far unsigned FILTER_PRO(unsigned modo,unsigned status);
extern far unsigned FILTER_STATUS(unsigned modo);
extern far unsigned RECORD_FILTER(unsigned modo);
extern far unsigned long VOICE_ERROR();
extern far unsigned long GET_SRATE(unsigned Process,unsigned modo);


// dati del driver:
extern unsigned DRV_ADDR;
extern unsigned DRV_IRQ ;
extern unsigned DRV_DMA ;
extern unsigned DRV_TYPE;

int load_driver(char *);

void close_driver();
