<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
  
<% PageUtils.setRequiredLoginStatus("superuser",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ADMIN,request); %>
<% PageUtils.setSkipMaxUsersExceededCheck(true,request); %>


<%@ include file="../global/topInclude.jsp" %>

<%!

%>

<%

String successParam;
try
{
	int numUsers=controller.getParamAsInt("numUsers");
	for (int i=0; i<numUsers; i++)
	{
		User user=Manager.selectUserById(controller.getParamAsInt("id"+i));
		user.setUsername(controller.getParam("username"+i));
		user.setFullname(controller.getParam("fullname"+i));
		user.setEmailAddress(controller.getParam("emailAddress"+i));
		String password=controller.getParam("password"+i);
		if (password.length()>0)
		{
			user.setPassword(controller.getParam("password"+i));
		} // ...otherwise leave unchanged.
		user.setActive(controller.getParamAsBoolean("active"+i));
		user.setSuperUser(controller.getParamAsBoolean("superUser"+i));
		Manager.updateUser(user);
	}
	successParam="true";
}
catch (Exception e)
{
	Printer.pe("changing/storing User(s)",e);
	successParam="false";
}

controller.redirect("showUserChanges.jsp?mode=edit&success="+successParam);
%>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>

