// ViewList.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CViewList view
#if !defined(AFX_VIEWLIST_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_)
#define AFX_VIEWLIST_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_

#include "Defines.h"

class CViewList : public CListView
{
protected:
	CViewList();           // protected constructor used by dynamic creation
	DECLARE_DYNCREATE(CViewList)
	void AdjustStyle(DWORD dwNewStyle);
	void SetListTypeMenuCheck(DWORD dwNewStyle);
	void SaveColumnWidths(void);
	void FillListWithFolders(CString sPath);
	void FillListWithFiles(CString sDir);
	void FillListWithFileWorker(WIN32_FIND_DATA result);
	void FillList(CString sPath);
	CString MakeModifiedString(FILETIME ft);
	CString MakePrettyNumber(double fNum);
	void EmptyListAndPath(void);
	CString m_sPath; // the path to the folder whose contents are displayed in the list
	void SortByAlpha(CPtrList * pList);
	void RefreshList(void);
	void DrillDown(void);

// Attributes
public:

	CWinExpDoc* GetDocument();
	
// Operations
public:
// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CViewList)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL

// Implementation
protected:
	virtual ~CViewList();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// Generated message map functions
protected:
	//{{AFX_MSG(CViewList)
	afx_msg void OnKeydown(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in viewgrid.cpp
inline CWinExpDoc* CViewList::GetDocument()
   { return (CWinExpDoc*)m_pDocument; }
#endif

#endif // !defined(AFX_VIEWLIST_H__00E433B9_33BC_11D3_88CA_00C0F023D5BE__INCLUDED_)

/////////////////////////////////////////////////////////////////////////////
