// UItoComView.cpp : implementation of the CUItoComView class
//

#include "stdafx.h"
#include "UItoCom.h"

#include "UItoComDoc.h"
#include "UItoComView.h"
#include "../../../include/smdraw.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CUItoComView

IMPLEMENT_DYNCREATE(CUItoComView, CView)

BEGIN_MESSAGE_MAP(CUItoComView, CView)
	//{{AFX_MSG_MAP(CUItoComView)
	ON_COMMAND(ID_VECTORIZE_IN_NEW_THREAD, OnVectorizeInNewThread)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CUItoComView construction/destruction

CUItoComView::CUItoComView()
{
	m_pDlgVectInNewThread = NULL;

}

CUItoComView::~CUItoComView()
{
}

BOOL CUItoComView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CUItoComView drawing

void CUItoComView::OnDraw(CDC* pDC)
{
	CUItoComDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	
	CRect clientRct;
	GetClientRect(&clientRct);
	draw(pDC, clientRct);
}

/////////////////////////////////////////////////////////////////////////////
// CUItoComView printing

BOOL CUItoComView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CUItoComView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CUItoComView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

/////////////////////////////////////////////////////////////////////////////
// CUItoComView diagnostics

#ifdef _DEBUG
void CUItoComView::AssertValid() const
{
	CView::AssertValid();
}

void CUItoComView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CUItoComDoc* CUItoComView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CUItoComDoc)));
	return (CUItoComDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CUItoComView message handlers

void CUItoComView::draw(CDC *pDC, const CRect &clientRct)
{
	CUItoComDoc* pDoc = (CUItoComDoc*) GetDocument();
	ASSERT_VALID(pDoc);	

	HBITMAP hBmp = pDoc->GetDIB();
	if ( hBmp == NULL )
		return;

	// initializing
	BITMAP bmp;	
	::GetObject(hBmp,sizeof(bmp),&bmp);
	int bmWidth		 = bmp.bmWidth;
	int bmHeight	 = bmp.bmHeight;	
	if ( bmWidth * bmHeight == 0 ) return;	
	HDC hDC = pDC->m_hDC;
	
	pDC->SetMapMode( MM_ANISOTROPIC );
	CRect srcRect(0,0,  bmWidth, bmHeight);
	CRect drRct;
	bool retBool = SmDraw::getDrawRect( drRct, clientRct, srcRect, 
		SmDraw::RIGHT_TOP);
	if ( !retBool  ) 
	{
		ASSERT(0);
		return;
	}

	int nViewPortExt;	
	SmDraw::getFitToWndViewPortExt( nViewPortExt,
			DEFAULT_VIEWPORT, drRct.TopLeft(), 
			drRct.Width(), srcRect);
	pDC->SetWindowExt(DEFAULT_WINDOW_EXT,DEFAULT_WINDOW_EXT);	

	int zoomFactor = 1;
	CPoint viewPortOrg = drRct.TopLeft();
	
	SIZE sizeViewPort;
	sizeViewPort.cx =  sizeViewPort.cy 
		= (int)( zoomFactor *nViewPortExt);
	pDC->SetViewportExt( sizeViewPort.cx, sizeViewPort.cx );
	pDC->SetViewportOrg( viewPortOrg );

	double scale = sizeViewPort.cx/(double)DEFAULT_WINDOW_EXT;
	CRect visiblePartBmp;
	SmDraw::GetVisiblePartOfBmp(visiblePartBmp,clientRct, viewPortOrg, 
		bmWidth,bmHeight, scale);
	
	BITMAPINFO_AL info;
	memset(&info,0,sizeof(info));
	info.bmiHeader.biWidth = bmWidth;
	info.bmiHeader.biHeight = bmHeight;
	info.bmiHeader.biBitCount = bmp.bmBitsPixel;
	info.bmiHeader.biPlanes = bmp.bmPlanes;	
	info.bmiHeader.biSize = sizeof(info.bmiHeader);

	info.bmiColors[1].rgbBlue  = 0;
	info.bmiColors[1].rgbGreen = 0;
	info.bmiColors[1].rgbRed   = 0;

	info.bmiColors[0].rgbBlue  = 255;
	info.bmiColors[0].rgbGreen = 255;
	info.bmiColors[0].rgbRed   = 255;

	SmDraw::SimpleDraw(hBmp,pDC->GetSafeHdc(),
		(BITMAPINFO*)&info, &visiblePartBmp);	 
}

void CUItoComView::OnVectorizeInNewThread() 
{
	CUItoComDoc* pDoc = (CUItoComDoc*) GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->VectorizeInNewThread();
	SetTimer(m_timerID, 250, NULL);

	if ( m_pDlgVectInNewThread )
	{
		m_pDlgVectInNewThread->DestroyWindow();
		delete m_pDlgVectInNewThread;
	}
	m_pDlgVectInNewThread = new DlgVectInNewThread(pDoc->GetVecom());
	ASSERT( m_pDlgVectInNewThread );
	if ( m_pDlgVectInNewThread == NULL )
		return;
	BOOL ret = m_pDlgVectInNewThread->Create(DlgVectInNewThread::IDD);
	ASSERT(ret);
	m_pDlgVectInNewThread->ShowWindow(SW_SHOW);	
}

void CUItoComView::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CUItoComDoc* pDoc = (CUItoComDoc*) GetDocument();
	ASSERT_VALID(pDoc);
	Ivecim* pIvecim = pDoc->GetVecom();
	ASSERT( pIvecim );
	if ( pIvecim == NULL ) 
		return;

	long lprog = pIvecim->GetProgress();
	
		
	if ( m_pDlgVectInNewThread )
	{
		m_pDlgVectInNewThread->SetProgress(lprog);
		if (pIvecim->IsCurOperChanged())
		{
			CString operation = pIvecim->GetCuOper();
			m_pDlgVectInNewThread->SetOperationName(operation);
		}
	}
	
	CView::OnTimer(nIDEvent);
	if ( pIvecim->IsVectorizationTerminated() )
	{
		if ( m_pDlgVectInNewThread )
		{
			m_pDlgVectInNewThread->DestroyWindow();
			delete m_pDlgVectInNewThread;
			m_pDlgVectInNewThread = NULL;
		}
		KillTimer(m_timerID);
	}
	CView::OnTimer(nIDEvent);
}
