/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.util.Date;
import stec.ss.ssResponse;

final class ssCookie {
    private String name = null;
    private String value = null;
    private long expires = -1L;
    private String path = null;
    private String domain = null;
    private boolean isSecure = false;

    protected ssCookie(String _name, String _value) {
        this.name = _name;
        this.value = _value;
    }

    protected ssCookie(ssCookie cookie) {
        this.name = cookie.getName();
        this.value = cookie.getValue();
        this.expires = cookie.getExpires();
        this.path = cookie.getPath();
        this.domain = cookie.getDomain();
        this.isSecure = cookie.isSecure();
    }

    protected final String toHeader() {
        return "Set-Cookie: ".concat(String.valueOf(String.valueOf(this.toString())));
    }

    public final String toString() {
        StringBuffer cookie = new StringBuffer();
        cookie.append(this.name);
        cookie.append('=');
        if (this.value != null) {
            cookie.append(ssResponse.encode(this.value));
            cookie.append(';');
        }
        if (this.expires != (long)-1) {
            cookie.append(" expires=");
            cookie.append(this.expires());
            cookie.append(';');
        }
        if (this.path != null) {
            cookie.append(" path=");
            cookie.append(this.path);
            cookie.append(';');
        }
        if (this.domain != null) {
            cookie.append(" domain=");
            cookie.append(this.domain);
            cookie.append(';');
        }
        if (this.isSecure) {
            cookie.append(" secure");
            cookie.append(';');
        }
        return cookie.toString();
    }

    protected final String getName() {
        return this.name;
    }

    protected final String getValue() {
        return this.value;
    }

    protected final void setValue(String _value) {
        this.value = _value;
    }

    protected final String expires() {
        return new Date(this.expires).toGMTString();
    }

    protected final long getExpires() {
        return this.expires;
    }

    protected final void setExpires(long _expires) {
        this.expires = _expires;
    }

    protected final String getPath() {
        return this.path;
    }

    protected final void setPath(String _path) {
        this.path = _path;
    }

    protected final String getDomain() {
        return this.domain;
    }

    protected final void setDomain(String _domain) {
        this.domain = _domain;
    }

    protected final boolean isSecure() {
        return this.isSecure;
    }

    protected final void setIsSecure(boolean _isSecure) {
        this.isSecure = _isSecure;
    }
}

