<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "<xsl:text><![CDATA[ ]]></xsl:text>">
	<!ENTITY nl "<xsl:text><![CDATA[
]]></xsl:text>">
	<!ENTITY copylogo "&#169;">
]>
<!--
	This template is used as the base for making custom class templates for databases.
	
	Author : Konstantine Kougios
	Version: 0.9Beta

-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="text" indent="yes" encoding="UTF-8" omit-xml-declaration="yes"/>

<xsl:template match="ROOT">
<!--
	==================================================================================================================
	Start of the template
	==================================================================================================================
-->
/**
 * TABLE: <xsl:value-of select="CLASSINFO/@name"/>
 * This class was generated with the OODBFramework &copylogo; 2004 Konstantine Kougios.
 * SimpleDBClass template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.
 */
 <!--
	==================================================================================================================
	Package declaration and static imports
	==================================================================================================================
-->
 
package <xsl:value-of select="CLASSINFO/@package"/>;

import java.sql.Statement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Iterator;
import org.jdom.Element;

<!--
	==================================================================================================================
	Imports defined in the user's configuration.xml
	==================================================================================================================
-->
<xsl:value-of select="template/imports"/>

<!--
	==================================================================================================================
	Start of the class
	==================================================================================================================
-->
// ============================================================================
// =       CLASS DEFINITION                                                   =
// = This class is the base for many others that will access the database     =
// ============================================================================
<xsl:value-of select="template/modifiers"/> class <xsl:value-of select="CLASSNAME"/>
<xsl:if test="template/extends!=''">
	extends <xsl:value-of select="template/extends"/>
</xsl:if>

{
<!--
	==================================================================================================================
	Start of the variable declarations
	==================================================================================================================
-->
	// dirty bit
	private boolean isDirty=false;
	// Connection
	private Statement st;
	// ============================================================================
	// =       Variable declaration, according to table columns.                  =
	// ============================================================================
<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
	private <xsl:value-of select="@javaType"/>&nbsp;<xsl:value-of select="@name"/>;
	<xsl:if test="@primaryKey!=''">
		private <xsl:value-of select="@javaType"/>&nbsp;old_<xsl:value-of select="@name"/>; // Old value of the key is kept too
	</xsl:if>
</xsl:for-each>
	
<!--
	==================================================================================================================
	Constructors
	==================================================================================================================
-->
	// ============================================================================
	// =                  Constructors                                            =
	// ============================================================================
	
	/**
	 * default constructor, shouldn't be called (except if you later call SetFromRs())
	 */
	public <xsl:value-of select="CLASSNAME"/>()
	{
	}
	
	/**
	 * use this to create a new row by calling the setters and then insert().
	 */
	public <xsl:value-of select="CLASSNAME"/>(Statement st)
	{
		this.st=st;
	}
<xsl:choose>
<xsl:when test="count(PRIMARYKEYS)>0">	
	/**
	 * Get from primary key(s), queries the database
	 */
	public <xsl:value-of select="CLASSNAME"/>(Statement st,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		this.st=st;
		StringBuffer sb=new StringBuffer("SELECT * FROM <xsl:value-of select="CLASSINFO/@tableName"/> WHERE");
		<xsl:for-each select="PRIMARYKEYS/KEY">
			sb.append(" <xsl:value-of select="@column"/>='");
			sb.append(<xsl:value-of select="@column"/>).append("'");
			<xsl:if test="@hasMore=1">sb.append(" AND");</xsl:if>
		</xsl:for-each>
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		ResultSet rs=st.executeQuery(sb.toString());
		rs.next();
		setFromRs(rs);
		rs.close();
	}
</xsl:when>
<xsl:otherwise>
	/**
	 * Since the table doesn't have a primary key, we shall request the sql to query the database
	 */
	public <xsl:value-of select="CLASSNAME"/>(Statement st,String sqlQuery) throws SQLException
	{
		this.st=st;
		ResultSet rs=st.executeQuery(sqlQuery);
		rs.next();
		setFromRs(rs);
		rs.close();
	}	
</xsl:otherwise>
</xsl:choose>
	/**
	 * Constructor by ResultSet (which must contain all columns = SELECT *)
	 * @param rs  the ResultSet
	 */
	public <xsl:value-of select="CLASSNAME"/>(java.sql.ResultSet rs) throws java.sql.SQLException
	{
		st=rs.getStatement();
		setFromRs(rs);
	}
<!--
	==================================================================================================================
	Utility functions
	==================================================================================================================
-->
	/**
	 * This is usefull for reusing of this class. Also, the constructors use this
	 */
	public void setFromRs(ResultSet rs) throws SQLException
	{
		<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
				<xsl:value-of select="@name"/>=
				<xsl:if test="@primaryKey!=''">
					old_<xsl:value-of select="@name"/>=
				</xsl:if>
				<xsl:if test="@allocateVar=1">new <xsl:value-of select="@javaType"/>(</xsl:if>
				rs.get<xsl:value-of select="@resultSetGetSet"/>("<xsl:value-of select="@name"/>")
				<xsl:if test="@allocateVar=1">);
				if (rs.wasNull()) <xsl:value-of select="@name"/>=null;
				</xsl:if>;
		</xsl:for-each>
	}
	
<!--
	==================================================================================================================
	Setters and getters
	==================================================================================================================
-->
	// ============================================================================
	// =                  Setters and getters                                     =
	// ============================================================================
<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
	/**
	 * Getter for <xsl:value-of select="@name"/>.
	 * <xsl:value-of select="@remarks"/>
	 */
	public <xsl:value-of select="@javaType"/> get<xsl:value-of select="@name"/>()
	{
		return <xsl:value-of select="@name"/>;
	}
	
	/**
	 * Setter for <xsl:value-of select="@name"/>.
	 * <xsl:value-of select="@remarks"/>
	 */
<xsl:choose>
	<xsl:when test="@identity=0">public</xsl:when>
	<xsl:otherwise>protected</xsl:otherwise>
</xsl:choose>
	void set<xsl:value-of select="@name"/>(<xsl:value-of select="@javaType"/> value)
	{
		this.<xsl:value-of select="@name"/>=value;
		isDirty=true;
	}

<!--
	==================================================================================================================
	Getters for multiple results
	==================================================================================================================
-->
	/**
	 * Gets a ResultSet of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static ResultSet get<xsl:value-of select="@name"/>ResultSetWithValueOf(Statement st, <xsl:value-of select="@javaType"/> value) throws SQLException
	{
		StringBuffer sb=new StringBuffer("SELECT * FROM <xsl:value-of select="//CLASSINFO/@tableName"/> WHERE <xsl:value-of select="@name"/>='");
		sb.append(value).append("'");
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		return st.executeQuery(sb.toString());
	}

	/**
	 * Gets a LinkedList of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static LinkedList get<xsl:value-of select="@name"/>LinkedListWithValueOf(Statement st, <xsl:value-of select="@javaType"/> value) throws SQLException
	{
		ResultSet rs=get<xsl:value-of select="@name"/>ResultSetWithValueOf(st,value);
		LinkedList ll=new LinkedList();
		while (rs.next())
		{
			ll.addLast(new <xsl:value-of select="//CLASSNAME"/>(rs));
		}
		return ll;
	}

	/**
	 * Gets an Iterator of <xsl:value-of select="//CLASSNAME"/>'s by querying table field <xsl:value-of select="@name"/>
	 * for equality with the "value".
	 */
	public static Iterator get<xsl:value-of select="@name"/>IteratorWithValueOf(Statement st, <xsl:value-of select="@javaType"/> value) throws SQLException
	{
		return get<xsl:value-of select="@name"/>LinkedListWithValueOf(st,value).iterator();
	}
</xsl:for-each>
<!--
	==================================================================================================================
	Delete and update methods, based on primary keys.
	==================================================================================================================
-->
	// ============================================================================
	// =                  Delete and Update methods                               =
	// ============================================================================
<xsl:if test="count(PRIMARYKEYS)>0">	
	/**
	 * Delete the current object from database
	 */
	public void delete() throws SQLException
	{
		StringBuffer sb=new StringBuffer("DELETE FROM <xsl:value-of select="CLASSINFO/@tableName"/> WHERE");
		<xsl:for-each select="PRIMARYKEYS/KEY">
			sb.append(" <xsl:value-of select="@column"/>='").append(get<xsl:value-of select="@column"/>()).append("'");
			<xsl:if test="@hasMore=1">sb.append(" AND");</xsl:if>
		</xsl:for-each>
		
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		st.execute(sb.toString());
	}
	/**
	 * Delete an row from database
	 */
	public static void delete(Statement st,<xsl:value-of select="PRIMARYKEYS/@commaSepJavaType"/>) throws SQLException
	{
		StringBuffer sb=new StringBuffer("DELETE FROM <xsl:value-of select="CLASSINFO/@tableName"/> WHERE");
		<xsl:for-each select="PRIMARYKEYS/KEY">
			sb.append(" <xsl:value-of select="@column"/>='").append(<xsl:value-of select="@column"/>).append("'");
			<xsl:if test="@hasMore=1">sb.append(" AND");</xsl:if>
		</xsl:for-each>
		
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		st.execute(sb.toString());
	}

<!-- Update exists only if table contains more than 1 non-identity field -->
<xsl:if test="count(COLUMN[@identity=0])>0">
	/**
	 * Update the current object to the database (primary keys/autoincrements are not updated)
	 */
	public void update() throws SQLException
	{
		if (isDirty)
		{
			StringBuffer sb=new StringBuffer("UPDATE <xsl:value-of select="CLASSINFO/@tableName"/> SET");
			<xsl:for-each select="COLUMN[@primaryKey='' and @identity=0 and @javaType!='java.io.InputStream']">
				sb.append("<xsl:if test='position()>1'>,</xsl:if>&nbsp;<xsl:value-of select="@name"/>=");
				<xsl:choose>
				<xsl:when test="@nullable=0">
					sb.append("'").append(get<xsl:value-of select="@name"/>()).append("'");
				</xsl:when>
				<xsl:otherwise>
					if (get<xsl:value-of select="@name"/>()==null) sb.append("null"); else sb.append("'").append(get<xsl:value-of select="@name"/>()).append("'");
				</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			sb.append(" WHERE");
			<xsl:for-each select="PRIMARYKEYS/KEY">
				<xsl:if test="position()>1">sb.append(" AND");</xsl:if>
				sb.append(" <xsl:value-of select="@column"/>='").append(<xsl:value-of select="@column"/>).append("'");
			</xsl:for-each>
			<xsl:if test="template/debug>0">
				// template/debug was set to >0 during conversion
				System.out.println(sb.toString());
			</xsl:if>
			st.execute(sb.toString());
		}
	}
</xsl:if>

	private void updateOldKeys()
	{
		// update the old_x old key values
		<xsl:for-each select="PRIMARYKEYS/KEY">
			old_<xsl:value-of select="@column"/>=<xsl:value-of select="@column"/>;
		</xsl:for-each>
	}
	
	/**
	 * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
	 */
	public void updateAll() throws SQLException
	{
		if (isDirty)
		{
			StringBuffer sb=new StringBuffer("UPDATE <xsl:value-of select="CLASSINFO/@tableName"/> SET");
			<xsl:for-each select="COLUMN[@identity=0 and @javaType!='java.io.InputStream']">
				sb.append("<xsl:if test='position()>1'>,</xsl:if>&nbsp;<xsl:value-of select="@name"/>=");
				<xsl:choose>
				<xsl:when test="@nullable=0">
					sb.append("'").append(get<xsl:value-of select="@name"/>()).append("'");
				</xsl:when>
				<xsl:otherwise>
					if (get<xsl:value-of select="@name"/>()==null) sb.append("null"); else sb.append("'").append(get<xsl:value-of select="@name"/>()).append("'");
				</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			sb.append(" WHERE");
			<xsl:for-each select="PRIMARYKEYS/KEY">
				<xsl:if test="position()>1">sb.append(" AND");</xsl:if>
				sb.append(" <xsl:value-of select="@column"/>='").append(old_<xsl:value-of select="@column"/>).append("'");
			</xsl:for-each>
			<xsl:if test="template/debug>0">
				// template/debug was set to >0 during conversion
				System.out.println(sb.toString());
			</xsl:if>
			st.execute(sb.toString());
			updateOldKeys();
			
		}
	}
</xsl:if>

<!--
	==================================================================================================================
	Insert methods
	==================================================================================================================
-->
	/**
	 * Inserts this new object to a new row (all columns are inserted, except the identities)
	 * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
	 * as set by the insert into () sql.
	 * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
	 * Thus, some synchronization maybe necessary for this call to complete atomically.
	 */
	public synchronized void insert() throws SQLException
	{
		StringBuffer sb=new StringBuffer("INSERT INTO <xsl:value-of select="CLASSINFO/@tableName"/>(");
		<xsl:for-each select="COLUMN[@identity='0' and @javaType!='java.io.InputStream']">
			<xsl:if test="@nullable=1">
				if (get<xsl:value-of select="@name"/>()!=null)
				{
			</xsl:if>
			<xsl:if test="position()!=1">sb.append(",");</xsl:if>
			sb.append("<xsl:value-of select="@name"/>");
			<xsl:if test="@nullable=1">
				}
			</xsl:if>
		</xsl:for-each>
		sb.append(") VALUES(");
		<xsl:for-each select="COLUMN[@identity='0' and @javaType!='java.io.InputStream']">
			<xsl:if test="@nullable=1">
				if (get<xsl:value-of select="@name"/>()!=null)
				{
			</xsl:if>
			<xsl:if test="position()!=1">sb.append(",");</xsl:if>
			sb.append("'");
			sb.append(get<xsl:value-of select="@name"/>());
			sb.append("'");
			<xsl:if test="@nullable=1">
				}
			</xsl:if>
		</xsl:for-each>
		sb.append(")");
		<xsl:if test="template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		st.execute(sb.toString());
		// find the identity of the autoincrements
	<xsl:for-each select="COLUMN[@identity='1']">
		ResultSet rs=st.executeQuery("SELECT @@IDENTITY");
		rs.next();
		set<xsl:value-of select="@name"/>(rs.get<xsl:value-of select="@resultSetGetSet"/>(1));
		rs.close();
	</xsl:for-each>
	<xsl:if test="count(PRIMARYKEYS)>0">	
		updateOldKeys();
	</xsl:if>
	}

<!--
	==================================================================================================================
	Getters/Setters for the cross referenced classes.
	==================================================================================================================
-->
<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
	<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>
	/**
	 * Sets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> to reference the ref row of <xsl:value-of select="@references"/>
	 */
	public void set<xsl:value-of select="@helpStr"/>Ref(<xsl:value-of select="$refclass"/> ref)
	{
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				set<xsl:value-of select="@fkcolumn"/>(ref.get<xsl:value-of select="@pkcolumn"/>());
			</xsl:when>
			<xsl:otherwise>
				set<xsl:value-of select="@fkcolumn"/>(new <xsl:value-of select="@fkcolumnJavaType"/>(ref.get<xsl:value-of select="@pkcolumn"/>()));
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>		
	}

	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref() throws SQLException
	{
		return get<xsl:value-of select="@helpStr"/>Ref(st);
	}
	
	/**
	 * Gets this row of <xsl:value-of select="//CLASSINFO/@tableName"/> from referenced row of <xsl:value-of select="@references"/>
	 */
	public <xsl:value-of select="$refclass"/> get<xsl:value-of select="@helpStr"/>Ref(Statement st) throws SQLException
	{
		<xsl:if test="count(CROSSREFERENCE[@fkNullable!=0])">
			if (
				<xsl:for-each select="CROSSREFERENCE[@fkNullable!=0]">
					<xsl:if test="position()>1">||</xsl:if>
					get<xsl:value-of select="@fkcolumn"/>()==null
				</xsl:for-each>
				) return null;
		</xsl:if>	
			
		return new <xsl:value-of select="$refclass"/>(st
	<xsl:for-each select="CROSSREFERENCE">
		<xsl:choose>
			<xsl:when test="@fkNullable=0">
				,get<xsl:value-of select="@fkcolumn"/>()
			</xsl:when>
			<xsl:otherwise>
				,get<xsl:value-of select="@fkcolumn"/>()<xsl:value-of select="@fkcolumnJavaTypePrimitiveConverter"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:for-each>);	
	}
</xsl:for-each>
<!--
	==================================================================================================================
	Debugging helpers.
	==================================================================================================================
-->
	public void dump(String prefix)
	{
	<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
		System.out.println(prefix+"<xsl:value-of select="@name"/>:"+get<xsl:value-of select="@name"/>());
	</xsl:for-each>
	}
	
	public void dump()
	{
		dump("");
	}
<!--
	==================================================================================================================
	XML utilities
	==================================================================================================================
-->
	/**
	 * returns the XML form of this object and depth childs, using the Statement used to construct this instance
	 */
	public Element toXML(int depth) throws SQLException
	{
		return toXML(depth,st);
	}

	/**
	 * returns the XML form of this object and depth childs
	 */
	public Element toXML(int depth,Statement st) throws SQLException
	{
		Element root=new Element("<xsl:value-of select="CLASSNAME"/>");
		<xsl:for-each select="COLUMN[@javaType!='java.io.InputStream']">
			<xsl:choose>
				<xsl:when test="@toXmlMode=0">
					root.setAttribute("<xsl:value-of select="@name"/>",
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
					get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
					);
				</xsl:when>
				<xsl:when test="@toXmlMode=1">
					root.addContent(new Element("<xsl:value-of select="@name"/>").setText(
					<xsl:if test="@javaType!='String'">String.valueOf(</xsl:if>
						get<xsl:value-of select="@name"/>()
					<xsl:if test="@javaType!='String'">)</xsl:if>
						));
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		
		if (depth>0)
		{
		<xsl:for-each select="CROSSREFERENCES/RELATIONSHIP">
			<xsl:variable name="refclass"><xsl:value-of select="@references"/><xsl:value-of select="//template/ext"/></xsl:variable>
			<xsl:value-of select="$refclass"/>&nbsp;temp<xsl:value-of select="position()"/>=get<xsl:value-of select="@helpStr"/>Ref(st);
			if (temp<xsl:value-of select="position()"/>!=null) root.addContent(temp<xsl:value-of select="position()"/>.toXML(depth-1,st));
 		</xsl:for-each>
		}
		return root;
	}
	
	/**
	 * returns the XML form of this object only
	 */
	public Element toXML() throws SQLException
	{
		return toXML(0);
	}
<!--
	==================================================================================================================
	Special Query Code
	==================================================================================================================
-->
<xsl:for-each select="//commonParams/specialQueryCode/table[@name=//CLASSINFO/@tableName]">
	/**
	 * Gets a ResultSet of <xsl:value-of select="//CLASSNAME"/>'s
	 */
	public static ResultSet get<xsl:value-of select="@functionName"/>ResultSet(Statement st, 
	<xsl:for-each select="whereParam">
		<xsl:if test="position()>1">,</xsl:if><xsl:value-of select="@javaType"/> p<xsl:value-of select="position()"/>
	</xsl:for-each>
		) throws SQLException
	{
		StringBuffer sb=new StringBuffer("SELECT * FROM <xsl:value-of select="//CLASSINFO/@tableName"/> WHERE");

		<xsl:for-each select="whereParam">
			sb.append(" <xsl:value-of select="."/>'").append(p<xsl:value-of select="position()"/>).append("'");
		</xsl:for-each>
		
		<xsl:if test="//template/debug>0">
			// template/debug was set to >0 during conversion
			System.out.println(sb.toString());
		</xsl:if>
		return st.executeQuery(sb.toString());
	}
</xsl:for-each>
	
<!--
	==================================================================================================================
	END OF CLASS
	==================================================================================================================
-->
}
<!--
	==================================================================================================================
	End of the template
	==================================================================================================================
-->

</xsl:template>


</xsl:stylesheet>