package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Order Details <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class Order_DetailsCached extends Order_DetailsBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public Order_DetailsCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected Order_DetailsCached(CS cs, int OrderID, int ProductID)
        throws SQLException {
        super(cs, OrderID, ProductID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Order_DetailsCached(CS cs, ResultSet rs)
        throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of Order Details to reference the ref row of Orders
     */
    public void setOrderIDRef(OrdersCached ref) {
        setOrderID(ref.getOrderID());
    }

    /**
     * Gets this row of Order Details from referenced row of Orders
     */
    public OrdersCached getOrderIDRef()
        throws SQLException, CloneNotSupportedException {
        return getOrderIDRef(cs);
    }

    /**
     * Gets this row of Order Details from referenced row of Orders
     */
    public OrdersCached getOrderIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        return OrdersCached.instance(cs, getOrderID());
    }

    /**
     * Sets this row of Order Details to reference the ref row of Products
     */
    public void setProductIDRef(ProductsCached ref) {
        setProductID(ref.getProductID());
    }

    /**
     * Gets this row of Order Details from referenced row of Products
     */
    public ProductsCached getProductIDRef()
        throws SQLException, CloneNotSupportedException {
        return getProductIDRef(cs);
    }

    /**
     * Gets this row of Order Details from referenced row of Products
     */
    public ProductsCached getProductIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        return ProductsCached.instance(cs, getProductID());
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field OrderID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithOrderIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field OrderID
     * for equality with the same OrderID as this instance.
     */
    public Iterator getIteratorWithSameValueOfOrderID(int maxResults)
        throws SQLException {
        return getIteratorWithOrderIDValueOf(cs, getOrderID(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field OrderID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithOrderIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithOrderIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field ProductID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getIteratorWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field ProductID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitPriceValueOf(CS cs,
        double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitPriceValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getIteratorWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitPriceValueOf(CS cs, double value,
        int maxResults) throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field Quantity
     * for equality with the same Quantity as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfQuantity(int maxResults)
        throws SQLException {
        return getLinkedListWithQuantityValueOf(cs, getQuantity(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field Quantity
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithQuantityValueOf(CS cs,
        short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithQuantityValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field Quantity
     * for equality with the same Quantity as this instance.
     */
    public Iterator getIteratorWithSameValueOfQuantity(int maxResults)
        throws SQLException {
        return getIteratorWithQuantityValueOf(cs, getQuantity(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field Quantity
     * for equality with the "value".
     */
    public static Iterator getIteratorWithQuantityValueOf(CS cs, short value,
        int maxResults) throws SQLException {
        return getLinkedListWithQuantityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field Discount
     * for equality with the same Discount as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfDiscount(int maxResults)
        throws SQLException {
        return getLinkedListWithDiscountValueOf(cs, getDiscount(), maxResults);
    }

    /**
     * Gets a LinkedList of Order_DetailsCached's by querying table field Discount
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithDiscountValueOf(CS cs,
        float value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithDiscountValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Order_DetailsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field Discount
     * for equality with the same Discount as this instance.
     */
    public Iterator getIteratorWithSameValueOfDiscount(int maxResults)
        throws SQLException {
        return getIteratorWithDiscountValueOf(cs, getDiscount(), maxResults);
    }

    /**
     * Gets an Iterator of Order_DetailsCached's by querying table field Discount
     * for equality with the "value".
     */
    public static Iterator getIteratorWithDiscountValueOf(CS cs, float value,
        int maxResults) throws SQLException {
        return getLinkedListWithDiscountValueOf(cs, value, maxResults).iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return Order_DetailsCached.delete(cs, OrderID, ProductID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int OrderID, int ProductID)
        throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                Order_DetailsCached.class,
                
            new Integer(OrderID), new Integer(ProductID)
            });

        return Order_DetailsBase.delete(cs, OrderID, ProductID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            Cache.getCache().removeSynchronized(new Object[] {
                    Order_DetailsCached.class,
                    
                new Integer(old_OrderID), new Integer(old_ProductID)
                });

            int res = super.updateAll();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] {
            Order_DetailsCached.class,
            
            new Integer(OrderID), new Integer(ProductID)
        };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached Order_DetailsCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] {
                Order_DetailsCached.class
            });
    }

    /**
     * Flush a cached Order_DetailsCached item.
     */
    public static void flushCache(int OrderID, int ProductID) {
        Cache.getCache().removeSynchronized(new Object[] {
                Order_DetailsCached.class,
                
            new Integer(OrderID), new Integer(ProductID)
            });
    }

    private static Order_DetailsCached cacheLookup(int OrderID, int ProductID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (Order_DetailsCached.class) {
            Order_DetailsCached t = (Order_DetailsCached) c.get(new Object[] {
                        Order_DetailsCached.class,
                        
                    new Integer(OrderID), new Integer(ProductID)
                    });

            if (t != null) {
                return (Order_DetailsCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static Order_DetailsCached instance(CS cs, int OrderID, int ProductID)
        throws SQLException, CloneNotSupportedException {
        Order_DetailsCached t = cacheLookup(OrderID, ProductID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new Order_DetailsCached(cs, OrderID, ProductID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("Order_DetailsCached");

        root.setAttribute("OrderID", String.valueOf(getOrderID()));

        root.setAttribute("ProductID", String.valueOf(getProductID()));

        root.setAttribute("UnitPrice", String.valueOf(getUnitPrice()));

        root.setAttribute("Quantity", String.valueOf(getQuantity()));

        root.setAttribute("Discount", String.valueOf(getDiscount()));

        if (depth > 0) {
            OrdersCached temp1 = getOrderIDRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }

            ProductsCached temp2 = getProductIDRef(cs);

            if (temp2 != null) {
                root.addContent(temp2.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
