package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Customer and Suppliers by City<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Customer_and_Suppliers_by_CityBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String City;
    protected String CompanyName;
    protected String ContactName;
    protected String Relationship;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Customer_and_Suppliers_by_CityBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Customer_and_Suppliers_by_CityBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Customer_and_Suppliers_by_CityBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        City = rs.getString("City");
        CompanyName = rs.getString("CompanyName");
        ContactName = rs.getString("ContactName");
        Relationship = rs.getString("Relationship");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCity() {
        return City;
    }

    /**
     * Setter for City.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCity(String value) {
        this.City = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getResultSetWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCityValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Customer_and_Suppliers_by_CityBase_City");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getLinkedListWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCityValueOf(cs, value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Customer_and_Suppliers_by_CityBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the same City as this instance.
     */
    public Iterator getIteratorWithSameValueOfCity(int maxResults)
        throws SQLException {
        return getIteratorWithCityValueOf(cs, getCity(), maxResults);
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field City
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCityValueOf(CS cs, String value,
        int maxResults) throws SQLException {
        return getLinkedListWithCityValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Getter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCompanyName() {
        return CompanyName;
    }

    /**
     * Setter for CompanyName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCompanyName(String value) {
        this.CompanyName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCompanyName(
        int maxResults) throws SQLException {
        return getResultSetWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Customer_and_Suppliers_by_CityBase_CompanyName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCompanyNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Customer_and_Suppliers_by_CityBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the same CompanyName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCompanyName(int maxResults)
        throws SQLException {
        return getIteratorWithCompanyNameValueOf(cs, getCompanyName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field CompanyName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCompanyNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCompanyNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ContactName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getContactName() {
        return ContactName;
    }

    /**
     * Setter for ContactName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setContactName(String value) {
        this.ContactName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfContactName(
        int maxResults) throws SQLException {
        return getResultSetWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Customer_and_Suppliers_by_CityBase_ContactName");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.VARCHAR);
            } else {
                cc.setString(1, value);
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithContactNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Customer_and_Suppliers_by_CityBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the same ContactName as this instance.
     */
    public Iterator getIteratorWithSameValueOfContactName(int maxResults)
        throws SQLException {
        return getIteratorWithContactNameValueOf(cs, getContactName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field ContactName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithContactNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithContactNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for Relationship.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getRelationship() {
        return Relationship;
    }

    /**
     * Setter for Relationship.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRelationship(String value) {
        this.Relationship = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRelationship(
        int maxResults) throws SQLException {
        return getResultSetWithRelationshipValueOf(cs, getRelationship(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRelationshipValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Customer_and_Suppliers_by_CityBase_Relationship");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the same Relationship as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRelationship(int maxResults)
        throws SQLException {
        return getLinkedListWithRelationshipValueOf(cs, getRelationship(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRelationshipValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRelationshipValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Customer_and_Suppliers_by_CityBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the same Relationship as this instance.
     */
    public Iterator getIteratorWithSameValueOfRelationship(int maxResults)
        throws SQLException {
        return getIteratorWithRelationshipValueOf(cs, getRelationship(),
            maxResults);
    }

    /**
     * Gets an Iterator of Customer_and_Suppliers_by_CityBase's by querying table field Relationship
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRelationshipValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithRelationshipValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Customer_and_Suppliers_by_CityBase");

            cc.setString(1, getCity());

            cc.setString(2, getCompanyName());

            cc.setString(3, getContactName());

            cc.setString(4, getRelationship());

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "City:" + getCity());

        System.out.println(prefix + "CompanyName:" + getCompanyName());

        System.out.println(prefix + "ContactName:" + getContactName());

        System.out.println(prefix + "Relationship:" + getRelationship());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(City);
        sb.append(",");
        sb.append(CompanyName);
        sb.append(",");
        sb.append(ContactName);
        sb.append(",");
        sb.append(Relationship);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
