/*
 * Decompiled with CFR 0.152.
 */
package org.aris.dbutils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.aris.dbutils.ColumnInfo;
import org.aris.dbutils.CrossReferenceInfo;
import org.aris.dbutils.PrimaryKeyInfo;
import org.aris.dbutils.TableInfo;

public class DBInfo {
    private DatabaseMetaData dbmd;
    private Hashtable gtCache = new Hashtable();
    private LinkedList columnsList;
    private Hashtable gcCache1 = new Hashtable();
    private Hashtable gcCache2 = new Hashtable();
    private Hashtable gpkCache = new Hashtable();
    private Hashtable gcrCache = new Hashtable();
    private Hashtable gcrmCache = new Hashtable();

    public DBInfo(Connection con) throws SQLException {
        this.dbmd = con.getMetaData();
    }

    public TreeMap getDatabases() throws SQLException {
        TreeMap<String, String> ll = new TreeMap<String, String>();
        ResultSet rs = this.dbmd.getCatalogs();
        while (rs.next()) {
            String name = rs.getString(1);
            ll.put(name, name);
        }
        rs.close();
        return ll;
    }

    public TreeMap getTables(String catalog) throws SQLException {
        TreeMap<String, TableInfo> ll = (TreeMap<String, TableInfo>)this.gtCache.get(catalog);
        if (ll == null) {
            ll = new TreeMap<String, TableInfo>();
            ResultSet rs = this.dbmd.getTables(catalog, null, null, null);
            while (rs.next()) {
                TableInfo ti = new TableInfo(rs);
                ll.put(ti.getTABLE_NAME(), ti);
            }
            rs.close();
        }
        return ll;
    }

    public TreeMap getColumns(String catalog, String table) throws SQLException {
        String cache = String.valueOf(catalog) + "_" + table;
        TreeMap<String, ColumnInfo> ll = (TreeMap<String, ColumnInfo>)this.gcCache1.get(cache);
        if (ll == null) {
            TreeMap refer = this.getCrossReferences(catalog, table);
            TreeMap pk = this.getPrimaryKeys(catalog, table);
            ll = new TreeMap<String, ColumnInfo>();
            this.columnsList = new LinkedList();
            this.gcCache1.put(cache, ll);
            this.gcCache2.put(cache, this.columnsList);
            ResultSet rs = this.dbmd.getColumns(catalog, null, table, null);
            while (rs.next()) {
                ColumnInfo ci = new ColumnInfo(rs, refer, pk);
                ll.put(ci.getCOLUMN_NAME(), ci);
                this.columnsList.addLast(ci);
            }
            rs.close();
        } else {
            this.columnsList = (LinkedList)this.gcCache2.get(cache);
        }
        return ll;
    }

    public TreeMap getPrimaryKeys(String catalog, String table) throws SQLException {
        String cache = String.valueOf(catalog) + "_" + table;
        TreeMap<String, PrimaryKeyInfo> ll = (TreeMap<String, PrimaryKeyInfo>)this.gpkCache.get(cache);
        if (ll == null) {
            ll = new TreeMap<String, PrimaryKeyInfo>();
            this.gpkCache.put(cache, ll);
            ResultSet rs = this.dbmd.getPrimaryKeys(catalog, null, table);
            while (rs.next()) {
                PrimaryKeyInfo pk = new PrimaryKeyInfo(rs);
                ll.put(pk.getCOLUMN_NAME(), pk);
            }
            rs.close();
        }
        return ll;
    }

    public synchronized Iterator getColumnsIterator(String catalog, String table) throws SQLException {
        this.getColumns(catalog, table);
        return this.columnsList.iterator();
    }

    public TreeMap getCrossReferences(String catalog, String table) throws SQLException {
        String cache = String.valueOf(catalog) + "_" + table;
        TreeMap<String, CrossReferenceInfo> ll = (TreeMap<String, CrossReferenceInfo>)this.gcrCache.get(cache);
        if (ll == null) {
            ll = new TreeMap<String, CrossReferenceInfo>();
            ResultSet rs = this.dbmd.getImportedKeys(catalog, null, table);
            while (rs.next()) {
                CrossReferenceInfo ci = new CrossReferenceInfo(rs);
                ll.put(ci.getFKCOLUMN_NAME(), ci);
            }
            rs.close();
        }
        return ll;
    }

    public TreeMap getCrossReferencesMatched(String catalog, String table) throws SQLException {
        String cache = String.valueOf(catalog) + "_" + table;
        TreeMap<String, LinkedList<CrossReferenceInfo>> tme = (TreeMap<String, LinkedList<CrossReferenceInfo>>)this.gcrmCache.get(cache);
        if (tme == null) {
            tme = new TreeMap<String, LinkedList<CrossReferenceInfo>>();
            TreeMap tm = this.getCrossReferences(catalog, table);
            Iterator itcr = tm.values().iterator();
            while (itcr.hasNext()) {
                CrossReferenceInfo cri = (CrossReferenceInfo)itcr.next();
                String fkname = cri.getFK_NAME();
                LinkedList<CrossReferenceInfo> ll = (LinkedList<CrossReferenceInfo>)tme.get(fkname);
                if (ll == null) {
                    ll = new LinkedList<CrossReferenceInfo>();
                    tme.put(fkname, ll);
                }
                ll.add(cri);
            }
        }
        return tme;
    }

    public void dump() {
        System.out.println("[DATABASES]");
        System.out.println("==========================================");
        try {
            Iterator itdb = this.getDatabases().entrySet().iterator();
            while (itdb.hasNext()) {
                String catalog = (String)itdb.next().getValue();
                this.dumpCatalog(catalog, null);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void dumpCatalog(String catalog, String tableTypeFilter) {
        System.out.println("[" + catalog + "]");
        try {
            Iterator itt = this.getTables(catalog).entrySet().iterator();
            if (itt.hasNext()) {
                TableInfo.dumpHeader();
            }
            while (itt.hasNext()) {
                TableInfo ti = (TableInfo)itt.next().getValue();
                if (tableTypeFilter != null && !ti.getTABLE_TYPE().equals(tableTypeFilter)) continue;
                ti.dump();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void dumpTable(String catalog, String table) {
        System.out.println("[" + catalog + "-" + table + "]");
        try {
            Iterator itt = this.getColumns(catalog, table).entrySet().iterator();
            while (itt.hasNext()) {
                ColumnInfo ci = (ColumnInfo)itt.next().getValue();
                ci.dump();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void dumpCrossReferences(String catalog, String table) {
        System.out.println("[" + catalog + "-" + table + "  ** Cross references]");
        try {
            Iterator itt = this.getCrossReferences(catalog, table).entrySet().iterator();
            while (itt.hasNext()) {
                CrossReferenceInfo ci = (CrossReferenceInfo)itt.next().getValue();
                ci.dump();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

