/*
 * Decompiled with CFR 0.152.
 */
package org.aris.dbutils;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeMap;
import org.aris.dbutils.CrossReferenceInfo;
import org.aris.dbutils.PrimaryKeyInfo;
import org.aris.oodb.db.DbColumnConvert;
import org.aris.oodb.db.DbI;
import org.jdom.Element;

public class ColumnInfo {
    private String TABLE_CAT;
    private String TABLE_SCHEM;
    private String TABLE_NAME;
    private String TYPE_NAME;
    private String REMARKS;
    private String COLUMN_DEF;
    private String IS_NULLABLE;
    private String SCOPE_CATLOG;
    private String SCOPE_SCHEMA;
    private String SCOPE_TABLE;
    private String COLUMN_NAME;
    private int NULLABLE;
    private int NUM_PREC_RADIX;
    private int DECIMAL_DIGITS;
    private int COLUMN_SIZE;
    private int CHAR_OCTET_LENGTH;
    private int ORDINAL_POSITION;
    private int SOURCE_DATA_TYPE;
    private int DATA_TYPE;
    private CrossReferenceInfo crossReferenceInfo;
    private PrimaryKeyInfo primaryKeyInfo;

    public String getJavaType(DbI dbi) {
        DbColumnConvert dbcc = dbi.getJavaType(this);
        return dbcc.getJavaType();
    }

    public Element toXML(DbI dbi) {
        Element root = new Element("COLUMN");
        root.setAttribute("name", this.getCOLUMN_NAME());
        PrimaryKeyInfo pki = this.getPrimaryKeyInfo();
        if (pki != null) {
            root.setAttribute("primaryKey", pki.getPK_NAME());
            root.setAttribute("primaryKeySeq", String.valueOf(pki.getKEY_SEQ()));
        } else {
            root.setAttribute("primaryKey", "");
        }
        root.setAttribute("identity", dbi.isIdentity(this) ? "1" : "0");
        DbColumnConvert dbcc = dbi.getJavaType(this);
        root.setAttribute("javaType", this.getJavaType(dbi));
        root.setAttribute("asObject", dbcc.getAsObjectType());
        root.setAttribute("dbType", dbcc.getDbType());
        root.setAttribute("dbTypeDef", dbcc.getDbTypeDef());
        root.setAttribute("dbSize", String.valueOf(this.getCOLUMN_SIZE()));
        root.setAttribute("allocateVar", dbcc.isAllocate() ? "1" : "0");
        root.setAttribute("resultSetGetSet", dbcc.getResultSetCall());
        CrossReferenceInfo cri = this.getCrossReferenceInfo();
        String crossRef = "0";
        if (cri != null) {
            root.setAttribute("FK_table", cri.getPKTABLE_NAME());
            root.setAttribute("FK_column", cri.getPKCOLUMN_NAME());
            crossRef = "1";
        }
        root.setAttribute("crossRef", crossRef);
        root.setAttribute("order", String.valueOf(this.getORDINAL_POSITION()));
        root.setAttribute("nullable", this.getNULLABLE() == 0 ? "0" : "1");
        root.setAttribute("toXmlMode", String.valueOf(dbcc.getToXMLAttribute()));
        root.setAttribute("convertorToPrimitive", dbcc.getConvertorToPrimitive());
        root.setAttribute("java.sql.Types", dbcc.getJava_sql_type());
        if (this.getREMARKS() != null) {
            root.setAttribute("remarks", this.getREMARKS());
        } else {
            root.setAttribute("remarks", "No remarks for this field in the database (or the database driver doesn't return column remarks).");
        }
        return root;
    }

    public void dump() {
        System.out.println("\t[" + this.COLUMN_NAME + "]");
        System.out.println("\t\tTABLE_CAT:" + this.TABLE_CAT);
        System.out.println("\t\tTABLE_SCHEM:" + this.TABLE_SCHEM);
        System.out.println("\t\tTABLE_NAME:" + this.TABLE_NAME);
        System.out.println("\t\tTYPE_NAME:" + this.TYPE_NAME);
        System.out.println("\t\tREMARKS:" + this.REMARKS);
        System.out.println("\t\tCOLUMN_DEF:" + this.COLUMN_DEF);
        System.out.println("\t\tIS_NULLABLE:" + this.IS_NULLABLE);
        System.out.println("\t\tSCOPE_CATLOG:" + this.SCOPE_CATLOG);
        System.out.println("\t\tSCOPE_SCHEMA:" + this.SCOPE_SCHEMA);
        System.out.println("\t\tSCOPE_TABLE:" + this.SCOPE_TABLE);
        System.out.println("\t\tCOLUMN_NAME:" + this.COLUMN_NAME);
        System.out.println("\t\tNULLABLE:" + this.NULLABLE);
        System.out.println("\t\tNUM_PREC_RADIX:" + this.NUM_PREC_RADIX);
        System.out.println("\t\tDECIMAL_DIGITS:" + this.DECIMAL_DIGITS);
        System.out.println("\t\tCOLUMN_SIZE:" + this.COLUMN_SIZE);
        System.out.println("\t\tCHAR_OCTET_LENGTH:" + this.CHAR_OCTET_LENGTH);
        System.out.println("\t\tORDINAL_POSITION:" + this.ORDINAL_POSITION);
        System.out.println("\t\tSOURCE_DATA_TYPE:" + this.SOURCE_DATA_TYPE);
        System.out.println("\t\tDATA_TYPE:" + this.DATA_TYPE);
        CrossReferenceInfo cri = this.getCrossReferenceInfo();
        if (cri != null) {
            System.out.println("\t\t===== HAS CROSS REFERENCES ========");
            cri.dump();
            System.out.println("\t\t===== END OF CROSS REFERENCES =====");
        }
    }

    public ColumnInfo(ResultSet rs, TreeMap refer, TreeMap pk) {
        try {
            this.setCHAR_OCTET_LENGTH(rs.getInt("CHAR_OCTET_LENGTH"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setCOLUMN_DEF(rs.getString("COLUMN_DEF"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setCOLUMN_NAME(rs.getString("COLUMN_NAME"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setCOLUMN_SIZE(rs.getInt("COLUMN_SIZE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setDATA_TYPE(rs.getInt("DATA_TYPE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setDECIMAL_DIGITS(rs.getInt("DECIMAL_DIGITS"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setIS_NULLABLE(rs.getString("IS_NULLABLE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setNULLABLE(rs.getInt("NULLABLE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setNUM_PREC_RADIX(rs.getInt("NUM_PREC_RADIX"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setORDINAL_POSITION(rs.getInt("ORDINAL_POSITION"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setREMARKS(rs.getString("REMARKS"));
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        try {
            this.setSCOPE_CATLOG(rs.getString("SCOPE_CATLOG"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setSCOPE_SCHEMA(rs.getString("SCOPE_SCHEMA"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setSCOPE_TABLE(rs.getString("SCOPE_TABLE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setSOURCE_DATA_TYPE(rs.getInt("SOURCE_DATA_TYPE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTABLE_CAT(rs.getString("TABLE_CAT"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTABLE_NAME(rs.getString("TABLE_NAME"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTABLE_SCHEM(rs.getString("TABLE_SCHEM"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            this.setTYPE_NAME(rs.getString("TYPE_NAME"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.setCrossReferenceInfo((CrossReferenceInfo)refer.get(this.getCOLUMN_NAME()));
        this.setPrimaryKeyInfo((PrimaryKeyInfo)pk.get(this.getCOLUMN_NAME()));
    }

    public int getCHAR_OCTET_LENGTH() {
        return this.CHAR_OCTET_LENGTH;
    }

    public void setCHAR_OCTET_LENGTH(int char_octet_length) {
        this.CHAR_OCTET_LENGTH = char_octet_length;
    }

    public String getCOLUMN_DEF() {
        return this.COLUMN_DEF;
    }

    public void setCOLUMN_DEF(String column_def) {
        this.COLUMN_DEF = column_def;
    }

    public String getCOLUMN_NAME() {
        return this.COLUMN_NAME;
    }

    public void setCOLUMN_NAME(String column_name) {
        this.COLUMN_NAME = String.valueOf(column_name.substring(0, 1).toUpperCase()) + column_name.substring(1);
    }

    public int getCOLUMN_SIZE() {
        return this.COLUMN_SIZE;
    }

    public void setCOLUMN_SIZE(int column_size) {
        this.COLUMN_SIZE = column_size;
    }

    public int getDATA_TYPE() {
        return this.DATA_TYPE;
    }

    public void setDATA_TYPE(int data_type) {
        this.DATA_TYPE = data_type;
    }

    public int getDECIMAL_DIGITS() {
        return this.DECIMAL_DIGITS;
    }

    public void setDECIMAL_DIGITS(int decimal_digits) {
        this.DECIMAL_DIGITS = decimal_digits;
    }

    public String getIS_NULLABLE() {
        return this.IS_NULLABLE;
    }

    public void setIS_NULLABLE(String is_nullable) {
        this.IS_NULLABLE = is_nullable;
    }

    public int getNULLABLE() {
        return this.NULLABLE;
    }

    public void setNULLABLE(int nullable) {
        this.NULLABLE = nullable;
    }

    public int getNUM_PREC_RADIX() {
        return this.NUM_PREC_RADIX;
    }

    public void setNUM_PREC_RADIX(int num_prec_radix) {
        this.NUM_PREC_RADIX = num_prec_radix;
    }

    public int getORDINAL_POSITION() {
        return this.ORDINAL_POSITION;
    }

    public void setORDINAL_POSITION(int ordinal_position) {
        this.ORDINAL_POSITION = ordinal_position;
    }

    public String getREMARKS() {
        return this.REMARKS;
    }

    public void setREMARKS(String remarks) {
        this.REMARKS = remarks;
    }

    public String getSCOPE_CATLOG() {
        return this.SCOPE_CATLOG;
    }

    public void setSCOPE_CATLOG(String scope_catlog) {
        this.SCOPE_CATLOG = scope_catlog;
    }

    public String getSCOPE_SCHEMA() {
        return this.SCOPE_SCHEMA;
    }

    public void setSCOPE_SCHEMA(String scope_schema) {
        this.SCOPE_SCHEMA = scope_schema;
    }

    public String getSCOPE_TABLE() {
        return this.SCOPE_TABLE;
    }

    public void setSCOPE_TABLE(String scope_table) {
        this.SCOPE_TABLE = scope_table;
    }

    public int getSOURCE_DATA_TYPE() {
        return this.SOURCE_DATA_TYPE;
    }

    public void setSOURCE_DATA_TYPE(int source_data_type) {
        this.SOURCE_DATA_TYPE = source_data_type;
    }

    public String getTABLE_CAT() {
        return this.TABLE_CAT;
    }

    public void setTABLE_CAT(String table_cat) {
        this.TABLE_CAT = table_cat;
    }

    public String getTABLE_NAME() {
        return this.TABLE_NAME;
    }

    public void setTABLE_NAME(String table_name) {
        this.TABLE_NAME = table_name;
    }

    public String getTABLE_SCHEM() {
        return this.TABLE_SCHEM;
    }

    public void setTABLE_SCHEM(String table_schem) {
        this.TABLE_SCHEM = table_schem;
    }

    public String getTYPE_NAME() {
        return this.TYPE_NAME;
    }

    public void setTYPE_NAME(String type_name) {
        this.TYPE_NAME = type_name;
    }

    public CrossReferenceInfo getCrossReferenceInfo() {
        return this.crossReferenceInfo;
    }

    public void setCrossReferenceInfo(CrossReferenceInfo crossReferenceInfo) {
        this.crossReferenceInfo = crossReferenceInfo;
    }

    public PrimaryKeyInfo getPrimaryKeyInfo() {
        return this.primaryKeyInfo;
    }

    public void setPrimaryKeyInfo(PrimaryKeyInfo primaryKeyInfo) {
        this.primaryKeyInfo = primaryKeyInfo;
    }
}

