// StartView.cpp : implementation file
//

#include "stdafx.h"
#include "bcgcbdotnetexample.h"
#include "StartView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStartView

IMPLEMENT_DYNCREATE(CStartView, CScrollView)

CStartView::CStartView()
{
	m_sizeImage = CSize (0, 0);
}

CStartView::~CStartView()
{
}

BEGIN_MESSAGE_MAP(CStartView, CScrollView)
	//{{AFX_MSG_MAP(CStartView)
	ON_WM_ERASEBKGND()
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnDisableUpdate)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_AS, OnDisableUpdate)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_SETUP, OnDisableUpdate)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT_PREVIEW, OnDisableUpdate)
	ON_UPDATE_COMMAND_UI(ID_FILE_PRINT, OnDisableUpdate)
	//}}AFX_MSG_MAP
	ON_UPDATE_COMMAND_UI(IDS_CARET_POS, OnCaretPos)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStartView diagnostics

#ifdef _DEBUG
void CStartView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CStartView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStartView message handlers

void CStartView::OnInitialUpdate() 
{
	CDocument* pDoc = GetDocument ();
	ASSERT_VALID (pDoc);

	m_Bmp.LoadBitmap (IDB_START);

	BITMAP bmp;
	m_Bmp.GetBitmap (&bmp);

	m_sizeImage.cx = bmp.bmWidth;
	m_sizeImage.cy = bmp.bmHeight;

	SetScrollSizes (MM_TEXT, m_sizeImage);
	pDoc->SetTitle (_T("Start Page"));
}

void CStartView::OnDraw(CDC* pDCPaint) 
{
	CDC*		pDC = pDCPaint;
	BOOL		m_bMemDC = FALSE;
	CDC			dcMem;
	CBitmap		bmp;
	CBitmap*	pOldBmp = NULL;

	CRect rect;
	GetClientRect (rect);

	rect.right += GetScrollPos (SB_HORZ);
	rect.bottom += GetScrollPos (SB_VERT);

	if (dcMem.CreateCompatibleDC (pDCPaint) &&
		bmp.CreateCompatibleBitmap (pDCPaint, rect.Width (),
								  rect.Height ()))
	{
		//-------------------------------------------------------------
		// Off-screen DC successfully created. Better paint to it then!
		//-------------------------------------------------------------
		m_bMemDC = TRUE;
		pOldBmp = dcMem.SelectObject (&bmp);
		pDC = &dcMem;
	}

	pDC->FillSolidRect (rect, RGB (255, 255, 255));
	pDC->DrawState (CPoint (0, 0), m_sizeImage, &m_Bmp, DSS_NORMAL);

	if (m_bMemDC)
	{
		//--------------------------------------
		// Copy the results to the on-screen DC:
		//-------------------------------------- 
		CRect rectClip;
		int nClipType = pDCPaint->GetClipBox (rectClip);
		if (nClipType != NULLREGION)
		{
			if (nClipType != SIMPLEREGION)
			{
				rectClip = rect;
			}

			pDCPaint->BitBlt (rectClip.left, rectClip.top, rectClip.Width(), rectClip.Height(),
						   &dcMem, rectClip.left, rectClip.top, SRCCOPY);
		}

		dcMem.SelectObject(pOldBmp);
	}
}

void CStartView::OnCaretPos(CCmdUI* pCmdUI)
{
	pCmdUI->SetText (_T(""));
	pCmdUI->Enable(FALSE);
}

BOOL CStartView::OnEraseBkgnd(CDC* /*pDC*/) 
{
	return TRUE;
}

void CStartView::OnDisableUpdate(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(FALSE);
}
