@Echo off
REM This is the simulation master file that runs on one machine.
REM It is responsible for assigning new tasks to slave machines
REM when they are ready for them.
for /f "Tokens=*" %%a in ('dir /b /a-d "%MasterPath%\*.Don"') do call :StartOne "%%a"
:end
REM sleep for n=180 seconds, then repeat ... indefinitely.
sleep 180
MasterLoop

::This section is called to start a new task on a machine that is done.
:StartOne
::Next %~f1 just selects the file name and ignores path & extension
if "%~n1"=="Dummy" goto end2
MasterStart %~n1
if errorlevel 1 goto notstarted
Set EndReached="No"
del %MasterPath%\%1
Echo Started %~n1 at %time% %date%
Echo Started %~n1 at %time% %date% >> MasterRecord.txt
goto end2
:notstarted
if %EndReached%=="Yes" goto end2
Echo Master has no tasks to assign.
REM Skip the rest if the simulations are not in progress.
If Not Exist %MasterPath%\TaskList.Txt Goto end2
REM
Echo Master has no tasks to assign. >> MasterRecord.txt

REM *** START HERE
REM If you want to receive an email notification when the Master needs another
REM  task to assign (i.e., when a slave finishes and there are no more tasks
REM  to assign), you need to:
REM 1. Delete the REM from the beginning of the blat command line, and
REM 2. Insert your email address at the end of the line after "-to"
REM blat Master.bat -subject "Master has run out of tasks to assign" -to your.email@address.goes.here
REM *** END HERE

set EndReached="Yes"
:end2
