/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import java.util.Locale;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLCharacterRecognizer;
import org.apache.xml.utils.XMLString;
import org.apache.xml.utils.XMLStringFactory;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XMLStringFactoryImpl;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XString
extends XObject
implements XMLString {
    public static XString EMPTYSTRING = new XString("");

    protected XString(Object val) {
        super(val);
    }

    public XString(String val) {
        super(val);
    }

    public boolean bool() {
        return this.str().length() > 0;
    }

    public char charAt(int index) {
        return this.str().charAt(index);
    }

    public int compareTo(XMLString xstr) {
        int len1 = this.length();
        int len2 = xstr.length();
        int n = Math.min(len1, len2);
        int i = 0;
        int j = 0;
        while (n-- != 0) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 != (c2 = xstr.charAt(j))) {
                return c1 - c2;
            }
            ++i;
            ++j;
        }
        return len1 - len2;
    }

    public int compareToIgnoreCase(XMLString str) {
        throw new WrappedRuntimeException(new NoSuchMethodException("Java 1.2 method, not yet implemented"));
    }

    public XMLString concat(String str) {
        return new XString(this.str().concat(str));
    }

    public void dispatchAsComment(LexicalHandler lh) throws SAXException {
        String str = this.str();
        lh.comment(str.toCharArray(), 0, str.length());
    }

    public void dispatchCharactersEvents(ContentHandler ch) throws SAXException {
        String str = this.str();
        ch.characters(str.toCharArray(), 0, str.length());
    }

    public boolean endsWith(String suffix) {
        return this.str().endsWith(suffix);
    }

    public boolean equals(Object obj2) {
        if (obj2 == null) {
            return false;
        }
        if (obj2 instanceof XNodeSet) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.toString());
    }

    public boolean equals(XMLString obj2) {
        if (!obj2.hasString()) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.toString());
    }

    public boolean equals(XObject obj2) {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        return this.str().equals(obj2.str());
    }

    public boolean equalsIgnoreCase(String anotherString) {
        return this.str().equalsIgnoreCase(anotherString);
    }

    public XMLString fixWhiteSpace(boolean trimHead, boolean trimTail, boolean doublePunctuationSpaces) {
        int len = this.length();
        char[] buf = new char[len];
        this.getChars(0, len, buf, 0);
        boolean edit = false;
        int s = 0;
        while (s < len) {
            if (XString.isSpace(buf[s])) break;
            ++s;
        }
        int d = s;
        boolean pres = false;
        while (s < len) {
            char c = buf[s];
            if (XString.isSpace(c)) {
                if (!pres) {
                    if (c != ' ') {
                        edit = true;
                    }
                    buf[d++] = 32;
                    if (doublePunctuationSpaces && s != 0) {
                        char prevChar = buf[s - 1];
                        if (prevChar != '.' && prevChar != '!' && prevChar != '?') {
                            pres = true;
                        }
                    } else {
                        pres = true;
                    }
                } else {
                    edit = true;
                    pres = true;
                }
            } else {
                buf[d++] = c;
                pres = false;
            }
            ++s;
        }
        if (trimTail && d >= 1 && buf[d - 1] == ' ') {
            edit = true;
            --d;
        }
        int start = 0;
        if (trimHead && d > 0 && buf[0] == ' ') {
            edit = true;
            ++start;
        }
        XMLStringFactory xsf = XMLStringFactoryImpl.getFactory();
        return edit ? xsf.newstr(new String(buf, start, d - start)) : this;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this.str().getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public int getType() {
        return 3;
    }

    public String getTypeString() {
        return "#STRING";
    }

    public boolean hasString() {
        return true;
    }

    public int hashCode() {
        return this.str().hashCode();
    }

    public int indexOf(int ch) {
        return this.str().indexOf(ch);
    }

    public int indexOf(int ch, int fromIndex) {
        return this.str().indexOf(ch, fromIndex);
    }

    public int indexOf(String str) {
        return this.str().indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.str().indexOf(str, fromIndex);
    }

    public int indexOf(XMLString str) {
        return this.str().indexOf(str.toString());
    }

    private static boolean isSpace(char ch) {
        return XMLCharacterRecognizer.isWhiteSpace(ch);
    }

    public int lastIndexOf(int ch) {
        return this.str().lastIndexOf(ch);
    }

    public int lastIndexOf(int ch, int fromIndex) {
        return this.str().lastIndexOf(ch, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.str().lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.str().lastIndexOf(str, fromIndex);
    }

    public int length() {
        return this.str().length();
    }

    public double num() {
        return this.toDouble();
    }

    public int rtf(XPathContext support) {
        DTM frag = support.createDocumentFragment();
        frag.appendTextChild(this.str());
        return frag.getDocument();
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int toffset) {
        return this.str().startsWith(prefix, toffset);
    }

    public boolean startsWith(XMLString prefix) {
        return this.startsWith(prefix, 0);
    }

    /*
     * Unable to fully structure code
     */
    public boolean startsWith(XMLString prefix, int toffset) {
        to = toffset;
        tlim = this.length();
        po = 0;
        pc = prefix.length();
        if (toffset >= 0 && toffset <= tlim - pc) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.charAt(to) != prefix.charAt(po)) {
                return false;
            }
            ++to;
            ++po;
lbl11:
            // 2 sources

            ** while (--pc >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public String str() {
        return this.m_obj != null ? (String)this.m_obj : "";
    }

    public XMLString substring(int beginIndex) {
        return new XString(this.str().substring(beginIndex));
    }

    public XMLString substring(int beginIndex, int endIndex) {
        return new XString(this.str().substring(beginIndex, endIndex));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double toDouble() {
        int end = this.length();
        if (end == 0) {
            return Double.NaN;
        }
        double result = 0.0;
        int start = 0;
        int punctPos = end - 1;
        int i = start;
        while (i < end) {
            char c = this.charAt(i);
            if (!XMLCharacterRecognizer.isWhiteSpace(c)) break;
            ++start;
            ++i;
        }
        double sign = 1.0;
        if (start < end && this.charAt(start) == '-') {
            sign = -1.0;
            ++start;
        }
        int digitsFound = 0;
        int i2 = start;
        while (i2 < end) {
            char c = this.charAt(i2);
            if (c != '.') {
                if (XMLCharacterRecognizer.isWhiteSpace(c)) break;
                if (!Character.isDigit(c)) return Double.NaN;
                result = result * 10.0 + (double)(c - 48);
                ++digitsFound;
            } else {
                punctPos = i2;
                break;
            }
            ++i2;
        }
        if (this.charAt(punctPos) == '.') {
            double fractPart = 0.0;
            int i3 = end - 1;
            while (i3 > punctPos) {
                char c = this.charAt(i3);
                if (XMLCharacterRecognizer.isWhiteSpace(c)) break;
                if (!Character.isDigit(c)) return Double.NaN;
                fractPart = fractPart / 10.0 + (double)(c - 48);
                ++digitsFound;
                --i3;
            }
            result += fractPart / 10.0;
        }
        if (digitsFound != 0) return result * sign;
        return Double.NaN;
    }

    public XMLString toLowerCase() {
        return new XString(this.str().toLowerCase());
    }

    public XMLString toLowerCase(Locale locale) {
        return new XString(this.str().toLowerCase(locale));
    }

    public XMLString toUpperCase() {
        return new XString(this.str().toUpperCase());
    }

    public XMLString toUpperCase(Locale locale) {
        return new XString(this.str().toUpperCase(locale));
    }

    public XMLString trim() {
        return new XString(this.str().trim());
    }

    public XMLString xstr() {
        return this;
    }
}

