/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import org.apache.xml.dtm.DTMAxisIterator;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;

public class ReverseAxesWalker
extends AxesWalker {
    protected DTMAxisIterator m_iterator;

    ReverseAxesWalker(LocPathIterator locPathIterator, int axis) {
        super(locPathIterator, axis);
    }

    protected void countProximityPosition(int i) {
        if (i < this.m_proximityPositions.length) {
            int n = i;
            this.m_proximityPositions[n] = this.m_proximityPositions[n] - 1;
        }
    }

    public int getLastPos(XPathContext xctxt) {
        int count = 0;
        AxesWalker savedWalker = this.wi().getLastUsedWalker();
        try {
            try {
                int next;
                ReverseAxesWalker clone = (ReverseAxesWalker)this.clone();
                clone.setRoot(this.getRoot());
                clone.setPredicateCount(this.getPredicateCount() - 1);
                clone.setPrevWalker(null);
                clone.setNextWalker(null);
                this.wi().setLastUsedWalker(clone);
                while ((next = clone.nextNode()) != -1) {
                    ++count;
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
            }
            Object var5_6 = null;
            this.wi().setLastUsedWalker(savedWalker);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.wi().setLastUsedWalker(savedWalker);
            throw throwable;
        }
        return count;
    }

    protected int getNextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int next = this.m_iterator.next();
        if (this.m_isFresh) {
            this.m_isFresh = false;
        }
        if (next == -1) {
            this.m_foundLast = true;
        }
        return next;
    }

    protected int getProximityPosition(int predicateIndex) {
        if (predicateIndex < 0) {
            return -1;
        }
        if (this.m_proximityPositions[predicateIndex] <= 0) {
            AxesWalker savedWalker = this.wi().getLastUsedWalker();
            try {
                try {
                    int next;
                    ReverseAxesWalker clone = (ReverseAxesWalker)this.clone();
                    clone.setRoot(this.getRoot());
                    clone.setPredicateCount(predicateIndex);
                    clone.setPrevWalker(null);
                    clone.setNextWalker(null);
                    this.wi().setLastUsedWalker(clone);
                    int count = 1;
                    while ((next = clone.nextNode()) != -1) {
                        ++count;
                    }
                    int n = predicateIndex;
                    this.m_proximityPositions[n] = this.m_proximityPositions[n] + count;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                }
                Object var4_6 = null;
                this.wi().setLastUsedWalker(savedWalker);
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                this.wi().setLastUsedWalker(savedWalker);
                throw throwable;
            }
        }
        return this.m_proximityPositions[predicateIndex];
    }

    public boolean isDocOrdered() {
        return false;
    }

    public boolean isReverseAxes() {
        return true;
    }

    public void setRoot(int root) {
        super.setRoot(root);
        this.m_iterator = this.getDTM(root).getAxisIterator(this.m_axis);
        this.m_iterator.setStartNode(root);
    }
}

