/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class XPathException
extends TransformerException {
    Object m_styleNode = null;
    protected Exception m_exception;

    public XPathException(String message) {
        super(message);
    }

    public XPathException(String message, Exception e) {
        super(message);
        this.m_exception = e;
    }

    public XPathException(String message, Object styleNode) {
        super(message);
        this.m_styleNode = styleNode;
    }

    public XPathException(String message, Node styleNode, Exception e) {
        super(message);
        this.m_styleNode = styleNode;
        this.m_exception = e;
    }

    public Throwable getException() {
        return this.m_exception;
    }

    public String getMessage() {
        String lastMessage = super.getMessage();
        Throwable exception = this.m_exception;
        while (exception != null) {
            String nextMessage = exception.getMessage();
            if (nextMessage != null) {
                lastMessage = nextMessage;
            }
            if (exception instanceof TransformerException) {
                Exception prev = exception;
                TransformerException se = (TransformerException)exception;
                if (prev != (exception = se.getException())) continue;
                break;
            }
            exception = null;
        }
        return lastMessage != null ? lastMessage : "";
    }

    public Object getStylesheetNode() {
        return this.m_styleNode;
    }

    public void printStackTrace(PrintStream s) {
        if (s == null) {
            s = System.err;
        }
        try {
            super.printStackTrace(s);
        }
        catch (Exception exception) {}
        Throwable exception = this.m_exception;
        int i = 0;
        while (i < 10 && exception != null) {
            s.println("---------");
            exception.printStackTrace(s);
            if (exception instanceof TransformerException) {
                Exception prev = exception;
                TransformerException se = (TransformerException)exception;
                if (prev == (exception = se.getException())) {
                    break;
                }
            } else {
                exception = null;
            }
            ++i;
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err);
        }
        try {
            super.printStackTrace(s);
        }
        catch (Exception exception) {}
        Throwable exception = this.m_exception;
        int i = 0;
        while (i < 10 && exception != null) {
            s.println("---------");
            try {
                exception.printStackTrace(s);
            }
            catch (Exception exception2) {
                s.println("Could not print stack trace...");
            }
            if (exception instanceof TransformerException) {
                Exception prev = exception;
                TransformerException se = (TransformerException)exception;
                if (prev == (exception = se.getException())) {
                    exception = null;
                    break;
                }
            } else {
                exception = null;
            }
            ++i;
        }
    }
}

