/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.ResultTreeHandler;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.XMLString;
import org.xml.sax.SAXException;

public class ClonerToResultTree {
    private ResultTreeHandler m_rth;
    private TransformerImpl m_transformer;

    public ClonerToResultTree(TransformerImpl transformer, ResultTreeHandler rth) {
        this.m_rth = rth;
        this.m_transformer = transformer;
    }

    public static void cloneToResultTree(int node, int nodeType, DTM dtm, ResultTreeHandler rth, boolean shouldCloneAttributes) throws TransformerException {
        try {
            switch (nodeType) {
                case 3: {
                    dtm.dispatchCharactersEvents(node, rth, false);
                    break;
                }
                case 1: {
                    String ns;
                    if (shouldCloneAttributes) {
                        rth.addAttributes(node);
                        rth.processNSDecls(node, nodeType, dtm);
                    }
                    if ((ns = dtm.getNamespaceURI(node)) == null) {
                        ns = "";
                    }
                    String localName = dtm.getLocalName(node);
                    rth.startElement(ns, localName, dtm.getNodeNameX(node), null);
                    break;
                }
                case 4: {
                    rth.startCDATA();
                    dtm.dispatchCharactersEvents(node, rth, false);
                    rth.endCDATA();
                    break;
                }
                case 2: {
                    rth.addAttribute(node);
                    break;
                }
                case 13: {
                    rth.processNSDecls(node, 13, dtm);
                    break;
                }
                case 8: {
                    XMLString xstr = dtm.getStringValue(node);
                    xstr.dispatchAsComment(rth);
                    break;
                }
                case 5: {
                    rth.entityReference(dtm.getNodeNameX(node));
                    break;
                }
                case 7: {
                    rth.processingInstruction(dtm.getNodeNameX(node), dtm.getNodeValue(node));
                    break;
                }
                default: {
                    throw new TransformerException("Can't clone node: " + dtm.getNodeName(node));
                }
                case 9: 
                case 11: {
                    return;
                }
            }
        }
        catch (SAXException se) {
            throw new TransformerException(se);
        }
    }
}

