/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import javax.xml.transform.TransformerException;
import org.apache.xalan.extensions.ExtensionHandler;
import org.apache.xalan.extensions.ExtensionsTable;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemExtensionDecl;
import org.apache.xalan.templates.ElemExtensionScript;
import org.apache.xalan.templates.ElemFallback;
import org.apache.xalan.templates.ElemLiteralResult;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemTextLiteral;
import org.apache.xalan.templates.StylesheetComposed;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElemExtensionCall
extends ElemLiteralResult {
    String m_extns;
    String m_lang;
    String m_srcURL;
    String m_scriptSrc;
    ElemExtensionDecl m_decl = null;

    public void compose(StylesheetRoot sroot) throws TransformerException {
        super.compose(sroot);
        this.m_extns = this.getNamespace();
        StylesheetRoot stylesheet = this.getStylesheetRoot();
        this.m_decl = this.getElemExtensionDecl(stylesheet, this.m_extns);
        if (this.m_decl != null) {
            ElemTemplateElement child = this.m_decl.getFirstChildElem();
            while (child != null) {
                if (child.getXSLToken() == 86) {
                    ElemExtensionScript sdecl = (ElemExtensionScript)child;
                    this.m_lang = sdecl.getLang();
                    this.m_srcURL = sdecl.getSrc();
                    ElemTemplateElement childOfSDecl = sdecl.getFirstChildElem();
                    if (childOfSDecl == null || childOfSDecl.getXSLToken() != 78) break;
                    ElemTextLiteral tl = (ElemTextLiteral)childOfSDecl;
                    char[] chars = tl.getChars();
                    this.m_scriptSrc = new String(chars);
                    break;
                }
                child = child.getNextSiblingElem();
            }
        }
    }

    public void execute(TransformerImpl transformer) throws TransformerException {
        try {
            transformer.getResultTreeHandler().flushPending();
            XPathContext liaison = transformer.getXPathContext();
            ExtensionsTable etable = liaison.getExtensionsTable();
            ExtensionHandler nsh = etable.get(this.m_extns);
            if (nsh == null) {
                nsh = etable.makeJavaNamespace(this.m_extns);
                if (nsh != null) {
                    etable.addExtensionNamespace(this.m_extns, nsh);
                } else {
                    this.executeFallbacks(transformer);
                    return;
                }
            }
            try {
                nsh.processElement(this.getLocalName(), this, transformer, this.getStylesheet(), this);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                TransformerException te = e instanceof TransformerException ? (TransformerException)e : (msg != null ? new TransformerException(e) : new TransformerException(XSLMessages.createMessage(137, null), e));
                if (te.getLocator() == null) {
                    te.setLocator(this);
                }
                if (msg != null) {
                    if (msg.indexOf("fatal") >= 0) {
                        transformer.getErrorListener().fatalError(te);
                    } else if (e instanceof RuntimeException) {
                        transformer.getErrorListener().error(te);
                    } else {
                        transformer.getErrorListener().warning(te);
                    }
                } else {
                    transformer.getErrorListener().error(te);
                }
                this.executeFallbacks(transformer);
            }
        }
        catch (SAXException se) {
            transformer.getErrorListener().fatalError(new TransformerException(se));
        }
    }

    public void executeFallbacks(TransformerImpl transformer) throws TransformerException {
        ElemTemplateElement child = this.m_firstChild;
        while (child != null) {
            if (child.getXSLToken() == 57) {
                try {
                    transformer.pushElemTemplateElement(child);
                    ((ElemFallback)child).executeFallback(transformer);
                }
                finally {
                    Object var4_3 = null;
                    transformer.popElemTemplateElement();
                }
            }
            child = child.m_nextSibling;
        }
    }

    public String getAttribute(String rawName) {
        AVT avt = this.getLiteralResultAttribute(rawName);
        if (avt != null && avt.getRawName().equals(rawName)) {
            return avt.getSimpleString();
        }
        return null;
    }

    public String getAttribute(String rawName, Node sourceNode, TransformerImpl transformer) throws TransformerException {
        AVT avt = this.getLiteralResultAttribute(rawName);
        if (avt != null && avt.getRawName().equals(rawName)) {
            XPathContext xctxt = transformer.getXPathContext();
            return avt.evaluate(xctxt, xctxt.getDTMHandleFromNode(sourceNode), this);
        }
        return null;
    }

    private ElemExtensionDecl getElemExtensionDecl(StylesheetRoot stylesheet, String namespace) {
        ElemExtensionDecl decl = null;
        int n = stylesheet.getGlobalImportCount();
        int i = 0;
        while (i < n) {
            StylesheetComposed imported = stylesheet.getGlobalImport(i);
            ElemTemplateElement child = imported.getFirstChildElem();
            while (child != null) {
                String prefix;
                String declNamespace;
                if (child.getXSLToken() == 85 && namespace.equals(declNamespace = child.getNamespaceForPrefix(prefix = (decl = (ElemExtensionDecl)child).getPrefix()))) {
                    return decl;
                }
                child = child.getNextSiblingElem();
            }
            ++i;
        }
        return decl;
    }

    public int getXSLToken() {
        return 79;
    }
}

