/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlBuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.DBInfoSpecific;
import javak.bo.sqlBuilder.ViewBottomArea;
import javak.bo.sqlBuilder.sqlBuilderController;
import javak.bo.sqlBuilder.sqlBuilderModel;
import javak.bo.sqlBuilder.toolbarBuild;
import javak.bo.sqlBuilder.toolbarChoose;
import javak.bo.sqlBuilder.toolbarClear;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BOError;
import javak.iface.bo.I_BOSetText;
import javak.iface.bo.I_SQLRenderer;
import javak.iface.bo.I_StateChange;
import javak.iface.bo.I_TableData;
import javak.iface.bo.I_visualSQLBuilder;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class BOSqlBuilderMain
extends JPanel
implements I_visualSQLBuilder,
I_StateChange {
    private boolean isRegistered = false;
    private final int maxNoRegTables = 3;
    private JComboBox dbSpecificChoice = null;
    private JComboBox tableChoices = null;
    private JComboBox queryChoices = null;
    private JButton buttonAddTable = null;
    private JButton buttonClearView = null;
    private JButton buttonBuildStatement = null;
    private JToolBar defaultToolbar = null;
    private JPanel selectionPanel = null;
    private JSplitPane splitPane = null;
    private sqlBuilderController m_controller;
    private boolean holdListener = false;
    private String currentSetDBClass = "javak.bo.sqlBuilder.DBInfoCommon";

    public BOSqlBuilderMain(I_BOSetText i_BOSetText, I_BOError i_BOError, Hashtable hashtable, DBInfoSpecific[] dBInfoSpecificArray) throws BOjavakException {
        BOAssert.assert(i_BOSetText != null, "Callback is invalid (null)");
        BOAssert.assert(hashtable != null, "Tablenames are invalid (null)");
        sqlBuilderModel sqlBuilderModel2 = new sqlBuilderModel(hashtable);
        this.m_controller = new sqlBuilderController(sqlBuilderModel2, dBInfoSpecificArray);
        this.m_controller.addStateChangeListener(this);
        this.m_controller.addStatementListener(i_BOSetText);
        this.m_controller.addStatementListener(new I_BOSetText(){

            public void boSetText(I_SQLRenderer i_SQLRenderer) throws BOjavakException {
                this.boSetText(i_SQLRenderer.getStatementFormatted());
            }

            public void boSetText(String string) throws BOjavakException {
                ViewBottomArea viewBottomArea = BOSqlBuilderMain.this.m_controller.getBottomArea();
                viewBottomArea.activateStatementPane();
                viewBottomArea.getStatementArea().setText(string);
            }

            public void boSetText(I_TableData i_TableData) throws BOjavakException {
                BOSqlBuilderMain.this.m_controller.getBottomArea().activateStatementPane();
            }
        });
        this.m_controller.addErrorListener(i_BOError);
        this.m_controller.addErrorListener(new I_BOError(){

            public void setErrorMessage(String string) {
                ViewBottomArea viewBottomArea = BOSqlBuilderMain.this.m_controller.getBottomArea();
                viewBottomArea.activateStatementPane();
                viewBottomArea.getStatementArea().setText(string);
            }
        });
        JTextArea jTextArea = this.m_controller.getBottomArea().getStatementArea();
        jTextArea.setFont(new Font("monospaced", 0, 12));
        jTextArea.setEditable(false);
        this.isRegistered = false;
        this.splitPane = new JSplitPane(0);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.createView();
        this.createDefaultToolbar(dBInfoSpecificArray);
        this.tableChoices.setModel(new DefaultComboBoxModel(sqlBuilderModel2.getTableNames()));
    }

    public void setDBSpecific(String string) throws BOjavakException {
        this.m_controller.getStringManipulater().setDBSpecficInfo(string);
    }

    private void createView() throws BOjavakException {
        this.splitPane.setBottomComponent(this.m_controller.getBottomArea());
        this.revalidate();
        this.splitPane.setTopComponent(this.m_controller.getBuilderManager());
    }

    public void clearView() {
        try {
            this.createView();
            this.m_controller.resetView();
            this.revalidate();
            this.initView();
        }
        catch (BOjavakException bOjavakException) {
            this.m_controller.setErrorMsg(bOjavakException.toString());
        }
    }

    public I_SQLRenderer buildQuery() {
        return this.m_controller.getSQLStatement();
    }

    public Object addSelectedTable() {
        if (!this.isRegistered && this.m_controller.getBuilderManager().getNrOfShownTables() >= 3) {
            JOptionPane.showMessageDialog(this, "Reached shareware limit of 3!!!", "Shareware information", 1);
            return null;
        }
        Object object = null;
        try {
            object = this.m_controller.addTable(this.getSelectedTableName());
        }
        catch (BOjavakException bOjavakException) {
            this.m_controller.setErrorMsg(bOjavakException.toString());
        }
        return object;
    }

    public String getSelectedTableName() {
        return (String)this.tableChoices.getSelectedItem();
    }

    private void createDefaultToolbar(DBInfoSpecific[] dBInfoSpecificArray) {
        JButton jButton = new JButton("Add Table");
        Vector<String> vector = new Vector<String>(dBInfoSpecificArray.length);
        int n = 0;
        while (n < dBInfoSpecificArray.length) {
            vector.addElement(dBInfoSpecificArray[n].getDBDisplayName());
            ++n;
        }
        this.dbSpecificChoice = new JComboBox(vector);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                try {
                    BOSqlBuilderMain.this.setDBSpecific((String)BOSqlBuilderMain.this.dbSpecificChoice.getSelectedItem());
                }
                catch (BOjavakException bOjavakException) {
                    BOSqlBuilderMain.this.m_controller.setErrorMsg(bOjavakException.toString());
                }
            }
        };
        this.dbSpecificChoice.addItemListener(itemListener);
        this.tableChoices = new JComboBox();
        this.queryChoices = new JComboBox(this.m_controller.getStatements());
        itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                BOSqlBuilderMain.this.m_controller.setStatementType(BOSqlBuilderMain.this.getQueryType());
                if (!BOSqlBuilderMain.this.holdListener) {
                    BOSqlBuilderMain.this.getAdditionalUserInfo();
                }
            }
        };
        this.queryChoices.addItemListener(itemListener);
        this.defaultToolbar = new JToolBar();
        this.buttonBuildStatement = new toolbarBuild(this);
        this.buttonClearView = new toolbarClear(this);
        this.buttonAddTable = new toolbarChoose(this);
        this.defaultToolbar.add(this.dbSpecificChoice);
        this.defaultToolbar.addSeparator();
        this.defaultToolbar.add(this.getSelectionPanel());
        this.defaultToolbar.add(this.buttonAddTable);
        this.defaultToolbar.addSeparator();
        this.defaultToolbar.add(this.buttonClearView);
        this.defaultToolbar.add(this.buttonBuildStatement);
        this.add((Component)this.defaultToolbar, "North");
    }

    public String getQueryType() {
        return (String)this.queryChoices.getSelectedItem();
    }

    public boolean isSelectGrouped() {
        return this.getQueryType().equals("Select (grouped by...)");
    }

    private void getAdditionalUserInfo() {
        if (!this.getQueryType().equals("Insert by select")) {
            return;
        }
        Frame frame = (Frame)this.getTopLevelAncestor();
        final JDialog jDialog = new JDialog(frame, "Insert into which table?", true);
        Point point = frame.getLocation();
        ((Component)jDialog).setLocation(point.x + 150, point.y + 150);
        Vector vector = this.m_controller.getModel().getTableNames();
        final JComboBox jComboBox = new JComboBox(vector);
        JPanel jPanel = new JPanel();
        jPanel.add(jComboBox);
        JButton jButton = new JButton("OK");
        JButton jButton2 = new JButton("Cancel");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = (String)jComboBox.getSelectedItem();
                    BOSqlBuilderMain.this.m_controller.setInsertTable(string);
                }
                catch (BOjavakException bOjavakException) {
                    BOSqlBuilderMain.this.m_controller.setErrorMsg(bOjavakException.toString());
                }
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        jDialog.pack();
        jDialog.show();
    }

    public JPanel getPanel() {
        return this;
    }

    public void setToolbarIcon_AddTable(Icon icon) {
        this.buttonAddTable.setIcon(icon);
        this.buttonAddTable.setText("");
    }

    public void setToolbarIcon_ClearView(Icon icon) {
        this.buttonClearView.setIcon(icon);
        this.buttonClearView.setText("");
    }

    public void setToolbarIcon_BuildStatement(Icon icon) {
        this.buttonBuildStatement.setIcon(icon);
        this.buttonBuildStatement.setText("");
    }

    public void initView() {
        this.splitPane.setDividerLocation(0.7);
    }

    public void setCurrentStatementType(String string) {
        this.m_controller.setStatementType(string);
        this.queryChoices.setSelectedItem(this.m_controller.getStatementType());
    }

    public String getCurrentStatementType() {
        return (String)this.queryChoices.getSelectedItem();
    }

    public void setRegistered(boolean bl) {
        this.isRegistered = bl;
    }

    public boolean getRegistered() {
        return this.isRegistered;
    }

    public JPanel getSelectionPanel() {
        if (this.selectionPanel != null) {
            return this.selectionPanel;
        }
        this.selectionPanel = new JPanel();
        this.selectionPanel.setLayout(new FlowLayout());
        this.selectionPanel.add(new JLabel("DB"));
        this.selectionPanel.add(this.dbSpecificChoice);
        this.selectionPanel.add(new JLabel("Querytype: "));
        this.selectionPanel.add(this.queryChoices);
        this.selectionPanel.add(new JLabel("Tables: "));
        this.selectionPanel.add(this.tableChoices);
        return this.selectionPanel;
    }

    public void showSQLStatement(String string) throws BOjavakException {
        this.holdListener = true;
        this.m_controller.setSQLStatement(string);
        this.holdListener = false;
    }
}

