/*
 * Decompiled with CFR 0.152.
 */
package javak.bo;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javak.bo.ModelAttribute;
import javak.iface.bo.I_TableData;

public class ModelTable
implements I_TableData,
Serializable {
    private static final String STATE_UNKNOWN = "unknown";
    String catalogname = "unknown";
    String schemename = "unknown";
    String name = null;
    String owner = "unknown";
    String tableType = "unknown";
    Hashtable attributes = new Hashtable();

    public ModelTable(String string) {
        this.name = string;
    }

    public ModelAttribute addAttribute(String string) {
        ModelAttribute modelAttribute = new ModelAttribute(this, string);
        this.attributes.put(modelAttribute.getName(), modelAttribute);
        return modelAttribute;
    }

    public Vector getAttributes() {
        Vector vector = new Vector(this.attributes.size());
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((ModelAttribute)object).getName().compareTo(((ModelAttribute)object2).getName());
            }
        };
        Collections.sort(vector, comparator);
        return vector;
    }

    public Vector getAttributeNames() {
        Vector<String> vector = new Vector<String>(this.attributes.size());
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((ModelAttribute)enumeration.nextElement()).getName());
        }
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((String)object).compareTo((String)object2);
            }
        };
        Collections.sort(vector, comparator);
        return vector;
    }

    public ModelAttribute getAttribute(String string) {
        int n = string.indexOf(" ");
        if (n == -1) {
            return (ModelAttribute)this.attributes.get(string);
        }
        return (ModelAttribute)this.attributes.get(string.substring(0, n));
    }

    public ModelAttribute getAttributeNoCase(String string) {
        int n = string.indexOf(" ");
        if (n != -1) {
            string = string.substring(0, n);
        }
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (ModelAttribute)this.attributes.get(string2);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getType() {
        return this.tableType;
    }

    public String getScheme() {
        return this.schemename;
    }

    public String getCatalog() {
        return this.catalogname;
    }

    public void setOwner(String string) {
        if (string != null) {
            this.owner = string;
        }
    }

    public void setType(String string) {
        if (string != null) {
            this.tableType = string;
        }
    }

    public void setScheme(String string) {
        if (string != null) {
            this.schemename = string;
        }
    }

    public void setCatalog(String string) {
        if (string != null) {
            this.catalogname = string;
        }
    }

    public Object[][] getTableFormatValues() {
        Vector<String[]> vector = new Vector<String[]>(5, 5);
        if (!this.name.equals(STATE_UNKNOWN)) {
            vector.addElement(new String[]{"Name", this.name});
        }
        if (!this.owner.equals(STATE_UNKNOWN)) {
            vector.addElement(new String[]{"Owner", this.owner});
        }
        if (!this.tableType.equals(STATE_UNKNOWN)) {
            vector.addElement(new String[]{"Tabletype", this.tableType});
        }
        if (!this.catalogname.equals(STATE_UNKNOWN)) {
            vector.addElement(new String[]{"Belongs to catalog", this.catalogname});
        }
        if (!this.schemename.equals(STATE_UNKNOWN)) {
            vector.addElement(new String[]{"Belongs to scheme", this.schemename});
        }
        Object[][] objectArray = new String[vector.size()][2];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n] = (String[])enumeration.nextElement();
            ++n;
        }
        return objectArray;
    }

    public Object[] getTableFormatColumns() {
        Object[] objectArray = new String[]{"Attribute", "Value"};
        return objectArray;
    }

    public String toString() {
        String string = "Table:\n------\n";
        String[][] stringArray = (String[][])this.getTableFormatValues();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = 0;
            while (n2 < stringArray[n].length) {
                string = string + stringArray[n][n2] + (n2 + 1 == stringArray[n].length ? "\n" : " - ");
                ++n2;
            }
            ++n;
        }
        string = string + "\n";
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            string = string + ((ModelAttribute)enumeration.nextElement()).toString() + "\n";
        }
        return string;
    }
}

