//
//  XTTabStopHelper.h
//  XTads
//
//  Created by Rune Berg on 18/07/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTTextTab.h"
#import "XTTextTableBlock.h"
#import "XTTextView.h"
#import "XTTabStopModelEntry.h"
#import "XTHtmlTagTab.h"


//NS_ASSUME_NONNULL_BEGIN

@interface XTTabStopHelper : NSObject

@property (unsafe_unretained) XTTextView *textView;

- (NSArray *)getDefaultTabStops;

- (XTTextTab *)createTabStopAtRhsOfViewForOptTextTableBlock:(XTTextTableBlock *)textTableBlock;

- (XTTextTab *)createTabStopForHorizRulerForTagTab:(XTHtmlTagTab *)tagTab optTextTableBlock:(XTTextTableBlock *)textTableBlock;

- (XTTextTab *)createTabStopAtHalfwayToRhsOfViewFromLoc:(CGFloat)fromLoc textTableBlock:(XTTextTableBlock *)textTableBlock;

- (XTTextTab *)createTabFromModelEntry:(XTTabStopModelEntry *)modelEntry
						   minLocation:(CGFloat)minLocation
							  resizing:(BOOL)resizing
					 optTextTableBlock:(XTTextTableBlock *)textTableBlock;

- (NSArray *)createTabStopsForListItemFromFirstLineHeadIndent:(CGFloat)firstLineHeadIndent
													tab1Width:(CGFloat)tab1Width
													tab2Width:(CGFloat)tab2Width;

- (XTTextTab *)createTabStopFor:(NSAttributedString *)attrString
			   atNextMultipleOf:(NSNumber *)multiple
				   fromLocation:(CGFloat)location;

- (void)resetTabStopModel;

- (XTTabStopModelEntry *)findModelTabWithId:(NSString *)tabId;

- (XTTabStopAlignment)alignmentFromString:(NSString *)s;

- (XTTabStopAlignment)alignmentFromStringLeftCenterRightOnly:(NSString *)s;

- (void)preregisterModelTabWithId:(NSString *)ident;

- (void)addModelTabStopWithId:(NSString *)ident
					 position:(CGFloat)position
					alignment:(NSString *)alignment
				  decimalChar:(NSString *)decimalChar;

- (XTTabStopModelEntry *)createOverridenModelTabStop:(XTTabStopModelEntry *)tabStopModelEntry
											   align:(NSString *)alignment
										 decimalChar:(NSString *)decimalChar;

- (CGFloat)getPlainTextModeTabStopColumnWidthInPoints:(NSFont *)font;

- (NSString *)stringForTabIndent:(NSUInteger)indent foldLeadingSpace:(BOOL)foldLeadingSpace;

- (NSString *)stringForTabStopLeftAligned;

- (BOOL)paragraphStyleHasTabStopAtRhsOfWindow:(NSParagraphStyle *)pgStyle;

- (void)prepareForRecalcAllOfTabStops;

- (void)prepareForRecalcAllOfTabStopsInRange:(NSRange)range;

- (void)recalcAllTabStops;

- (BOOL)textStorageEndsWithARegularSpace;

@end

//NS_ASSUME_NONNULL_END
