//
//  XTHtmlTagAddress.m
//  XTads
//
//  Created by Rune Berg on 13/01/2021.
//  Copyright © 2021 Rune Berg. All rights reserved.
//

#import "XTHtmlTagContainer_private.h"
#import "XTHtmlTagAddress.h"


@implementation XTHtmlTagAddress

+ (NSString *)name
{
	return @"address";
}

- (BOOL)blockLevel
{
	BOOL res = [self isAllowed];
	return res;
}

- (XTFormattingSpecification *)makeFormattingSpecificationFrom:(XTFormattingSpecification *)formattingSpec
{
	XTFormattingSpecification *res = [XTFormattingSpecification specificationFrom:formattingSpec];
	if ([self isAllowed]) {
		res.address = YES;
	}
	return res;
}

- (BOOL)isAllowed
{
	BOOL res = (! [self isInList]);
	return res;
}

@end
