//
//  XTTabStopUtils.h
//  XTads
//
//  Created by Rune Berg on 31/10/2019.
//  Copyright © 2019 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTRecalcTabStopCommand.h"
#import "XTTextTab.h"

//NS_ASSUME_NONNULL_BEGIN


@interface XTTabStopUtils : NSObject

+ (NSArray<XTRecalcTabStopCommand *> *)limitTabStopsSensitiveToResizing:(NSTextStorage *)textStorage range:(NSRange)range;

+ (void)restoreTabStopSensitiveToResizing:(NSTextStorage *)textStorage atPos:(NSUInteger)pos;

+ (BOOL)tabStopIsAtRhsOfView:(XTTextTab *)textTab;

+ (BOOL)tabStopIsAtHalfwayToRhsOfView:(XTTextTab *)textTab;

+ (BOOL)tabStopIsToId:(XTTextTab *)textTab;

+ (BOOL)tabStopIsAtMultiple:(XTTextTab *)textTab;

+ (BOOL)tabStopIsAtFixedPos:(XTTextTab *)textTab;

@end


//NS_ASSUME_NONNULL_END
