//
//  XTUserOptions.h
//  TadsTerp
//
//  Created by Rune Berg on 17/09/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XTPrefsItem.h"
#import "XTPrefsItemBool.h"
#import "XTPrefsItemFloat.h"
#import "XTPrefsItemInteger.h"
#import "XTPrefsItemColor.h"
#import "XTPrefsItemLoglevelByName.h"

@interface XTPrefs : NSObject

#define XTPREFS_DIRECTORY_MODE_SPECIFIC @"specific"
#define XTPREFS_DIRECTORY_MODE_NONE @"none"
#define XTPREFS_DIRECTORY_MODE_LAST_SELECTED @"lastSelected"
#define XTPREFS_DIRECTORY_MODE_CURRENT_GAMEFILE @"sameAsCurrentGameFile"

#define XTPREFS_FILE_NAME_MODE_DATE_TIME @"gameFileTimestamp"
#define XTPREFS_FILE_NAME_MODE_UNTITLED @"untitled"
#define XTPREFS_FILE_NAME_MODE_GAME_FILE @"gameFile"

#define XTPREFS_IO_SAFETY_MODE_NO_ACCESS @"noAccess"
#define XTPREFS_IO_SAFETY_MODE_GAME_DIR_ONLY @"gameDirOnly"
#define XTPREFS_IO_SAFETY_MODE_ANYWHERE @"anywhere"

#define XTPREFS_GAME_WINDOW_START_MODE_SAME_AS_LAST @"sameAsLast"
#define XTPREFS_GAME_WINDOW_START_MODE_NICE_IN_MIDDLE @"niceInMiddle"
#define XTPREFS_GAME_WINDOW_START_MODE_WHATEVER @"whatever"

#define XTPREFS_SCROLLBACK_BUFFER_SIZE_50KB 50
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_100KB 100
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_200KB 200
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_500KB 500
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_1000KB 1000
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_2000KB 2000
#define XTPREFS_SCROLLBACK_BUFFER_SIZE_5000KB 5000

// Folders/files

@property XTPrefsItem<NSString *> *gamesDirectoryMode;
@property XTPrefsItem<NSURL *> *gamesDirectoryWhenSpecific;
@property XTPrefsItem<NSURL *> *gamesDirectoryLastUsed;

@property XTPrefsItem<NSString *> *savesDirectoryMode;
@property XTPrefsItem<NSURL *> *savesDirectoryWhenSpecific;
@property XTPrefsItem<NSURL *> *savesDirectoryLastUsed;
@property XTPrefsItem<NSString *> *savesFileNameMode;

@property XTPrefsItem<NSString *> *transcriptsDirectoryMode;
@property XTPrefsItem<NSURL *> *transcriptsDirectoryWhenSpecific;
@property XTPrefsItem<NSURL *> *transcriptsDirectoryLastUsed;
@property XTPrefsItem<NSString *> *transcriptsFileNameMode;

@property XTPrefsItem<NSString *> *commandScriptsDirectoryMode;
@property XTPrefsItem<NSURL *> *commandScriptsDirectoryWhenSpecific;
@property XTPrefsItem<NSURL *> *commandScriptsDirectoryLastUsed;
@property XTPrefsItem<NSString *> *commandScriptsFileNameMode;

// Fonts

@property XTPrefsItem<NSString *> *defaultFontName;
@property XTPrefsItemFloat *defaultFontSize;
@property NSString *defaultFontDescription; // derived, for UI only

@property XTPrefsItem<NSString *> *fixedWidthFontName;
@property XTPrefsItemFloat *fixedWidthFontSize;
@property NSString *fixedWidthFontDescription; // derived, for UI only

@property XTPrefsItem<NSString *> *serifedFontName;
@property XTPrefsItemFloat *serifedFontSize;
@property NSString *serifedFontDescription; // derived, for UI only

@property XTPrefsItem<NSString *> *sansSerifFontName;
@property XTPrefsItemFloat *sansSerifFontSize;
@property NSString *sansSerifFontDescription; // derived, for UI only

@property XTPrefsItem<NSString *> *scriptFontName;
@property XTPrefsItemFloat *scriptFontSize;
@property NSString *scriptFontDescription; // derived, for UI only

@property XTPrefsItem<NSString *> *typewriterFontName;
@property XTPrefsItemFloat *typewriterFontSize;
@property NSString *typewriterFontDescription; // derived, for UI only

@property XTPrefsItemBool *inputFontIsSameAsDefaultFont;
@property XTPrefsItem<NSString *> *inputFontName;
@property XTPrefsItemFloat *inputFontSize;
@property XTPrefsItemBool *inputFontUsedEvenIfNotRequestedByGame;
@property NSString *inputFontDescription; // derived, for UI only

@property XTPrefsItemBool *allowGamesToSetFonts;
@property XTPrefsItemInteger *minAllowedFontSize;
@property XTPrefsItemInteger *maxAllowedFontSize;

// Colors

@property XTPrefsItemColor *statusLineTextColor;
@property XTPrefsItemColor *statusLineBackgroundColor;

@property XTPrefsItemColor *outputAreaTextColor;
@property XTPrefsItemColor *outputAreaBackgroundColor;

@property XTPrefsItemColor *inputTextColor;

@property XTPrefsItemColor *linksTextColor;
@property XTPrefsItemBool *linksUnderline;
@property XTPrefsItemBool *linksShowToolTips;

@property XTPrefsItemBool *allowGamesToSetFontColors;
@property XTPrefsItemBool *allowGamesToSetBackgroundColors;

// Layout
@property XTPrefsItem<NSString *> *gameWindowStartMode;

// I/O Safety
@property XTPrefsItem<NSString *> *readSafetyMode;
@property XTPrefsItem<NSString *> *writeSafetyMode;

// Misc.
@property XTPrefsItemBool *askForGameFileOnTerpStart;
@property XTPrefsItemBool *printTadsBannerOnGameStart;
@property XTPrefsItemBool *askForConfirmationOnGameRestart;
@property XTPrefsItemBool *askForConfirmationOnGameQuit;
@property XTPrefsItemBool *askForConfirmationOnGameOpenIfGameRunning;
@property XTPrefsItemBool *enableDevelopmentModeFeatures;
@property XTPrefsItemBool *limitScrollbackBufferSize; // whether to limit or not
@property XTPrefsItem<NSNumber *> *scrollbackBufferSizeInKBs; // the actual limit, in kilobytes
@property XTPrefsItem<NSNumber *> *tads2Encoding;
@property XTPrefsItemBool *tads2EncodingOverride;
@property XTPrefsItemBool *keepCommandHistoryWhenStartingNewGame;
@property XTPrefsItemBool *emulateHtmlBannerForTradStatusLine;

// Dev. Mode
@property XTPrefsItemBool *printBrokenHtmlMarkup;
@property XTPrefsItemBool *showParserMode;
@property XTPrefsItemBool *spellCheckGameText;
@property XTPrefsItemBool *grammarCheckGameText;
@property XTPrefsItemLoglevelByName *logLevelByName;

@property BOOL alwaysFalse;
@property NSNumber *minMinAllowedFontSize;
@property NSNumber *maxMaxAllowedFontSize;


// get singleton instance
+ (id) prefs;

- (void)cleanupUnused;

- (void)restoreFromPersisted;

- (void)persist;

- (void)resetDefaultFonts;
- (void)resetDefaultDirsAndFiles;
- (void)resetDefaultColors;
- (void)resetDefaultLayout;
- (void)resetDefaultIOSafetyModes;
- (void)resetDefaultMisc;
- (void)resetDefaultDevMode;

- (void)startObservingChangesToAll:(NSObject *)observer;

- (void)updateDefaultFontWithName:(NSString *)name size:(CGFloat)zize;
- (void)updateFixedWidthFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateSerifedFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateSansSerifFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateScriptFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateTypewriterFontWithName:(NSString *)name size:(CGFloat)size;
- (void)updateInputFontWithName:(NSString *)name size:(CGFloat)size;

- (NSArray *)logLevelsSortedOnClassName; // ...of XTLoggerAndLevel
- (void)updateLogLevels:(NSArray *)logLevels; // ...of XTLoggerAndLevel
- (void)updateLogLevelsFromDict:(NSDictionary *)logLevelsByName; // ...of name (NSString) -> level (NSNumber)

@end
