#ifdef RCSID
static char RCSid[] =
"$Header: d:/cvsroot/tads/html/pngext.c,v 1.2 1999/05/17 02:52:22 MJRoberts Exp $";
#endif

/* 
 *   Copyright (c) 1999 by Michael J. Roberts.  All Rights Reserved.
 *   
 *   Please see the accompanying license file, LICENSE.TXT, for information
 *   on using and copying this software.  
 */
/*
Name
  pngext.cpp - HTML TADS PNG library extensions
Function
  Defines functions that extend the PNG libraries.  These functions act
  as though they are part of the PNG libraries, in that they modify internal
  data structures.
Notes
  
Modified
  02/20/99 MJRoberts  - Creation
*/


#define PNG_INTERNAL
#include <png.h>
#include <pngconf.h>

/* ------------------------------------------------------------------------ */
/*
 *   Dither to rainbow cube.  Use the same way as png_set_dither.  We'll
 *   automatically generate a rainbox palette.  The rainbow palette will
 *   have 216 colors (6 levels each of R, G, and B).
 *   
 *   This has the same effect as png_set_dither when used with this same
 *   216-color rainbow cube; however, this version is dramatically faster,
 *   because it can perform a simple calculation to determine the mapping
 *   from an RGB coordinate to a palette index and can thus bypass the
 *   very slow closest-fit search that png_set_dither performs.  
 */
void png_set_rainbow_dither(png_structp png_ptr)
{
    static png_color rainbow[216] =
    {
        /* a uniform color cube */
        { 0x00, 0x00, 0x00 },
        { 0x00, 0x00, 0x33 },
        { 0x00, 0x00, 0x66 },
        { 0x00, 0x00, 0x99 },
        { 0x00, 0x00, 0xcc },
        { 0x00, 0x00, 0xff },
        { 0x00, 0x33, 0x00 },
        { 0x00, 0x33, 0x33 },
        { 0x00, 0x33, 0x66 },
        { 0x00, 0x33, 0x99 },
        { 0x00, 0x33, 0xcc },
        { 0x00, 0x33, 0xff },
        { 0x00, 0x66, 0x00 },
        { 0x00, 0x66, 0x33 },
        { 0x00, 0x66, 0x66 },
        { 0x00, 0x66, 0x99 },
        { 0x00, 0x66, 0xcc },
        { 0x00, 0x66, 0xff },
        { 0x00, 0x99, 0x00 },
        { 0x00, 0x99, 0x33 },
        { 0x00, 0x99, 0x66 },
        { 0x00, 0x99, 0x99 },
        { 0x00, 0x99, 0xcc },
        { 0x00, 0x99, 0xff },
        { 0x00, 0xcc, 0x00 },
        { 0x00, 0xcc, 0x33 },
        { 0x00, 0xcc, 0x66 },
        { 0x00, 0xcc, 0x99 },
        { 0x00, 0xcc, 0xcc },
        { 0x00, 0xcc, 0xff },
        { 0x00, 0xff, 0x00 },
        { 0x00, 0xff, 0x33 },
        { 0x00, 0xff, 0x66 },
        { 0x00, 0xff, 0x99 },
        { 0x00, 0xff, 0xcc },
        { 0x00, 0xff, 0xff },
        { 0x33, 0x00, 0x00 },
        { 0x33, 0x00, 0x33 },
        { 0x33, 0x00, 0x66 },
        { 0x33, 0x00, 0x99 },
        { 0x33, 0x00, 0xcc },
        { 0x33, 0x00, 0xff },
        { 0x33, 0x33, 0x00 },
        { 0x33, 0x33, 0x33 },
        { 0x33, 0x33, 0x66 },
        { 0x33, 0x33, 0x99 },
        { 0x33, 0x33, 0xcc },
        { 0x33, 0x33, 0xff },
        { 0x33, 0x66, 0x00 },
        { 0x33, 0x66, 0x33 },
        { 0x33, 0x66, 0x66 },
        { 0x33, 0x66, 0x99 },
        { 0x33, 0x66, 0xcc },
        { 0x33, 0x66, 0xff },
        { 0x33, 0x99, 0x00 },
        { 0x33, 0x99, 0x33 },
        { 0x33, 0x99, 0x66 },
        { 0x33, 0x99, 0x99 },
        { 0x33, 0x99, 0xcc },
        { 0x33, 0x99, 0xff },
        { 0x33, 0xcc, 0x00 },
        { 0x33, 0xcc, 0x33 },
        { 0x33, 0xcc, 0x66 },
        { 0x33, 0xcc, 0x99 },
        { 0x33, 0xcc, 0xcc },
        { 0x33, 0xcc, 0xff },
        { 0x33, 0xff, 0x00 },
        { 0x33, 0xff, 0x33 },
        { 0x33, 0xff, 0x66 },
        { 0x33, 0xff, 0x99 },
        { 0x33, 0xff, 0xcc },
        { 0x33, 0xff, 0xff },
        { 0x66, 0x00, 0x00 },
        { 0x66, 0x00, 0x33 },
        { 0x66, 0x00, 0x66 },
        { 0x66, 0x00, 0x99 },
        { 0x66, 0x00, 0xcc },
        { 0x66, 0x00, 0xff },
        { 0x66, 0x33, 0x00 },
        { 0x66, 0x33, 0x33 },
        { 0x66, 0x33, 0x66 },
        { 0x66, 0x33, 0x99 },
        { 0x66, 0x33, 0xcc },
        { 0x66, 0x33, 0xff },
        { 0x66, 0x66, 0x00 },
        { 0x66, 0x66, 0x33 },
        { 0x66, 0x66, 0x66 },
        { 0x66, 0x66, 0x99 },
        { 0x66, 0x66, 0xcc },
        { 0x66, 0x66, 0xff },
        { 0x66, 0x99, 0x00 },
        { 0x66, 0x99, 0x33 },
        { 0x66, 0x99, 0x66 },
        { 0x66, 0x99, 0x99 },
        { 0x66, 0x99, 0xcc },
        { 0x66, 0x99, 0xff },
        { 0x66, 0xcc, 0x00 },
        { 0x66, 0xcc, 0x33 },
        { 0x66, 0xcc, 0x66 },
        { 0x66, 0xcc, 0x99 },
        { 0x66, 0xcc, 0xcc },
        { 0x66, 0xcc, 0xff },
        { 0x66, 0xff, 0x00 },
        { 0x66, 0xff, 0x33 },
        { 0x66, 0xff, 0x66 },
        { 0x66, 0xff, 0x99 },
        { 0x66, 0xff, 0xcc },
        { 0x66, 0xff, 0xff },
        { 0x99, 0x00, 0x00 },
        { 0x99, 0x00, 0x33 },
        { 0x99, 0x00, 0x66 },
        { 0x99, 0x00, 0x99 },
        { 0x99, 0x00, 0xcc },
        { 0x99, 0x00, 0xff },
        { 0x99, 0x33, 0x00 },
        { 0x99, 0x33, 0x33 },
        { 0x99, 0x33, 0x66 },
        { 0x99, 0x33, 0x99 },
        { 0x99, 0x33, 0xcc },
        { 0x99, 0x33, 0xff },
        { 0x99, 0x66, 0x00 },
        { 0x99, 0x66, 0x33 },
        { 0x99, 0x66, 0x66 },
        { 0x99, 0x66, 0x99 },
        { 0x99, 0x66, 0xcc },
        { 0x99, 0x66, 0xff },
        { 0x99, 0x99, 0x00 },
        { 0x99, 0x99, 0x33 },
        { 0x99, 0x99, 0x66 },
        { 0x99, 0x99, 0x99 },
        { 0x99, 0x99, 0xcc },
        { 0x99, 0x99, 0xff },
        { 0x99, 0xcc, 0x00 },
        { 0x99, 0xcc, 0x33 },
        { 0x99, 0xcc, 0x66 },
        { 0x99, 0xcc, 0x99 },
        { 0x99, 0xcc, 0xcc },
        { 0x99, 0xcc, 0xff },
        { 0x99, 0xff, 0x00 },
        { 0x99, 0xff, 0x33 },
        { 0x99, 0xff, 0x66 },
        { 0x99, 0xff, 0x99 },
        { 0x99, 0xff, 0xcc },
        { 0x99, 0xff, 0xff },
        { 0xcc, 0x00, 0x00 },
        { 0xcc, 0x00, 0x33 },
        { 0xcc, 0x00, 0x66 },
        { 0xcc, 0x00, 0x99 },
        { 0xcc, 0x00, 0xcc },
        { 0xcc, 0x00, 0xff },
        { 0xcc, 0x33, 0x00 },
        { 0xcc, 0x33, 0x33 },
        { 0xcc, 0x33, 0x66 },
        { 0xcc, 0x33, 0x99 },
        { 0xcc, 0x33, 0xcc },
        { 0xcc, 0x33, 0xff },
        { 0xcc, 0x66, 0x00 },
        { 0xcc, 0x66, 0x33 },
        { 0xcc, 0x66, 0x66 },
        { 0xcc, 0x66, 0x99 },
        { 0xcc, 0x66, 0xcc },
        { 0xcc, 0x66, 0xff },
        { 0xcc, 0x99, 0x00 },
        { 0xcc, 0x99, 0x33 },
        { 0xcc, 0x99, 0x66 },
        { 0xcc, 0x99, 0x99 },
        { 0xcc, 0x99, 0xcc },
        { 0xcc, 0x99, 0xff },
        { 0xcc, 0xcc, 0x00 },
        { 0xcc, 0xcc, 0x33 },
        { 0xcc, 0xcc, 0x66 },
        { 0xcc, 0xcc, 0x99 },
        { 0xcc, 0xcc, 0xcc },
        { 0xcc, 0xcc, 0xff },
        { 0xcc, 0xff, 0x00 },
        { 0xcc, 0xff, 0x33 },
        { 0xcc, 0xff, 0x66 },
        { 0xcc, 0xff, 0x99 },
        { 0xcc, 0xff, 0xcc },
        { 0xcc, 0xff, 0xff },
        { 0xff, 0x00, 0x00 },
        { 0xff, 0x00, 0x33 },
        { 0xff, 0x00, 0x66 },
        { 0xff, 0x00, 0x99 },
        { 0xff, 0x00, 0xcc },
        { 0xff, 0x00, 0xff },
        { 0xff, 0x33, 0x00 },
        { 0xff, 0x33, 0x33 },
        { 0xff, 0x33, 0x66 },
        { 0xff, 0x33, 0x99 },
        { 0xff, 0x33, 0xcc },
        { 0xff, 0x33, 0xff },
        { 0xff, 0x66, 0x00 },
        { 0xff, 0x66, 0x33 },
        { 0xff, 0x66, 0x66 },
        { 0xff, 0x66, 0x99 },
        { 0xff, 0x66, 0xcc },
        { 0xff, 0x66, 0xff },
        { 0xff, 0x99, 0x00 },
        { 0xff, 0x99, 0x33 },
        { 0xff, 0x99, 0x66 },
        { 0xff, 0x99, 0x99 },
        { 0xff, 0x99, 0xcc },
        { 0xff, 0x99, 0xff },
        { 0xff, 0xcc, 0x00 },
        { 0xff, 0xcc, 0x33 },
        { 0xff, 0xcc, 0x66 },
        { 0xff, 0xcc, 0x99 },
        { 0xff, 0xcc, 0xcc },
        { 0xff, 0xcc, 0xff },
        { 0xff, 0xff, 0x00 },
        { 0xff, 0xff, 0x33 },
        { 0xff, 0xff, 0x66 },
        { 0xff, 0xff, 0x99 },
        { 0xff, 0xff, 0xcc },
        { 0xff, 0xff, 0xff },
    };
    int total_bits = PNG_DITHER_RED_BITS + PNG_DITHER_GREEN_BITS +
                     PNG_DITHER_BLUE_BITS;
    int num_red = (1 << PNG_DITHER_RED_BITS);
    int num_green = (1 << PNG_DITHER_GREEN_BITS);
    int num_blue = (1 << PNG_DITHER_BLUE_BITS);
    png_size_t num_entries = ((png_size_t)1 << total_bits);
    int ir, ig, ib;

    /* note that dithering is activated */
    png_ptr->transformations |= PNG_DITHER;

    /* use the rainbow palette */
    if (png_ptr->palette == NULL)
        png_ptr->palette = rainbow;

    /* store the palette size */
    png_ptr->num_palette = (png_uint_16)(sizeof(rainbow)/sizeof(rainbow[0]));

    /* 
     *   generate a reverse lookup map to go from an RGB value to a
     *   rainbow palette index 
     */
    png_ptr->palette_lookup = (png_bytep )png_malloc(png_ptr,
        (png_uint_32)(num_entries * sizeof (png_byte)));

    /* generate the mappings to the rainbow */
    for (ir = 0 ; ir < num_red ; ++ir)
    {
        for (ig = 0 ; ig < num_green ; ++ig)
        {
            for (ib = 0 ; ib < num_blue ; ++ib)
            {
                int rgb_idx;
                int pal_idx;

                /* calculate the RGB index of this value */
                rgb_idx =
                    (ir << (PNG_DITHER_BLUE_BITS + PNG_DITHER_GREEN_BITS))
                    | (ig << PNG_DITHER_BLUE_BITS)
                    | ib;

                /* 
                 *   Calculate the palette index of this value -- we have
                 *   6 levels for each color, and 256/6 is about 43, thus
                 *   we get the index in the palette by dividing the
                 *   actual intensity (in the range 0-255) by 43.  We then
                 *   calculate the index by computing the three-numeral
                 *   base-6 value (base 6 because we have 6 levels for
                 *   each color).
                 *   
                 *   Round up or down to the nearest value.  
                 */
                pal_idx =
                    ((((ir << (8 - PNG_DITHER_RED_BITS)) + 0)/43) * 36)
                    + ((((ig << (8 - PNG_DITHER_GREEN_BITS)) + 0)/43) * 6)
                    + ((((ib << (8 - PNG_DITHER_BLUE_BITS)) + 0)/43));

                /* store the reverse mapping */
                png_ptr->palette_lookup[rgb_idx] = (png_byte)pal_idx;
            }
        }
    }
}

