////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: eatDaemon() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _EAT_DAEMON_T_
#define _EAT_DAEMON_T_

#include <global.t>
#include <story.t>

#pragma C+

/*
 *   This function is a daemon, set running by init(), which monitors how
 *   long it has been since the player has had anything to eat.  It will
 *   provide warnings for some time prior to the player's expiring from
 *   hunger, and will kill the player if he should go too long without
 *   heeding these warnings.
 */
eatDaemon: function(parm) {
    local e, l;

    global.lastMealTime = global.lastMealTime + 1;
    e = global.eatTime;
    l = global.lastMealTime;

    if (l == e || l == e + 5 || l == e + 10)
        "\bYou're feeling a bit peckish. Perhaps it would be a good
        time to find something to eat. ";
    else if (l == e + 15 || l == e + 20 || l == e + 25)
        "\bYou're feeling really hungry. You should find some food
        soon or you'll pass out from lack of nutrition. ";
    else if (l == e + 30 || l == e + 35)
        "\bYou can't go much longer without food. ";
    else if (l >= e + 40) {
        "\bYou simply can't go on any longer without food. You perish from
        lack of nutrition. ";
        story.deathMessage(nil);
    }
}

#pragma C-

#endif /* _EAT_DAEMON_T_ */
