////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Room 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ROOM_H_
#define _ROOM_H_

#include <roomable.h>
#include <surface.h>

#pragma C+

/*
 *  Room: Roomable, Surface 
 *
 *  A location in the game.  By default, the lightsOn property is
 *  true, which means that the Room is lit (no Lightsource is
 *  needed while in the Room).  You should create a DarkRoom
 *  object, rather than a Room with lightsOn set to nil, if you
 *  want a dark room, because other methods are affected as well.
 *
 *  The isSeen property records whether the player has entered
 *  the Room before; initially it's nil, and is set to true
 *  the first time the player enters.  
 *
 *  The roomAction() method is activated for each player 
 *  command; by default, all it does is call the Room's 
 *  location's roomAction method if the Room is inside another 
 *  Room.  
 *
 *  The lookAround(verbosity) method displays the Room's 
 *  description for a given verbosity level; true means a full 
 *  description, nil means only the short description (just the 
 *  Room name plus a list of the objects present).  
 *
 *  roomDrop(object) is called when an object is dropped within 
 *  the Room; normally, it just moves the object to the Room and 
 *  displays "Dropped."  
 *  
 *  The firstSeen method is called when isSeen is about to be set 
 *  true for the first time (i.e., when the player first sees the 
 *  Room); by default, this routine does nothing, but it's a 
 *  convenient place to put any special code you want to execute 
 *  when a Room is first entered.  The firstSeen method is called 
 *  after the Room's description is displayed.
 *
 *  The initial method is called when isSeen is about to be set
 *  true for the first time (i.e., when the player first sees the
 *  Room); by default, this routine does nothing, but it's a 
 *  also another convenient place to put any special code you want
 *  to execute when a Room is first entered (see also firstSeen).
 *  The initial method is called before the Room's description is
 *  displayed.
 */
class Room: Roomable, Surface
    boardingPrep = "in"
    unboardingPrep = "out of"
;

#pragma C-

#endif /* _ROOM_H_ */
