////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ListGroupParenCount 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LIST_GROUP_PAREN_COUNT_H_
#define _LIST_GROUP_PAREN_COUNT_H_

#include <listgroup.h>
#include <itemcount.t>
#include <listcontgen.t>

#pragma C+

/*
 *  ListGroupParenCount: ListGroup
 *
 */
class ListGroupParenCount: ListGroup
    groupPrefix = nil
    groupSuffix = nil
    showList(desc, flags, indent) = {
        local t = self.getSizeOfGroup;
        
        flags = flags|LCG_NOLISTGROUP;
        
        if (t > 1
        && itemCount(self.groupList_) > 1) {
            flags = flags|LCG_SHOWPREFIX;
            desc = &groupDesc;
            "<<t>> ";
            if (proptype(self, &groupPrefix) != DTY_NIL)
                "<<self.groupPrefix>> ";
            "(";
            listContGen(self.groupList_, desc, flags, indent);
            if (t >1) {
                ")";
                if (proptype(self, &groupSuffix) != DTY_NIL)
                    " <<self.groupSuffix>>";
            }
        }
        else if (t > 0) {
            listContGen(self.groupList_, desc, flags, indent);
        }
    }
;

#pragma C-

#endif /* _LIST_GROUP_PAREN_COUNT_H_ */
