////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: KeyItem 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _KEY_ITEM_H_
#define _KEY_ITEM_H_

#include <item.h>

#pragma C+

/*
 *  KeyItem: Item
 *
 *  This is an object that can be used as a key for a KeyedLockable
 *  or LockableDoorway object.  It otherwise behaves as an ordinary Item.
 */
class KeyItem: Item
    verIoLockWith(actor) = {}
    ioLockWith(actor, dobj) = {
        dobj.doLockWith(actor, self);
    }
    verIoUnlockWith(actor) = {}
    ioUnlockWith(actor, dobj) = {
        dobj.doUnlockWith(actor, self);
    }
;

#pragma C-

#endif /* _KEY_ITEM_H_ */
