////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Callback 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CALLBACK_H_ 
#define _CALLBACK_H_

#pragma C+

/*
 *  Callback: object
 *
 *  The Callback class can be used for callback purposes. The callback
 *  object is passed one argument the self object of the caller. The
 *  callback object main() method can be used to update its attributes
 *  or those of another object.
 *
 *  If the callback object returns true then processing should continue;
 *  otherwise processing should stop.
 */
class Callback: object
    main(callingObj) = {
        /* Tell the caller to continue */
        return true;
    }
    initialize(...) = {}
    construct = {}
    destruct = {}
;  

lightingCallback: Callback
    lightFound = nil
    main(callingObj) = {
        if (callingObj.lightsOn)
            self.lightFound = true;
            
        /* Tell the caller to continue */
        return true;
    }
    initialize(...) = {self.lightFound = nil;}
;

#pragma C-

#endif  /* _CALLBACK_H_ */
