/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class TValue {
    public static int NUMBER = 1;
    public static int OBJECT = 2;
    public static int SSTRING = 3;
    public static int NIL = 5;
    public static int CODE = 6;
    public static int LIST = 7;
    public static int TRUE = 8;
    public static int DSTRING = 9;
    public static int FUNCTION = 10;
    public static int PROPERTY = 13;
    public static int DEMAND = 14;
    public static int SYNONYM = 15;
    public static int REDIR = 16;
    public static int TEMPLATE = 17;
    public static final String[] type_names = new String[]{"UNUSED", "number", "object", "sstring", "UNUSED", "nil", "code", "list", "true", "dstring", "function", "???", "???", "property", "demand", "synonym", "redir", "template"};
    int _type;
    int _int_value;
    String _str_value;
    Vector _list_value;
    byte[] _data_value;

    public TValue(int n, byte[] byArray) {
        this(n, byArray, 0, byArray.length);
    }

    public TValue(int n, byte[] byArray, int n2, int n3) {
        this._type = n;
        if (n == NUMBER) {
            this._int_value = GameFileParser.read_32signed(byArray, n2);
        } else if (n == OBJECT || n == FUNCTION || n == PROPERTY || n == SYNONYM || n == REDIR) {
            this._int_value = GameFileParser.read_16(byArray, n2);
        } else if (n != NIL && n != TRUE && n != DEMAND) {
            if (n == SSTRING || n == DSTRING) {
                this._str_value = new String(byArray, n2, n3 - n2);
            } else if (n == CODE) {
                this._data_value = new byte[n3 - n2];
                System.arraycopy(byArray, n2, this._data_value, 0, n3 - n2);
            } else if (n == LIST) {
                this._list_value = new Vector(5);
                while (n2 < n3) {
                    byte by = byArray[n2++];
                    TValue tValue = null;
                    if (by == NUMBER) {
                        tValue = new TValue(by, byArray, n2, n2 + 4);
                        n2 += 4;
                    } else if (by == OBJECT || by == FUNCTION || by == PROPERTY) {
                        tValue = new TValue(by, byArray, n2, n2 + 2);
                        n2 += 2;
                    } else if (by == NIL || by == TRUE) {
                        tValue = new TValue(by, byArray, n2, n2);
                    } else if (by == SSTRING || by == LIST) {
                        int n4 = GameFileParser.read_16(byArray, n2) - 2;
                        tValue = new TValue(by, byArray, n2 += 2, n2 + n4);
                        n2 += n4;
                    } else {
                        Jetty.out.print_error("Unknown type of list member: " + by, 1);
                        n2 = n3;
                    }
                    this._list_value.addElement(tValue);
                }
            } else if (n == TEMPLATE) {
                int n5 = GameFileParser.read_8(byArray, n2++);
                this._list_value = new Vector(n5);
                int n6 = 0;
                while (n6 < n5) {
                    int[] nArray = new int[6];
                    nArray[0] = GameFileParser.read_16signed(byArray, n2 + 0);
                    if (nArray[0] == -1) {
                        nArray[0] = 0;
                    }
                    nArray[1] = GameFileParser.read_16(byArray, n2 + 2);
                    nArray[2] = GameFileParser.read_16(byArray, n2 + 4);
                    nArray[3] = GameFileParser.read_16(byArray, n2 + 6);
                    nArray[4] = GameFileParser.read_16(byArray, n2 + 8);
                    nArray[5] = GameFileParser.read_8(byArray, n2 + 10);
                    n2 += 16;
                    this._list_value.addElement(nArray);
                    ++n6;
                }
            } else {
                Jetty.out.print_error("Unknown type in TValue constructor", 1);
            }
        }
    }

    public TValue(int n, int n2) {
        this._type = n;
        if (n == NUMBER || n == OBJECT || n == FUNCTION || n == PROPERTY) {
            this._int_value = n2;
        } else if (n != NIL && n != TRUE && n != DEMAND) {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue(int n, String string) {
        this._type = n;
        if (n == SSTRING) {
            this._str_value = string;
        } else {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue(int n, Vector vector) {
        this._type = n;
        if (n == LIST) {
            this._list_value = vector;
        } else {
            Jetty.out.print_error("Illegal type in this TValue constructor: " + n, 1);
        }
    }

    public TValue do_clone() {
        TValue tValue = new TValue(NUMBER, 0);
        tValue.copy(this);
        return tValue;
    }

    public void copy(TValue tValue) {
        if (tValue == this) {
            Jetty.out.print_error("copying onto self; not really doing it", 2);
            return;
        }
        this._type = tValue._type;
        if (this._type == NUMBER || this._type == OBJECT || this._type == FUNCTION || this._type == PROPERTY || this._type == SYNONYM || this._type == REDIR) {
            this._int_value = tValue._int_value;
        } else if (this._type != NIL && this._type != TRUE && this._type != DEMAND) {
            if (this._type == SSTRING || this._type == DSTRING) {
                this._str_value = tValue._str_value;
            } else if (this._type == CODE) {
                this._data_value = tValue._data_value;
            } else if (this._type == LIST) {
                this._list_value = new Vector(tValue._list_value.size());
                int n = 0;
                while (n < tValue._list_value.size()) {
                    this._list_value.addElement(((TValue)tValue._list_value.elementAt(n)).do_clone());
                    ++n;
                }
            } else if (this._type == TEMPLATE) {
                this._list_value = tValue._list_value;
            } else {
                Jetty.out.print_error("Unknown type in TValue copy(): " + this._type, 1);
            }
        }
    }

    public int get_type() {
        return this._type;
    }

    public boolean must_be(int n) {
        if (this._type != n) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public boolean must_be(int n, int n2) {
        if (this._type != n && this._type != n2) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + " or " + type_names[n2] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public boolean must_be(int n, int n2, int n3) {
        if (this._type != n && this._type != n2 && this._type != n3) {
            Jetty.out.print_error("Error: wrong type -- expected " + type_names[n] + ", " + type_names[n2] + ", or " + type_names[n3] + ", found " + type_names[this._type], 1);
            return false;
        }
        return true;
    }

    public int get_number() throws HaltTurnException {
        if (!this.must_be(NUMBER)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public boolean get_logical() {
        if (this._type != NUMBER && this._type != TRUE && this._type != NIL) {
            return true;
        }
        this.must_be(NUMBER, TRUE, NIL);
        if (this._type == TRUE) {
            return true;
        }
        if (this._type == NIL) {
            return false;
        }
        return this._int_value != 0;
    }

    public String get_string() throws HaltTurnException {
        if (!this.must_be(SSTRING)) {
            throw new HaltTurnException(-10);
        }
        return this._str_value;
    }

    public String get_dstring() throws HaltTurnException {
        if (!this.must_be(DSTRING)) {
            throw new HaltTurnException(-10);
        }
        return this._str_value;
    }

    public Vector get_list() throws HaltTurnException {
        if (!this.must_be(LIST)) {
            throw new HaltTurnException(-10);
        }
        return this._list_value;
    }

    public int get_object() throws HaltTurnException {
        if (!this.must_be(OBJECT)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_function() throws HaltTurnException {
        if (!this.must_be(FUNCTION)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_property() throws HaltTurnException {
        if (!this.must_be(PROPERTY)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_redir() throws HaltTurnException {
        if (!this.must_be(REDIR)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public int get_synonym() throws HaltTurnException {
        if (!this.must_be(SYNONYM)) {
            throw new HaltTurnException(-10);
        }
        return this._int_value;
    }

    public byte[] get_code() throws HaltTurnException {
        if (!this.must_be(CODE)) {
            throw new HaltTurnException(-10);
        }
        return this._data_value;
    }

    public Vector get_template() throws HaltTurnException {
        if (!this.must_be(TEMPLATE)) {
            throw new HaltTurnException(-10);
        }
        return this._list_value;
    }

    public int get_comparison(TValue tValue) throws HaltTurnException {
        if (this._type == tValue._type) {
            if (!this.must_be(NUMBER, SSTRING)) {
                throw new HaltTurnException(-10);
            }
            if (this._type == NUMBER) {
                return this._int_value == tValue._int_value ? 0 : (this._int_value < tValue._int_value ? -1 : 1);
            }
            int n = this._str_value.compareTo(tValue._str_value);
            return n == 0 ? 0 : (n < 0 ? -1 : 1);
        }
        Jetty.out.print_error("Mismatched types in comparison: " + type_names[this._type] + " and " + type_names[tValue._type], 1);
        throw new HaltTurnException(-10);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TValue)) {
            return false;
        }
        TValue tValue = (TValue)object;
        if (this._type != tValue._type) {
            return false;
        }
        if (this._type == NUMBER || this._type == OBJECT || this._type == FUNCTION || this._type == PROPERTY || this._type == SYNONYM || this._type == REDIR) {
            return this._int_value == tValue._int_value;
        }
        if (this._type == NIL || this._type == TRUE) {
            return true;
        }
        if (this._type == SSTRING || this._type == DSTRING) {
            return this._str_value.equals(tValue._str_value);
        }
        if (this._type == LIST) {
            if (this._list_value.size() != tValue._list_value.size()) {
                return false;
            }
            int n = 0;
            while (n < this._list_value.size()) {
                if (!((TValue)this._list_value.elementAt(n)).equals(tValue._list_value.elementAt(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }
}

