/*
 *	SAMPLE2.T: 			Version 3.1		
 *						A VERY SIMPLE GAME
 *
 *	Copyright (c) 1999.	All Rights Reserved.
 *
 *  This file is part of TimeSys:  Advanced Timekeeping System for TADS.
 *
 *	This file contains A Very Simple Game, as discussed in the TADS 
 *	author's manual, adapted to illustrate the use of the TimeSys functions
 *	and waitingVerb grammar.
 *
 *	REQUIRES HTML TADS 2.3.0 OR LATER.
 *
 *------------------------------------------------------------------------------
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *	MODIFICATION HISTORY
 *------------------------------------------------------------------------------
 *		01-Jan-99:	Creation.
 *		20-May-99:	Added USE_HTML_STATUS to source and cleaned up appearance.
 *		25-May-99:	Added #include for ppo.t and moved init() coding to
 *					commonInit(). Modified global.eatTime() and
 *					global.sleepTime(), extending them to a week.
 *      16-Mar-00:  Replaced settimesys() function call to reflect new
 *                  syntax.
 */

#define USE_HTML_STATUS
#include <adv.t>
#include <std.t>
#include <ppo.t>
#include <timesys.t>

class outdoors: darkroom
	lightsOn = nil
	lightlevel  = 0
	lighting( time ) =
	{
		if ( time >= 390 and time < 420 )			// sunrise 6:30 am - 7:00 am
		{
			if ( self.lightsOn = nil )
			{ 
				"<P>Visibility increases in the gathering light of a new day. ";
				self.lightsOn := true;
				self.lightlevel := 1;
				stopwaiting( true );
			}
		}
		else if ( time >= 420 and time < 1170 )		// day 7:00 am - 7:30 pm 
		{
			if ( self.lightlevel = 1 )
			{
				"<P>The sun comes up, as much as it ever comes up here. ";
				self.lightsOn := true;
				self.lightlevel := 2;
				stopwaiting( true );
			}
		}
		else if ( time >= 1170 and time < 1200 )		// sunset 7:30 pm - 8:00 pm
		{
			if ( self.lightlevel = 2 )
			{
				"<P>Daylight begins to fade, soon it will be dark. ";
				self.lightlevel := 3;
				stopwaiting( true );
			}
		}
		else										// night 8:00 pm - 6:30 am
		{
			if ( self.lightsOn = true )
			{
				"<P>Darkness falls and the mists come in. ";
				self.lightsOn := nil;
				self.lightlevel := 0;
				stopwaiting( true );
			}
		}	
	}
;

modify timesys
	events =
	{
		outdoors.lighting( self.time );		// regulates the lighting outdoors
	}
;

brassLamp: lightsource
	location = startroom
	sdesc = "lamp"
	noun = 'lamp' 'lantern' 'light'
	adjective = 'battered' 'old' 'brass'
	ldesc = "It is a battered old brass lamp that has accompanied you on many
		adventures in the past. "
	islit = true
	verDoTurnon( actor ) = 
	{
		if ( self.islit )
		{
			"But the lamp is already lit!";
		}
	}
	doTurnon( actor ) =
	{
		self.islit := true;
		"You turn up the wick. The lamp emits a warm glow that 
		lights up the area around you. <P>";
		actor.location.lookAround( true );
		actor.location.isseen := true;
	}
	verDoTurnoff( actor ) = 
	{
		if ( not self.islit )
		{
			"The lamp is already out.";
		}
	}
	doTurnoff( actor ) =
	{
		self.islit := nil;
		"You turn down the wick. The lamp goes dark. ";
	}
;

startroom: outdoors
	sdesc = "Outside cave"
	ldesc =
	{
		 "You're standing ";
		switch( self.lightlevel )
		{
			case 2:
				" in the bright sunlight ";
				break;
			default:
				break;
		}
		"just outside of a large, dark, foreboding cave, which
		lies to the north. ";
	}
	north = cave						/* the room called "cave" lies to the north */
;

cave: outdoors
	sdesc = "Cave"
	ldesc = 
	{
		"You're inside a dark and musty cave. ";
		switch( self.lightlevel )
		{
			case 2: "Sunlight pours in from a passage to
				the south. ";
				break;
			default: "In the shadowy gloom you can just make out a 
				passage to the south. ";
				break;
		}
	}
	south = startroom
;

pedestal: surface,  fixeditem
	sdesc = "pedestal"
	noun = 'pedestal'
	location = cave
;

goldSkull: item
	sdesc = "gold skull"
	noun = 'skull' 'head'
	adjective = 'gold'
	location = pedestal
	doTake (actor) =
	{
		if ( self.location <> pedestal or smallRock.location = pedestal )
		{
			pass doTake;
		}
		else
		{
			"As you lift the skull, a volley of poisonous
			arrows is shot from the walls! You try to
			dodge the arrows, but they take you by surprise! \b
			Suddenly everything starts to spin. You pass out and 
			fall to the ground. Sometime later you awaken and stumble
			back to your feet. ";
			advtimesys( '6:00 a.m.', nil );
		}
	}
;

smallRock: item
	sdesc = "small rock"
	noun = 'rock'
	adjective = 'small'
	location = cave
;

modify global
	eatTime = 10080
	sleepTime = 10080
;

replace commonInit: function
{
  	/*
   	 *  The \H+ bit is the magical incantation that
   	 *  instructs the TADS interpreter that henceforth
   	 *  we want HTML to be parsed as HTML rather than
   	 *  displayed as text for the user to puzzle over.
   	 */
  	"\H+";

  	"<TITLE>TimeSys: Advanced Timekeeping System Sample2</TITLE>";    // set the window title
	
  	/* set the page colour to blue w/ white text */
  	"<BODY BGCOLOR=\"#0000AA\" TEXT=\"#FFFFFF\">";
  	
	settimesys( '5:00 a.m.', 5, 1887, 6, 17 );
}
;
