/*
 *	SAMPLE.T: 			Version 3.1	
 *						THE DITCH.T ADAPTION
 *
 *	Copyright (c) 1999.	All Rights Reserved.
 *
 *  This file is part of TimeSys:  Advanced Timekeeping System for TADS.
 *
 *	This file contains the coding required to adapt Ditch Day Drifter to 
 *	time-oriented game play, as discussed in Chapter 1 of the TimeSys
 *	authoring manual. It will require a copy of ditch.t and the HTML TADS
 *	compiler as well as the TimeSys files supplied.
 *
 *	Enjoy Ditch Day a whole new way! Oh, and don't be late for class...
 *
 *	REQUIRES HTML TADS 2.3.0 OR LATER
 *
 *------------------------------------------------------------------------------
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *	MODIFICATION HISTORY
 *------------------------------------------------------------------------------
 *		01-Jan-99:	Creation.
 *
 *		20-May-99:	Cleaned up the appearance of the file.
 *					Changed references to htmlBanner to global.
 *
 *		25-May-99:	Added #include for ppo.t. Changed settimesys()
 *					to use string format time parameter.
 *		12-Jun-99:	Replaced gettimesys() function call to reflect new function
 *					syntax.
 *      16-Mar-00:  Replaced settimesys() function call to reflect new
 *                  function syntax.
 */

#define USE_HTML_STATUS
#include <ditch.t>
#include <ppo.t>
#include <timesys.t>
 

/*
 *   The init() function is run at the very beginning of the game.
 *   We display some introductory text, then move the player (Me) to the
 *   initial location and set up some background activity.
 *
 *	Modified for timesys with HTML indicator and settimesys()
 */
replace init: function
{
    "\tYou wake up to the sound of voices in the hall. You are confused for
    a moment; it's only 8 AM, far too early for anyone to be getting up.
    Then, it dawns on you: it's ditch day here at the fictitious California
    Institute of Technology in the mythical city of Pasadena, California.
    \(Ditch Day\), that strange tradition wherein seniors bar their doors with
    various devices and underclassmen attempt to defeat these devices (for
    no other apparent reason than that the devices are there), has arrived.\b";
    
    version.sdesc;                // display the game's name and version number
    "\b";
    
    setdaemon( turncount, nil );               // start the turn counter daemon
    setdaemon( sleepDaemon, nil );                    // start the sleep daemon
    setdaemon( eatDaemon, nil );                     // start the hunger daemon
    Me.location := startroom;                // move player to initial location
    startroom.lookAround( true );                    // show player where he is
    startroom.isseen := true;    
    settimesys( '11:50 p.m.', 1, 1999, 12, 31 );
    "\H+";
}
;

/*
 *   The scoreRank() function displays how well the player is doing.
 *   In addition to displaying the numerical score and number of turns
 *   played so far, we'll classify the score with a rank such as "sophomore."
 *
 *   Note that "global.maxscore" defines the maximum number of points
 *   possible in the game.
 */
replace scoreRank: function
{
    local s;
    
    s := global.score;
    
 	if ( global.timeStatus = nil or global.timeStatus = 1 )
	{
		"In a total of "; say( gettimesys( TS_ELAPSE, timesys.elapsetime, nil ) );
		", you have achieved a score of ";
		say( global.score ); " points out of a possible ";
		say( global.maxscore ); ".\n";
	}
	else
	{
   		 "In a total of "; say(global.turnsofar);
   		 " turns, you have achieved a score of ";
    		say(global.score); " points out of a possible ";
    		say(global.maxscore); ".\n";
	}
    ", which gives you a rank of ";
    
    if ( s < 10 ) "high-school hopeful";
    else if ( s < 25 ) "freshman";
    else if ( s < 40 ) "sophomore";
    else if ( s < 60 ) "junior";
    else if ( s < global.maxscore ) "senior";
    else "graduate";
    
    ". ";
}
;
